<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.Customer4Printing StructType
 * @subpackage Structs
 */
class Crm_Customer4Printing extends Crm_Client
{
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Age;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BlackListItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_CustomerBlackListItem
     */
    public $BlackListItems;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardId;
    /**
     * The DateOfDeath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfDeath;
    /**
     * The ExtendedStronglyRelatedClients
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_RelatedClient
     */
    public $ExtendedStronglyRelatedClients;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The GeoDemographicCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GeoDemographicCodeId;
    /**
     * The ImportBatchFileName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportBatchFileName;
    /**
     * The ImportBatchId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImportBatchId;
    /**
     * The ImportBatchNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportBatchNotes;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The IsHouseholdRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHouseholdRepresentative;
    /**
     * The IsSalesRep
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSalesRep;
    /**
     * The JobTitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JobTitleId;
    /**
     * The MaritalStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MaritalStatusId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PersonName4Printing
     */
    public $Name;
    /**
     * The RelativeLeaderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelativeLeaderId;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The StronglyRelatedClients
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_StronglyRelatedClient
     */
    public $StronglyRelatedClients;
    /**
     * The TitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TitleId;
    /**
     * The UnpaddingCardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnpaddingCardId;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * Constructor method for Crm.Customer4Printing
     * @uses Crm_Customer4Printing::setAge()
     * @uses Crm_Customer4Printing::setBirthday()
     * @uses Crm_Customer4Printing::setBlackListItems()
     * @uses Crm_Customer4Printing::setCardId()
     * @uses Crm_Customer4Printing::setDateOfDeath()
     * @uses Crm_Customer4Printing::setExtendedStronglyRelatedClients()
     * @uses Crm_Customer4Printing::setGender()
     * @uses Crm_Customer4Printing::setGeoDemographicCodeId()
     * @uses Crm_Customer4Printing::setImportBatchFileName()
     * @uses Crm_Customer4Printing::setImportBatchId()
     * @uses Crm_Customer4Printing::setImportBatchNotes()
     * @uses Crm_Customer4Printing::setIsDeceased()
     * @uses Crm_Customer4Printing::setIsHouseholdRepresentative()
     * @uses Crm_Customer4Printing::setIsSalesRep()
     * @uses Crm_Customer4Printing::setJobTitleId()
     * @uses Crm_Customer4Printing::setMaritalStatusId()
     * @uses Crm_Customer4Printing::setName()
     * @uses Crm_Customer4Printing::setRelativeLeaderId()
     * @uses Crm_Customer4Printing::setSalesRepId()
     * @uses Crm_Customer4Printing::setStronglyRelatedClients()
     * @uses Crm_Customer4Printing::setTitleId()
     * @uses Crm_Customer4Printing::setUnpaddingCardId()
     * @uses Crm_Customer4Printing::setWorkPlace()
     * @param int $age
     * @param string $birthday
     * @param \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems
     * @param string $cardId
     * @param string $dateOfDeath
     * @param \patest\StructType\RecordSetOfCrm_RelatedClient $extendedStronglyRelatedClients
     * @param string $gender
     * @param string $geoDemographicCodeId
     * @param string $importBatchFileName
     * @param string $importBatchId
     * @param string $importBatchNotes
     * @param bool $isDeceased
     * @param bool $isHouseholdRepresentative
     * @param bool $isSalesRep
     * @param string $jobTitleId
     * @param string $maritalStatusId
     * @param \patest\StructType\Crm_PersonName4Printing $name
     * @param string $relativeLeaderId
     * @param string $salesRepId
     * @param \patest\StructType\RecordSetOfCrm_StronglyRelatedClient $stronglyRelatedClients
     * @param string $titleId
     * @param string $unpaddingCardId
     * @param string $workPlace
     */
    public function __construct($age = null, $birthday = null, \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems = null, $cardId = null, $dateOfDeath = null, \patest\StructType\RecordSetOfCrm_RelatedClient $extendedStronglyRelatedClients = null, $gender = null, $geoDemographicCodeId = null, $importBatchFileName = null, $importBatchId = null, $importBatchNotes = null, $isDeceased = null, $isHouseholdRepresentative = null, $isSalesRep = null, $jobTitleId = null, $maritalStatusId = null, \patest\StructType\Crm_PersonName4Printing $name = null, $relativeLeaderId = null, $salesRepId = null, \patest\StructType\RecordSetOfCrm_StronglyRelatedClient $stronglyRelatedClients = null, $titleId = null, $unpaddingCardId = null, $workPlace = null)
    {
        $this
            ->setAge($age)
            ->setBirthday($birthday)
            ->setBlackListItems($blackListItems)
            ->setCardId($cardId)
            ->setDateOfDeath($dateOfDeath)
            ->setExtendedStronglyRelatedClients($extendedStronglyRelatedClients)
            ->setGender($gender)
            ->setGeoDemographicCodeId($geoDemographicCodeId)
            ->setImportBatchFileName($importBatchFileName)
            ->setImportBatchId($importBatchId)
            ->setImportBatchNotes($importBatchNotes)
            ->setIsDeceased($isDeceased)
            ->setIsHouseholdRepresentative($isHouseholdRepresentative)
            ->setIsSalesRep($isSalesRep)
            ->setJobTitleId($jobTitleId)
            ->setMaritalStatusId($maritalStatusId)
            ->setName($name)
            ->setRelativeLeaderId($relativeLeaderId)
            ->setSalesRepId($salesRepId)
            ->setStronglyRelatedClients($stronglyRelatedClients)
            ->setTitleId($titleId)
            ->setUnpaddingCardId($unpaddingCardId)
            ->setWorkPlace($workPlace);
    }
    /**
     * Get Age value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAge()
    {
        return isset($this->Age) ? $this->Age : null;
    }
    /**
     * Set Age value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $age
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        if (is_null($age) || (is_array($age) && empty($age))) {
            unset($this->Age);
        } else {
            $this->Age = $age;
        }
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get BlackListItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_CustomerBlackListItem|null
     */
    public function getBlackListItems()
    {
        return isset($this->BlackListItems) ? $this->BlackListItems : null;
    }
    /**
     * Set BlackListItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setBlackListItems(\patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems = null)
    {
        if (is_null($blackListItems) || (is_array($blackListItems) && empty($blackListItems))) {
            unset($this->BlackListItems);
        } else {
            $this->BlackListItems = $blackListItems;
        }
        return $this;
    }
    /**
     * Get CardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->CardId) ? $this->CardId : null;
    }
    /**
     * Set CardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->CardId);
        } else {
            $this->CardId = $cardId;
        }
        return $this;
    }
    /**
     * Get DateOfDeath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfDeath()
    {
        return isset($this->DateOfDeath) ? $this->DateOfDeath : null;
    }
    /**
     * Set DateOfDeath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfDeath
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setDateOfDeath($dateOfDeath = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeath) && !is_string($dateOfDeath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeath, true), gettype($dateOfDeath)), __LINE__);
        }
        if (is_null($dateOfDeath) || (is_array($dateOfDeath) && empty($dateOfDeath))) {
            unset($this->DateOfDeath);
        } else {
            $this->DateOfDeath = $dateOfDeath;
        }
        return $this;
    }
    /**
     * Get ExtendedStronglyRelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_RelatedClient|null
     */
    public function getExtendedStronglyRelatedClients()
    {
        return isset($this->ExtendedStronglyRelatedClients) ? $this->ExtendedStronglyRelatedClients : null;
    }
    /**
     * Set ExtendedStronglyRelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_RelatedClient $extendedStronglyRelatedClients
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setExtendedStronglyRelatedClients(\patest\StructType\RecordSetOfCrm_RelatedClient $extendedStronglyRelatedClients = null)
    {
        if (is_null($extendedStronglyRelatedClients) || (is_array($extendedStronglyRelatedClients) && empty($extendedStronglyRelatedClients))) {
            unset($this->ExtendedStronglyRelatedClients);
        } else {
            $this->ExtendedStronglyRelatedClients = $extendedStronglyRelatedClients;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get GeoDemographicCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeoDemographicCodeId()
    {
        return isset($this->GeoDemographicCodeId) ? $this->GeoDemographicCodeId : null;
    }
    /**
     * Set GeoDemographicCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geoDemographicCodeId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setGeoDemographicCodeId($geoDemographicCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($geoDemographicCodeId) && !is_string($geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoDemographicCodeId, true), gettype($geoDemographicCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($geoDemographicCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($geoDemographicCodeId, true)), __LINE__);
        }
        if (is_null($geoDemographicCodeId) || (is_array($geoDemographicCodeId) && empty($geoDemographicCodeId))) {
            unset($this->GeoDemographicCodeId);
        } else {
            $this->GeoDemographicCodeId = $geoDemographicCodeId;
        }
        return $this;
    }
    /**
     * Get ImportBatchFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportBatchFileName()
    {
        return isset($this->ImportBatchFileName) ? $this->ImportBatchFileName : null;
    }
    /**
     * Set ImportBatchFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importBatchFileName
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setImportBatchFileName($importBatchFileName = null)
    {
        // validation for constraint: string
        if (!is_null($importBatchFileName) && !is_string($importBatchFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importBatchFileName, true), gettype($importBatchFileName)), __LINE__);
        }
        if (is_null($importBatchFileName) || (is_array($importBatchFileName) && empty($importBatchFileName))) {
            unset($this->ImportBatchFileName);
        } else {
            $this->ImportBatchFileName = $importBatchFileName;
        }
        return $this;
    }
    /**
     * Get ImportBatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportBatchId()
    {
        return isset($this->ImportBatchId) ? $this->ImportBatchId : null;
    }
    /**
     * Set ImportBatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importBatchId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setImportBatchId($importBatchId = null)
    {
        // validation for constraint: string
        if (!is_null($importBatchId) && !is_string($importBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importBatchId, true), gettype($importBatchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($importBatchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $importBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($importBatchId, true)), __LINE__);
        }
        if (is_null($importBatchId) || (is_array($importBatchId) && empty($importBatchId))) {
            unset($this->ImportBatchId);
        } else {
            $this->ImportBatchId = $importBatchId;
        }
        return $this;
    }
    /**
     * Get ImportBatchNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportBatchNotes()
    {
        return isset($this->ImportBatchNotes) ? $this->ImportBatchNotes : null;
    }
    /**
     * Set ImportBatchNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importBatchNotes
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setImportBatchNotes($importBatchNotes = null)
    {
        // validation for constraint: string
        if (!is_null($importBatchNotes) && !is_string($importBatchNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importBatchNotes, true), gettype($importBatchNotes)), __LINE__);
        }
        if (is_null($importBatchNotes) || (is_array($importBatchNotes) && empty($importBatchNotes))) {
            unset($this->ImportBatchNotes);
        } else {
            $this->ImportBatchNotes = $importBatchNotes;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get IsHouseholdRepresentative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHouseholdRepresentative()
    {
        return isset($this->IsHouseholdRepresentative) ? $this->IsHouseholdRepresentative : null;
    }
    /**
     * Set IsHouseholdRepresentative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHouseholdRepresentative
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setIsHouseholdRepresentative($isHouseholdRepresentative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHouseholdRepresentative) && !is_bool($isHouseholdRepresentative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHouseholdRepresentative, true), gettype($isHouseholdRepresentative)), __LINE__);
        }
        if (is_null($isHouseholdRepresentative) || (is_array($isHouseholdRepresentative) && empty($isHouseholdRepresentative))) {
            unset($this->IsHouseholdRepresentative);
        } else {
            $this->IsHouseholdRepresentative = $isHouseholdRepresentative;
        }
        return $this;
    }
    /**
     * Get IsSalesRep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSalesRep()
    {
        return isset($this->IsSalesRep) ? $this->IsSalesRep : null;
    }
    /**
     * Set IsSalesRep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSalesRep
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setIsSalesRep($isSalesRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesRep) && !is_bool($isSalesRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesRep, true), gettype($isSalesRep)), __LINE__);
        }
        if (is_null($isSalesRep) || (is_array($isSalesRep) && empty($isSalesRep))) {
            unset($this->IsSalesRep);
        } else {
            $this->IsSalesRep = $isSalesRep;
        }
        return $this;
    }
    /**
     * Get JobTitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleId()
    {
        return isset($this->JobTitleId) ? $this->JobTitleId : null;
    }
    /**
     * Set JobTitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitleId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setJobTitleId($jobTitleId = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitleId) && !is_string($jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitleId, true), gettype($jobTitleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jobTitleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jobTitleId, true)), __LINE__);
        }
        if (is_null($jobTitleId) || (is_array($jobTitleId) && empty($jobTitleId))) {
            unset($this->JobTitleId);
        } else {
            $this->JobTitleId = $jobTitleId;
        }
        return $this;
    }
    /**
     * Get MaritalStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaritalStatusId()
    {
        return isset($this->MaritalStatusId) ? $this->MaritalStatusId : null;
    }
    /**
     * Set MaritalStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maritalStatusId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setMaritalStatusId($maritalStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatusId) && !is_string($maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatusId, true), gettype($maritalStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($maritalStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($maritalStatusId, true)), __LINE__);
        }
        if (is_null($maritalStatusId) || (is_array($maritalStatusId) && empty($maritalStatusId))) {
            unset($this->MaritalStatusId);
        } else {
            $this->MaritalStatusId = $maritalStatusId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PersonName4Printing|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PersonName4Printing $name
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setName(\patest\StructType\Crm_PersonName4Printing $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RelativeLeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelativeLeaderId()
    {
        return isset($this->RelativeLeaderId) ? $this->RelativeLeaderId : null;
    }
    /**
     * Set RelativeLeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relativeLeaderId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setRelativeLeaderId($relativeLeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($relativeLeaderId) && !is_string($relativeLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativeLeaderId, true), gettype($relativeLeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relativeLeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relativeLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relativeLeaderId, true)), __LINE__);
        }
        if (is_null($relativeLeaderId) || (is_array($relativeLeaderId) && empty($relativeLeaderId))) {
            unset($this->RelativeLeaderId);
        } else {
            $this->RelativeLeaderId = $relativeLeaderId;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get StronglyRelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_StronglyRelatedClient|null
     */
    public function getStronglyRelatedClients()
    {
        return isset($this->StronglyRelatedClients) ? $this->StronglyRelatedClients : null;
    }
    /**
     * Set StronglyRelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_StronglyRelatedClient $stronglyRelatedClients
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setStronglyRelatedClients(\patest\StructType\RecordSetOfCrm_StronglyRelatedClient $stronglyRelatedClients = null)
    {
        if (is_null($stronglyRelatedClients) || (is_array($stronglyRelatedClients) && empty($stronglyRelatedClients))) {
            unset($this->StronglyRelatedClients);
        } else {
            $this->StronglyRelatedClients = $stronglyRelatedClients;
        }
        return $this;
    }
    /**
     * Get TitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleId()
    {
        return isset($this->TitleId) ? $this->TitleId : null;
    }
    /**
     * Set TitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titleId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: string
        if (!is_null($titleId) && !is_string($titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleId, true), gettype($titleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($titleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($titleId, true)), __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->TitleId);
        } else {
            $this->TitleId = $titleId;
        }
        return $this;
    }
    /**
     * Get UnpaddingCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnpaddingCardId()
    {
        return isset($this->UnpaddingCardId) ? $this->UnpaddingCardId : null;
    }
    /**
     * Set UnpaddingCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unpaddingCardId
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setUnpaddingCardId($unpaddingCardId = null)
    {
        // validation for constraint: string
        if (!is_null($unpaddingCardId) && !is_string($unpaddingCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unpaddingCardId, true), gettype($unpaddingCardId)), __LINE__);
        }
        if (is_null($unpaddingCardId) || (is_array($unpaddingCardId) && empty($unpaddingCardId))) {
            unset($this->UnpaddingCardId);
        } else {
            $this->UnpaddingCardId = $unpaddingCardId;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\Crm_Customer4Printing
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
}
