<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ContactType StructType
 * @subpackage Structs
 */
class Crm_ContactType extends DistributableEntity
{
    /**
     * The AvailableCommunicationServiceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AvailableCommunicationServiceIds
     */
    public $AvailableCommunicationServiceIds;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayName;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Format;
    /**
     * The InternationalCodeRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InternationalCodeRequired;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Crm.ContactType
     * @uses Crm_ContactType::setAvailableCommunicationServiceIds()
     * @uses Crm_ContactType::setDisplayName()
     * @uses Crm_ContactType::setFormat()
     * @uses Crm_ContactType::setInternationalCodeRequired()
     * @uses Crm_ContactType::setIsActive()
     * @uses Crm_ContactType::setOrdinal()
     * @uses Crm_ContactType::setSystemName()
     * @uses Crm_ContactType::setType()
     * @param \patest\StructType\AvailableCommunicationServiceIds $availableCommunicationServiceIds
     * @param \patest\StructType\GlobalString $displayName
     * @param string $format
     * @param bool $internationalCodeRequired
     * @param bool $isActive
     * @param int $ordinal
     * @param string $systemName
     * @param string $type
     */
    public function __construct(\patest\StructType\AvailableCommunicationServiceIds $availableCommunicationServiceIds = null, \patest\StructType\GlobalString $displayName = null, $format = null, $internationalCodeRequired = null, $isActive = null, $ordinal = null, $systemName = null, $type = null)
    {
        $this
            ->setAvailableCommunicationServiceIds($availableCommunicationServiceIds)
            ->setDisplayName($displayName)
            ->setFormat($format)
            ->setInternationalCodeRequired($internationalCodeRequired)
            ->setIsActive($isActive)
            ->setOrdinal($ordinal)
            ->setSystemName($systemName)
            ->setType($type);
    }
    /**
     * Get AvailableCommunicationServiceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AvailableCommunicationServiceIds|null
     */
    public function getAvailableCommunicationServiceIds()
    {
        return isset($this->AvailableCommunicationServiceIds) ? $this->AvailableCommunicationServiceIds : null;
    }
    /**
     * Set AvailableCommunicationServiceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AvailableCommunicationServiceIds $availableCommunicationServiceIds
     * @return \patest\StructType\Crm_ContactType
     */
    public function setAvailableCommunicationServiceIds(\patest\StructType\AvailableCommunicationServiceIds $availableCommunicationServiceIds = null)
    {
        if (is_null($availableCommunicationServiceIds) || (is_array($availableCommunicationServiceIds) && empty($availableCommunicationServiceIds))) {
            unset($this->AvailableCommunicationServiceIds);
        } else {
            $this->AvailableCommunicationServiceIds = $availableCommunicationServiceIds;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayName
     * @return \patest\StructType\Crm_ContactType
     */
    public function setDisplayName(\patest\StructType\GlobalString $displayName = null)
    {
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormat()
    {
        return isset($this->Format) ? $this->Format : null;
    }
    /**
     * Set Format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $format
     * @return \patest\StructType\Crm_ContactType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->Format);
        } else {
            $this->Format = $format;
        }
        return $this;
    }
    /**
     * Get InternationalCodeRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInternationalCodeRequired()
    {
        return isset($this->InternationalCodeRequired) ? $this->InternationalCodeRequired : null;
    }
    /**
     * Set InternationalCodeRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $internationalCodeRequired
     * @return \patest\StructType\Crm_ContactType
     */
    public function setInternationalCodeRequired($internationalCodeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($internationalCodeRequired) && !is_bool($internationalCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($internationalCodeRequired, true), gettype($internationalCodeRequired)), __LINE__);
        }
        if (is_null($internationalCodeRequired) || (is_array($internationalCodeRequired) && empty($internationalCodeRequired))) {
            unset($this->InternationalCodeRequired);
        } else {
            $this->InternationalCodeRequired = $internationalCodeRequired;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_ContactType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Crm_ContactType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Crm_ContactType
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ContactTypeKind::valueIsValid()
     * @uses \patest\EnumType\ContactTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Crm_ContactType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ContactTypeKind::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ContactTypeKind', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\ContactTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
