<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientBalance StructType
 * @subpackage Structs
 */
class Crm_ClientBalance extends AnyEntity
{
    /**
     * The DepositBalance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DepositBalance;
    /**
     * The RefundVoucherBalance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RefundVoucherBalance;
    /**
     * Constructor method for Crm.ClientBalance
     * @uses Crm_ClientBalance::setDepositBalance()
     * @uses Crm_ClientBalance::setRefundVoucherBalance()
     * @param \patest\StructType\Money $depositBalance
     * @param \patest\StructType\Money $refundVoucherBalance
     */
    public function __construct(\patest\StructType\Money $depositBalance = null, \patest\StructType\Money $refundVoucherBalance = null)
    {
        $this
            ->setDepositBalance($depositBalance)
            ->setRefundVoucherBalance($refundVoucherBalance);
    }
    /**
     * Get DepositBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDepositBalance()
    {
        return isset($this->DepositBalance) ? $this->DepositBalance : null;
    }
    /**
     * Set DepositBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $depositBalance
     * @return \patest\StructType\Crm_ClientBalance
     */
    public function setDepositBalance(\patest\StructType\Money $depositBalance = null)
    {
        if (is_null($depositBalance) || (is_array($depositBalance) && empty($depositBalance))) {
            unset($this->DepositBalance);
        } else {
            $this->DepositBalance = $depositBalance;
        }
        return $this;
    }
    /**
     * Get RefundVoucherBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRefundVoucherBalance()
    {
        return isset($this->RefundVoucherBalance) ? $this->RefundVoucherBalance : null;
    }
    /**
     * Set RefundVoucherBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $refundVoucherBalance
     * @return \patest\StructType\Crm_ClientBalance
     */
    public function setRefundVoucherBalance(\patest\StructType\Money $refundVoucherBalance = null)
    {
        if (is_null($refundVoucherBalance) || (is_array($refundVoucherBalance) && empty($refundVoucherBalance))) {
            unset($this->RefundVoucherBalance);
        } else {
            $this->RefundVoucherBalance = $refundVoucherBalance;
        }
        return $this;
    }
}
