<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientActivitiesClient StructType
 * @subpackage Structs
 */
class Crm_ClientActivitiesClient extends PersistableEntity
{
    /**
     * The RelevantClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelevantClientId;
    /**
     * Constructor method for Crm.ClientActivitiesClient
     * @uses Crm_ClientActivitiesClient::setRelevantClientId()
     * @param string $relevantClientId
     */
    public function __construct($relevantClientId = null)
    {
        $this
            ->setRelevantClientId($relevantClientId);
    }
    /**
     * Get RelevantClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelevantClientId()
    {
        return isset($this->RelevantClientId) ? $this->RelevantClientId : null;
    }
    /**
     * Set RelevantClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relevantClientId
     * @return \patest\StructType\Crm_ClientActivitiesClient
     */
    public function setRelevantClientId($relevantClientId = null)
    {
        // validation for constraint: string
        if (!is_null($relevantClientId) && !is_string($relevantClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantClientId, true), gettype($relevantClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relevantClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relevantClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relevantClientId, true)), __LINE__);
        }
        if (is_null($relevantClientId) || (is_array($relevantClientId) && empty($relevantClientId))) {
            unset($this->RelevantClientId);
        } else {
            $this->RelevantClientId = $relevantClientId;
        }
        return $this;
    }
}
