<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.AddressDetail StructType
 * @subpackage Structs
 */
class Crm_AddressDetail extends DistributableEntity
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PostalAddress
     */
    public $Address;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The HasPrior
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPrior;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The IsPrior
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrior;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsShared;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The PriorAddressIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriorAddressIds
     */
    public $PriorAddressIds;
    /**
     * The ReferenceToCurrentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceToCurrentId;
    /**
     * The TypeDisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeDisplayName;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usage;
    /**
     * The ValidFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDate;
    /**
     * The ValidToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDate;
    /**
     * Constructor method for Crm.AddressDetail
     * @uses Crm_AddressDetail::setAddress()
     * @uses Crm_AddressDetail::setClientId()
     * @uses Crm_AddressDetail::setHasPrior()
     * @uses Crm_AddressDetail::setIsDefault()
     * @uses Crm_AddressDetail::setIsPrimary()
     * @uses Crm_AddressDetail::setIsPrior()
     * @uses Crm_AddressDetail::setIsShared()
     * @uses Crm_AddressDetail::setMapToCrmSyncEntity()
     * @uses Crm_AddressDetail::setNote()
     * @uses Crm_AddressDetail::setPhone()
     * @uses Crm_AddressDetail::setPriorAddressIds()
     * @uses Crm_AddressDetail::setReferenceToCurrentId()
     * @uses Crm_AddressDetail::setTypeDisplayName()
     * @uses Crm_AddressDetail::setTypeId()
     * @uses Crm_AddressDetail::setUsage()
     * @uses Crm_AddressDetail::setValidFromDate()
     * @uses Crm_AddressDetail::setValidToDate()
     * @param \patest\StructType\Crm_PostalAddress $address
     * @param string $clientId
     * @param bool $hasPrior
     * @param bool $isDefault
     * @param bool $isPrimary
     * @param bool $isPrior
     * @param bool $isShared
     * @param int $mapToCrmSyncEntity
     * @param \patest\StructType\GlobalString $note
     * @param string $phone
     * @param \patest\StructType\PriorAddressIds $priorAddressIds
     * @param string $referenceToCurrentId
     * @param string $typeDisplayName
     * @param string $typeId
     * @param string $usage
     * @param string $validFromDate
     * @param string $validToDate
     */
    public function __construct(\patest\StructType\Crm_PostalAddress $address = null, $clientId = null, $hasPrior = null, $isDefault = null, $isPrimary = null, $isPrior = null, $isShared = null, $mapToCrmSyncEntity = null, \patest\StructType\GlobalString $note = null, $phone = null, \patest\StructType\PriorAddressIds $priorAddressIds = null, $referenceToCurrentId = null, $typeDisplayName = null, $typeId = null, $usage = null, $validFromDate = null, $validToDate = null)
    {
        $this
            ->setAddress($address)
            ->setClientId($clientId)
            ->setHasPrior($hasPrior)
            ->setIsDefault($isDefault)
            ->setIsPrimary($isPrimary)
            ->setIsPrior($isPrior)
            ->setIsShared($isShared)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setNote($note)
            ->setPhone($phone)
            ->setPriorAddressIds($priorAddressIds)
            ->setReferenceToCurrentId($referenceToCurrentId)
            ->setTypeDisplayName($typeDisplayName)
            ->setTypeId($typeId)
            ->setUsage($usage)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PostalAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PostalAddress $address
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setAddress(\patest\StructType\Crm_PostalAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get HasPrior value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPrior()
    {
        return isset($this->HasPrior) ? $this->HasPrior : null;
    }
    /**
     * Set HasPrior value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPrior
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setHasPrior($hasPrior = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPrior) && !is_bool($hasPrior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPrior, true), gettype($hasPrior)), __LINE__);
        }
        if (is_null($hasPrior) || (is_array($hasPrior) && empty($hasPrior))) {
            unset($this->HasPrior);
        } else {
            $this->HasPrior = $hasPrior;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return isset($this->IsPrimary) ? $this->IsPrimary : null;
    }
    /**
     * Set IsPrimary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrimary
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        if (is_null($isPrimary) || (is_array($isPrimary) && empty($isPrimary))) {
            unset($this->IsPrimary);
        } else {
            $this->IsPrimary = $isPrimary;
        }
        return $this;
    }
    /**
     * Get IsPrior value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrior()
    {
        return isset($this->IsPrior) ? $this->IsPrior : null;
    }
    /**
     * Set IsPrior value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrior
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setIsPrior($isPrior = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrior) && !is_bool($isPrior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrior, true), gettype($isPrior)), __LINE__);
        }
        if (is_null($isPrior) || (is_array($isPrior) && empty($isPrior))) {
            unset($this->IsPrior);
        } else {
            $this->IsPrior = $isPrior;
        }
        return $this;
    }
    /**
     * Get IsShared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsShared()
    {
        return isset($this->IsShared) ? $this->IsShared : null;
    }
    /**
     * Set IsShared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isShared
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        if (is_null($isShared) || (is_array($isShared) && empty($isShared))) {
            unset($this->IsShared);
        } else {
            $this->IsShared = $isShared;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get PriorAddressIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriorAddressIds|null
     */
    public function getPriorAddressIds()
    {
        return isset($this->PriorAddressIds) ? $this->PriorAddressIds : null;
    }
    /**
     * Set PriorAddressIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriorAddressIds $priorAddressIds
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setPriorAddressIds(\patest\StructType\PriorAddressIds $priorAddressIds = null)
    {
        if (is_null($priorAddressIds) || (is_array($priorAddressIds) && empty($priorAddressIds))) {
            unset($this->PriorAddressIds);
        } else {
            $this->PriorAddressIds = $priorAddressIds;
        }
        return $this;
    }
    /**
     * Get ReferenceToCurrentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceToCurrentId()
    {
        return isset($this->ReferenceToCurrentId) ? $this->ReferenceToCurrentId : null;
    }
    /**
     * Set ReferenceToCurrentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceToCurrentId
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setReferenceToCurrentId($referenceToCurrentId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceToCurrentId) && !is_string($referenceToCurrentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceToCurrentId, true), gettype($referenceToCurrentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceToCurrentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceToCurrentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceToCurrentId, true)), __LINE__);
        }
        if (is_null($referenceToCurrentId) || (is_array($referenceToCurrentId) && empty($referenceToCurrentId))) {
            unset($this->ReferenceToCurrentId);
        } else {
            $this->ReferenceToCurrentId = $referenceToCurrentId;
        }
        return $this;
    }
    /**
     * Get TypeDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeDisplayName()
    {
        return isset($this->TypeDisplayName) ? $this->TypeDisplayName : null;
    }
    /**
     * Set TypeDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeDisplayName
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setTypeDisplayName($typeDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($typeDisplayName) && !is_string($typeDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDisplayName, true), gettype($typeDisplayName)), __LINE__);
        }
        if (is_null($typeDisplayName) || (is_array($typeDisplayName) && empty($typeDisplayName))) {
            unset($this->TypeDisplayName);
        } else {
            $this->TypeDisplayName = $typeDisplayName;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get Usage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsage()
    {
        return isset($this->Usage) ? $this->Usage : null;
    }
    /**
     * Set Usage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AddressUsageKind::valueIsValid()
     * @uses \patest\EnumType\AddressUsageKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AddressUsageKind::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AddressUsageKind', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \patest\EnumType\AddressUsageKind::getValidValues())), __LINE__);
        }
        if (is_null($usage) || (is_array($usage) && empty($usage))) {
            unset($this->Usage);
        } else {
            $this->Usage = $usage;
        }
        return $this;
    }
    /**
     * Get ValidFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDate()
    {
        return isset($this->ValidFromDate) ? $this->ValidFromDate : null;
    }
    /**
     * Set ValidFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDate
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        if (is_null($validFromDate) || (is_array($validFromDate) && empty($validFromDate))) {
            unset($this->ValidFromDate);
        } else {
            $this->ValidFromDate = $validFromDate;
        }
        return $this;
    }
    /**
     * Get ValidToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDate()
    {
        return isset($this->ValidToDate) ? $this->ValidToDate : null;
    }
    /**
     * Set ValidToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDate
     * @return \patest\StructType\Crm_AddressDetail
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        if (is_null($validToDate) || (is_array($validToDate) && empty($validToDate))) {
            unset($this->ValidToDate);
        } else {
            $this->ValidToDate = $validToDate;
        }
        return $this;
    }
}
