<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.Account4OrganizationData StructType
 * @subpackage Structs
 */
class Crm_Account4OrganizationData extends Crm_Client
{
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccountTypeIds
     */
    public $AccountTypeIds;
    /**
     * The AccountTypes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AccountType
     */
    public $AccountTypes;
    /**
     * The AllocationTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AccountAllocationType
     */
    public $AllocationTypes;
    /**
     * The Announcement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Announcement;
    /**
     * The ContactPeople
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_RelativeContactPerson
     */
    public $ContactPeople;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Customer4OrganizationData
     */
    public $ContactPerson;
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactPersonId;
    /**
     * The CreditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditLimit;
    /**
     * The DataProtectionQuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataProtectionQuestionId;
    /**
     * The DefaultPaymentTermId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultPaymentTermId;
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The FullNameDialog
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullNameDialog;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GroupName;
    /**
     * The Interface
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Interface;
    /**
     * The Logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Logo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NeverSendEmptyReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeverSendEmptyReports;
    /**
     * The SaleOnBehalfUserTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleOnBehalfUserTokenId;
    /**
     * The SearchableName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableName;
    /**
     * The SendScheduledReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendScheduledReports;
    /**
     * The TicketNumberGlobalCounterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketNumberGlobalCounterId;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Crm.Account4OrganizationData
     * @uses Crm_Account4OrganizationData::setAccountTypeIds()
     * @uses Crm_Account4OrganizationData::setAccountTypes()
     * @uses Crm_Account4OrganizationData::setAllocationTypes()
     * @uses Crm_Account4OrganizationData::setAnnouncement()
     * @uses Crm_Account4OrganizationData::setContactPeople()
     * @uses Crm_Account4OrganizationData::setContactPerson()
     * @uses Crm_Account4OrganizationData::setContactPersonId()
     * @uses Crm_Account4OrganizationData::setCreditLimit()
     * @uses Crm_Account4OrganizationData::setDataProtectionQuestionId()
     * @uses Crm_Account4OrganizationData::setDefaultPaymentTermId()
     * @uses Crm_Account4OrganizationData::setFullName()
     * @uses Crm_Account4OrganizationData::setFullNameDialog()
     * @uses Crm_Account4OrganizationData::setGroupId()
     * @uses Crm_Account4OrganizationData::setGroupName()
     * @uses Crm_Account4OrganizationData::setInterface()
     * @uses Crm_Account4OrganizationData::setLogo()
     * @uses Crm_Account4OrganizationData::setName()
     * @uses Crm_Account4OrganizationData::setNeverSendEmptyReports()
     * @uses Crm_Account4OrganizationData::setSaleOnBehalfUserTokenId()
     * @uses Crm_Account4OrganizationData::setSearchableName()
     * @uses Crm_Account4OrganizationData::setSendScheduledReports()
     * @uses Crm_Account4OrganizationData::setTicketNumberGlobalCounterId()
     * @uses Crm_Account4OrganizationData::setVatRegistrationNumber()
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @param \patest\StructType\RecordSetOfCrm_AccountAllocationType $allocationTypes
     * @param string $announcement
     * @param \patest\StructType\RecordSetOfCrm_RelativeContactPerson $contactPeople
     * @param \patest\StructType\Crm_Customer4OrganizationData $contactPerson
     * @param string $contactPersonId
     * @param \patest\StructType\Money $creditLimit
     * @param string $dataProtectionQuestionId
     * @param string $defaultPaymentTermId
     * @param string $fullName
     * @param string $fullNameDialog
     * @param string $groupId
     * @param \patest\StructType\GlobalString $groupName
     * @param string $interface
     * @param string $logo
     * @param string $name
     * @param bool $neverSendEmptyReports
     * @param string $saleOnBehalfUserTokenId
     * @param string $searchableName
     * @param bool $sendScheduledReports
     * @param string $ticketNumberGlobalCounterId
     * @param string $vatRegistrationNumber
     */
    public function __construct(\patest\StructType\AccountTypeIds $accountTypeIds = null, \patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null, \patest\StructType\RecordSetOfCrm_AccountAllocationType $allocationTypes = null, $announcement = null, \patest\StructType\RecordSetOfCrm_RelativeContactPerson $contactPeople = null, \patest\StructType\Crm_Customer4OrganizationData $contactPerson = null, $contactPersonId = null, \patest\StructType\Money $creditLimit = null, $dataProtectionQuestionId = null, $defaultPaymentTermId = null, $fullName = null, $fullNameDialog = null, $groupId = null, \patest\StructType\GlobalString $groupName = null, $interface = null, $logo = null, $name = null, $neverSendEmptyReports = null, $saleOnBehalfUserTokenId = null, $searchableName = null, $sendScheduledReports = null, $ticketNumberGlobalCounterId = null, $vatRegistrationNumber = null)
    {
        $this
            ->setAccountTypeIds($accountTypeIds)
            ->setAccountTypes($accountTypes)
            ->setAllocationTypes($allocationTypes)
            ->setAnnouncement($announcement)
            ->setContactPeople($contactPeople)
            ->setContactPerson($contactPerson)
            ->setContactPersonId($contactPersonId)
            ->setCreditLimit($creditLimit)
            ->setDataProtectionQuestionId($dataProtectionQuestionId)
            ->setDefaultPaymentTermId($defaultPaymentTermId)
            ->setFullName($fullName)
            ->setFullNameDialog($fullNameDialog)
            ->setGroupId($groupId)
            ->setGroupName($groupName)
            ->setInterface($interface)
            ->setLogo($logo)
            ->setName($name)
            ->setNeverSendEmptyReports($neverSendEmptyReports)
            ->setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId)
            ->setSearchableName($searchableName)
            ->setSendScheduledReports($sendScheduledReports)
            ->setTicketNumberGlobalCounterId($ticketNumberGlobalCounterId)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccountTypeIds|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setAccountTypeIds(\patest\StructType\AccountTypeIds $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AccountTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AccountType|null
     */
    public function getAccountTypes()
    {
        return isset($this->AccountTypes) ? $this->AccountTypes : null;
    }
    /**
     * Set AccountTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setAccountTypes(\patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null)
    {
        if (is_null($accountTypes) || (is_array($accountTypes) && empty($accountTypes))) {
            unset($this->AccountTypes);
        } else {
            $this->AccountTypes = $accountTypes;
        }
        return $this;
    }
    /**
     * Get AllocationTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AccountAllocationType|null
     */
    public function getAllocationTypes()
    {
        return isset($this->AllocationTypes) ? $this->AllocationTypes : null;
    }
    /**
     * Set AllocationTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AccountAllocationType $allocationTypes
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setAllocationTypes(\patest\StructType\RecordSetOfCrm_AccountAllocationType $allocationTypes = null)
    {
        if (is_null($allocationTypes) || (is_array($allocationTypes) && empty($allocationTypes))) {
            unset($this->AllocationTypes);
        } else {
            $this->AllocationTypes = $allocationTypes;
        }
        return $this;
    }
    /**
     * Get Announcement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnouncement()
    {
        return isset($this->Announcement) ? $this->Announcement : null;
    }
    /**
     * Set Announcement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $announcement
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setAnnouncement($announcement = null)
    {
        // validation for constraint: string
        if (!is_null($announcement) && !is_string($announcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($announcement, true), gettype($announcement)), __LINE__);
        }
        if (is_null($announcement) || (is_array($announcement) && empty($announcement))) {
            unset($this->Announcement);
        } else {
            $this->Announcement = $announcement;
        }
        return $this;
    }
    /**
     * Get ContactPeople value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_RelativeContactPerson|null
     */
    public function getContactPeople()
    {
        return isset($this->ContactPeople) ? $this->ContactPeople : null;
    }
    /**
     * Set ContactPeople value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_RelativeContactPerson $contactPeople
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setContactPeople(\patest\StructType\RecordSetOfCrm_RelativeContactPerson $contactPeople = null)
    {
        if (is_null($contactPeople) || (is_array($contactPeople) && empty($contactPeople))) {
            unset($this->ContactPeople);
        } else {
            $this->ContactPeople = $contactPeople;
        }
        return $this;
    }
    /**
     * Get ContactPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Customer4OrganizationData|null
     */
    public function getContactPerson()
    {
        return isset($this->ContactPerson) ? $this->ContactPerson : null;
    }
    /**
     * Set ContactPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Customer4OrganizationData $contactPerson
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setContactPerson(\patest\StructType\Crm_Customer4OrganizationData $contactPerson = null)
    {
        if (is_null($contactPerson) || (is_array($contactPerson) && empty($contactPerson))) {
            unset($this->ContactPerson);
        } else {
            $this->ContactPerson = $contactPerson;
        }
        return $this;
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPersonId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonId) && !is_string($contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactPersonId, true)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get CreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditLimit()
    {
        return isset($this->CreditLimit) ? $this->CreditLimit : null;
    }
    /**
     * Set CreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditLimit
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setCreditLimit(\patest\StructType\Money $creditLimit = null)
    {
        if (is_null($creditLimit) || (is_array($creditLimit) && empty($creditLimit))) {
            unset($this->CreditLimit);
        } else {
            $this->CreditLimit = $creditLimit;
        }
        return $this;
    }
    /**
     * Get DataProtectionQuestionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtectionQuestionId()
    {
        return isset($this->DataProtectionQuestionId) ? $this->DataProtectionQuestionId : null;
    }
    /**
     * Set DataProtectionQuestionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtectionQuestionId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setDataProtectionQuestionId($dataProtectionQuestionId = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtectionQuestionId) && !is_string($dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtectionQuestionId, true), gettype($dataProtectionQuestionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataProtectionQuestionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataProtectionQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataProtectionQuestionId, true)), __LINE__);
        }
        if (is_null($dataProtectionQuestionId) || (is_array($dataProtectionQuestionId) && empty($dataProtectionQuestionId))) {
            unset($this->DataProtectionQuestionId);
        } else {
            $this->DataProtectionQuestionId = $dataProtectionQuestionId;
        }
        return $this;
    }
    /**
     * Get DefaultPaymentTermId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPaymentTermId()
    {
        return isset($this->DefaultPaymentTermId) ? $this->DefaultPaymentTermId : null;
    }
    /**
     * Set DefaultPaymentTermId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPaymentTermId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setDefaultPaymentTermId($defaultPaymentTermId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPaymentTermId) && !is_string($defaultPaymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPaymentTermId, true), gettype($defaultPaymentTermId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultPaymentTermId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultPaymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultPaymentTermId, true)), __LINE__);
        }
        if (is_null($defaultPaymentTermId) || (is_array($defaultPaymentTermId) && empty($defaultPaymentTermId))) {
            unset($this->DefaultPaymentTermId);
        } else {
            $this->DefaultPaymentTermId = $defaultPaymentTermId;
        }
        return $this;
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get FullNameDialog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullNameDialog()
    {
        return isset($this->FullNameDialog) ? $this->FullNameDialog : null;
    }
    /**
     * Set FullNameDialog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullNameDialog
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setFullNameDialog($fullNameDialog = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameDialog) && !is_string($fullNameDialog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameDialog, true), gettype($fullNameDialog)), __LINE__);
        }
        if (is_null($fullNameDialog) || (is_array($fullNameDialog) && empty($fullNameDialog))) {
            unset($this->FullNameDialog);
        } else {
            $this->FullNameDialog = $fullNameDialog;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $groupName
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setGroupName(\patest\StructType\GlobalString $groupName = null)
    {
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get Interface value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInterface()
    {
        return isset($this->Interface) ? $this->Interface : null;
    }
    /**
     * Set Interface value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $interface
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setInterface($interface = null)
    {
        // validation for constraint: string
        if (!is_null($interface) && !is_string($interface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interface, true), gettype($interface)), __LINE__);
        }
        if (is_null($interface) || (is_array($interface) && empty($interface))) {
            unset($this->Interface);
        } else {
            $this->Interface = $interface;
        }
        return $this;
    }
    /**
     * Get Logo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogo()
    {
        return isset($this->Logo) ? $this->Logo : null;
    }
    /**
     * Set Logo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logo
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setLogo($logo = null)
    {
        // validation for constraint: string
        if (!is_null($logo) && !is_string($logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logo, true), gettype($logo)), __LINE__);
        }
        if (is_null($logo) || (is_array($logo) && empty($logo))) {
            unset($this->Logo);
        } else {
            $this->Logo = $logo;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NeverSendEmptyReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeverSendEmptyReports()
    {
        return isset($this->NeverSendEmptyReports) ? $this->NeverSendEmptyReports : null;
    }
    /**
     * Set NeverSendEmptyReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $neverSendEmptyReports
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setNeverSendEmptyReports($neverSendEmptyReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($neverSendEmptyReports) && !is_bool($neverSendEmptyReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($neverSendEmptyReports, true), gettype($neverSendEmptyReports)), __LINE__);
        }
        if (is_null($neverSendEmptyReports) || (is_array($neverSendEmptyReports) && empty($neverSendEmptyReports))) {
            unset($this->NeverSendEmptyReports);
        } else {
            $this->NeverSendEmptyReports = $neverSendEmptyReports;
        }
        return $this;
    }
    /**
     * Get SaleOnBehalfUserTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleOnBehalfUserTokenId()
    {
        return isset($this->SaleOnBehalfUserTokenId) ? $this->SaleOnBehalfUserTokenId : null;
    }
    /**
     * Set SaleOnBehalfUserTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleOnBehalfUserTokenId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($saleOnBehalfUserTokenId) && !is_string($saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOnBehalfUserTokenId, true), gettype($saleOnBehalfUserTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleOnBehalfUserTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleOnBehalfUserTokenId, true)), __LINE__);
        }
        if (is_null($saleOnBehalfUserTokenId) || (is_array($saleOnBehalfUserTokenId) && empty($saleOnBehalfUserTokenId))) {
            unset($this->SaleOnBehalfUserTokenId);
        } else {
            $this->SaleOnBehalfUserTokenId = $saleOnBehalfUserTokenId;
        }
        return $this;
    }
    /**
     * Get SearchableName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableName()
    {
        return isset($this->SearchableName) ? $this->SearchableName : null;
    }
    /**
     * Set SearchableName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableName
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setSearchableName($searchableName = null)
    {
        // validation for constraint: string
        if (!is_null($searchableName) && !is_string($searchableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableName, true), gettype($searchableName)), __LINE__);
        }
        if (is_null($searchableName) || (is_array($searchableName) && empty($searchableName))) {
            unset($this->SearchableName);
        } else {
            $this->SearchableName = $searchableName;
        }
        return $this;
    }
    /**
     * Get SendScheduledReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendScheduledReports()
    {
        return isset($this->SendScheduledReports) ? $this->SendScheduledReports : null;
    }
    /**
     * Set SendScheduledReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendScheduledReports
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setSendScheduledReports($sendScheduledReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendScheduledReports) && !is_bool($sendScheduledReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendScheduledReports, true), gettype($sendScheduledReports)), __LINE__);
        }
        if (is_null($sendScheduledReports) || (is_array($sendScheduledReports) && empty($sendScheduledReports))) {
            unset($this->SendScheduledReports);
        } else {
            $this->SendScheduledReports = $sendScheduledReports;
        }
        return $this;
    }
    /**
     * Get TicketNumberGlobalCounterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketNumberGlobalCounterId()
    {
        return isset($this->TicketNumberGlobalCounterId) ? $this->TicketNumberGlobalCounterId : null;
    }
    /**
     * Set TicketNumberGlobalCounterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketNumberGlobalCounterId
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setTicketNumberGlobalCounterId($ticketNumberGlobalCounterId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumberGlobalCounterId) && !is_string($ticketNumberGlobalCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumberGlobalCounterId, true), gettype($ticketNumberGlobalCounterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketNumberGlobalCounterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketNumberGlobalCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketNumberGlobalCounterId, true)), __LINE__);
        }
        if (is_null($ticketNumberGlobalCounterId) || (is_array($ticketNumberGlobalCounterId) && empty($ticketNumberGlobalCounterId))) {
            unset($this->TicketNumberGlobalCounterId);
        } else {
            $this->TicketNumberGlobalCounterId = $ticketNumberGlobalCounterId;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Crm_Account4OrganizationData
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
