<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmSyncEntitySync.Customer StructType
 * @subpackage Structs
 */
class CrmSyncEntitySync_Customer extends CrmSyncEntitySync_Client
{
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardId;
    /**
     * The DateOfDeath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfDeath;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The Initials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Initials;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $JobTitle;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MaritalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MaritalStatus;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The PreferedName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferedName;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Title;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * Constructor method for CrmSyncEntitySync.Customer
     * @uses CrmSyncEntitySync_Customer::setBirthday()
     * @uses CrmSyncEntitySync_Customer::setCardId()
     * @uses CrmSyncEntitySync_Customer::setDateOfDeath()
     * @uses CrmSyncEntitySync_Customer::setFirstName()
     * @uses CrmSyncEntitySync_Customer::setGender()
     * @uses CrmSyncEntitySync_Customer::setInitials()
     * @uses CrmSyncEntitySync_Customer::setIsDeceased()
     * @uses CrmSyncEntitySync_Customer::setJobTitle()
     * @uses CrmSyncEntitySync_Customer::setLastName()
     * @uses CrmSyncEntitySync_Customer::setMaritalStatus()
     * @uses CrmSyncEntitySync_Customer::setMiddleName()
     * @uses CrmSyncEntitySync_Customer::setPreferedName()
     * @uses CrmSyncEntitySync_Customer::setSuffix()
     * @uses CrmSyncEntitySync_Customer::setTitle()
     * @uses CrmSyncEntitySync_Customer::setWorkPlace()
     * @param string $birthday
     * @param string $cardId
     * @param string $dateOfDeath
     * @param string $firstName
     * @param string $gender
     * @param string $initials
     * @param bool $isDeceased
     * @param \patest\StructType\GlobalString $jobTitle
     * @param string $lastName
     * @param \patest\StructType\GlobalString $maritalStatus
     * @param string $middleName
     * @param string $preferedName
     * @param string $suffix
     * @param \patest\StructType\GlobalString $title
     * @param string $workPlace
     */
    public function __construct($birthday = null, $cardId = null, $dateOfDeath = null, $firstName = null, $gender = null, $initials = null, $isDeceased = null, \patest\StructType\GlobalString $jobTitle = null, $lastName = null, \patest\StructType\GlobalString $maritalStatus = null, $middleName = null, $preferedName = null, $suffix = null, \patest\StructType\GlobalString $title = null, $workPlace = null)
    {
        $this
            ->setBirthday($birthday)
            ->setCardId($cardId)
            ->setDateOfDeath($dateOfDeath)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setInitials($initials)
            ->setIsDeceased($isDeceased)
            ->setJobTitle($jobTitle)
            ->setLastName($lastName)
            ->setMaritalStatus($maritalStatus)
            ->setMiddleName($middleName)
            ->setPreferedName($preferedName)
            ->setSuffix($suffix)
            ->setTitle($title)
            ->setWorkPlace($workPlace);
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get CardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->CardId) ? $this->CardId : null;
    }
    /**
     * Set CardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->CardId);
        } else {
            $this->CardId = $cardId;
        }
        return $this;
    }
    /**
     * Get DateOfDeath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfDeath()
    {
        return isset($this->DateOfDeath) ? $this->DateOfDeath : null;
    }
    /**
     * Set DateOfDeath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfDeath
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setDateOfDeath($dateOfDeath = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeath) && !is_string($dateOfDeath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeath, true), gettype($dateOfDeath)), __LINE__);
        }
        if (is_null($dateOfDeath) || (is_array($dateOfDeath) && empty($dateOfDeath))) {
            unset($this->DateOfDeath);
        } else {
            $this->DateOfDeath = $dateOfDeath;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get Initials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitials()
    {
        return isset($this->Initials) ? $this->Initials : null;
    }
    /**
     * Set Initials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initials
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        if (is_null($initials) || (is_array($initials) && empty($initials))) {
            unset($this->Initials);
        } else {
            $this->Initials = $initials;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get JobTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getJobTitle()
    {
        return isset($this->JobTitle) ? $this->JobTitle : null;
    }
    /**
     * Set JobTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $jobTitle
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setJobTitle(\patest\StructType\GlobalString $jobTitle = null)
    {
        if (is_null($jobTitle) || (is_array($jobTitle) && empty($jobTitle))) {
            unset($this->JobTitle);
        } else {
            $this->JobTitle = $jobTitle;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MaritalStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMaritalStatus()
    {
        return isset($this->MaritalStatus) ? $this->MaritalStatus : null;
    }
    /**
     * Set MaritalStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $maritalStatus
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setMaritalStatus(\patest\StructType\GlobalString $maritalStatus = null)
    {
        if (is_null($maritalStatus) || (is_array($maritalStatus) && empty($maritalStatus))) {
            unset($this->MaritalStatus);
        } else {
            $this->MaritalStatus = $maritalStatus;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get PreferedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferedName()
    {
        return isset($this->PreferedName) ? $this->PreferedName : null;
    }
    /**
     * Set PreferedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferedName
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setPreferedName($preferedName = null)
    {
        // validation for constraint: string
        if (!is_null($preferedName) && !is_string($preferedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferedName, true), gettype($preferedName)), __LINE__);
        }
        if (is_null($preferedName) || (is_array($preferedName) && empty($preferedName))) {
            unset($this->PreferedName);
        } else {
            $this->PreferedName = $preferedName;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $title
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setTitle(\patest\StructType\GlobalString $title = null)
    {
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\CrmSyncEntitySync_Customer
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
}
