<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateVisitRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateVisitRequest
 * @subpackage Structs
 */
class CreateVisitRequest extends ExtensibleDataContract
{
    /**
     * The ChaperonService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Service
     */
    public $ChaperonService;
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classes;
    /**
     * The CustomServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCustomService
     */
    public $CustomServices;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * The GroupCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGroupCombination
     */
    public $GroupCombinations;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The MealService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Service
     */
    public $MealService;
    /**
     * The NewOrderDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrderDetails
     */
    public $NewOrderDetails;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The PreferredEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredEndDate;
    /**
     * The PreferredStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartDate;
    /**
     * The PreferredStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartTime;
    /**
     * The PricingPerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingPerType;
    /**
     * The SpecialNeedsService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Service
     */
    public $SpecialNeedsService;
    /**
     * The TransportationService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Service
     */
    public $TransportationService;
    /**
     * The VisitComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitComment;
    /**
     * The VisitContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactEmail;
    /**
     * The VisitContactFax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactFax;
    /**
     * The VisitContactHomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactHomePhone;
    /**
     * The VisitContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitContactId;
    /**
     * The VisitContactMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactMobile;
    /**
     * The VisitNatureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitNatureId;
    /**
     * The VisitPayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPayerAccountId;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitSkills
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $VisitSkills;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * Constructor method for CreateVisitRequest
     * @uses CreateVisitRequest::setChaperonService()
     * @uses CreateVisitRequest::setClasses()
     * @uses CreateVisitRequest::setCustomServices()
     * @uses CreateVisitRequest::setGradeId()
     * @uses CreateVisitRequest::setGroupCombinations()
     * @uses CreateVisitRequest::setGroupName()
     * @uses CreateVisitRequest::setMealService()
     * @uses CreateVisitRequest::setNewOrderDetails()
     * @uses CreateVisitRequest::setOrderId()
     * @uses CreateVisitRequest::setPreferredEndDate()
     * @uses CreateVisitRequest::setPreferredStartDate()
     * @uses CreateVisitRequest::setPreferredStartTime()
     * @uses CreateVisitRequest::setPricingPerType()
     * @uses CreateVisitRequest::setSpecialNeedsService()
     * @uses CreateVisitRequest::setTransportationService()
     * @uses CreateVisitRequest::setVisitComment()
     * @uses CreateVisitRequest::setVisitContactEmail()
     * @uses CreateVisitRequest::setVisitContactFax()
     * @uses CreateVisitRequest::setVisitContactHomePhone()
     * @uses CreateVisitRequest::setVisitContactId()
     * @uses CreateVisitRequest::setVisitContactMobile()
     * @uses CreateVisitRequest::setVisitNatureId()
     * @uses CreateVisitRequest::setVisitPayerAccountId()
     * @uses CreateVisitRequest::setVisitPlanId()
     * @uses CreateVisitRequest::setVisitSkills()
     * @uses CreateVisitRequest::setVisitTypeId()
     * @param \patest\StructType\Service $chaperonService
     * @param string $classes
     * @param \patest\ArrayType\ArrayOfCustomService $customServices
     * @param string $gradeId
     * @param \patest\ArrayType\ArrayOfGroupCombination $groupCombinations
     * @param string $groupName
     * @param \patest\StructType\Service $mealService
     * @param \patest\StructType\OrderDetails $newOrderDetails
     * @param string $orderId
     * @param string $preferredEndDate
     * @param string $preferredStartDate
     * @param string $preferredStartTime
     * @param string $pricingPerType
     * @param \patest\StructType\Service $specialNeedsService
     * @param \patest\StructType\Service $transportationService
     * @param string $visitComment
     * @param string $visitContactEmail
     * @param string $visitContactFax
     * @param string $visitContactHomePhone
     * @param string $visitContactId
     * @param string $visitContactMobile
     * @param string $visitNatureId
     * @param string $visitPayerAccountId
     * @param string $visitPlanId
     * @param \patest\ArrayType\ArrayOfguid $visitSkills
     * @param string $visitTypeId
     */
    public function __construct(\patest\StructType\Service $chaperonService = null, $classes = null, \patest\ArrayType\ArrayOfCustomService $customServices = null, $gradeId = null, \patest\ArrayType\ArrayOfGroupCombination $groupCombinations = null, $groupName = null, \patest\StructType\Service $mealService = null, \patest\StructType\OrderDetails $newOrderDetails = null, $orderId = null, $preferredEndDate = null, $preferredStartDate = null, $preferredStartTime = null, $pricingPerType = null, \patest\StructType\Service $specialNeedsService = null, \patest\StructType\Service $transportationService = null, $visitComment = null, $visitContactEmail = null, $visitContactFax = null, $visitContactHomePhone = null, $visitContactId = null, $visitContactMobile = null, $visitNatureId = null, $visitPayerAccountId = null, $visitPlanId = null, \patest\ArrayType\ArrayOfguid $visitSkills = null, $visitTypeId = null)
    {
        $this
            ->setChaperonService($chaperonService)
            ->setClasses($classes)
            ->setCustomServices($customServices)
            ->setGradeId($gradeId)
            ->setGroupCombinations($groupCombinations)
            ->setGroupName($groupName)
            ->setMealService($mealService)
            ->setNewOrderDetails($newOrderDetails)
            ->setOrderId($orderId)
            ->setPreferredEndDate($preferredEndDate)
            ->setPreferredStartDate($preferredStartDate)
            ->setPreferredStartTime($preferredStartTime)
            ->setPricingPerType($pricingPerType)
            ->setSpecialNeedsService($specialNeedsService)
            ->setTransportationService($transportationService)
            ->setVisitComment($visitComment)
            ->setVisitContactEmail($visitContactEmail)
            ->setVisitContactFax($visitContactFax)
            ->setVisitContactHomePhone($visitContactHomePhone)
            ->setVisitContactId($visitContactId)
            ->setVisitContactMobile($visitContactMobile)
            ->setVisitNatureId($visitNatureId)
            ->setVisitPayerAccountId($visitPayerAccountId)
            ->setVisitPlanId($visitPlanId)
            ->setVisitSkills($visitSkills)
            ->setVisitTypeId($visitTypeId);
    }
    /**
     * Get ChaperonService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Service|null
     */
    public function getChaperonService()
    {
        return isset($this->ChaperonService) ? $this->ChaperonService : null;
    }
    /**
     * Set ChaperonService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Service $chaperonService
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setChaperonService(\patest\StructType\Service $chaperonService = null)
    {
        if (is_null($chaperonService) || (is_array($chaperonService) && empty($chaperonService))) {
            unset($this->ChaperonService);
        } else {
            $this->ChaperonService = $chaperonService;
        }
        return $this;
    }
    /**
     * Get Classes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClasses()
    {
        return isset($this->Classes) ? $this->Classes : null;
    }
    /**
     * Set Classes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classes
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setClasses($classes = null)
    {
        // validation for constraint: string
        if (!is_null($classes) && !is_string($classes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classes, true), gettype($classes)), __LINE__);
        }
        if (is_null($classes) || (is_array($classes) && empty($classes))) {
            unset($this->Classes);
        } else {
            $this->Classes = $classes;
        }
        return $this;
    }
    /**
     * Get CustomServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCustomService|null
     */
    public function getCustomServices()
    {
        return isset($this->CustomServices) ? $this->CustomServices : null;
    }
    /**
     * Set CustomServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCustomService $customServices
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setCustomServices(\patest\ArrayType\ArrayOfCustomService $customServices = null)
    {
        if (is_null($customServices) || (is_array($customServices) && empty($customServices))) {
            unset($this->CustomServices);
        } else {
            $this->CustomServices = $customServices;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
    /**
     * Get GroupCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGroupCombination|null
     */
    public function getGroupCombinations()
    {
        return isset($this->GroupCombinations) ? $this->GroupCombinations : null;
    }
    /**
     * Set GroupCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGroupCombination $groupCombinations
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setGroupCombinations(\patest\ArrayType\ArrayOfGroupCombination $groupCombinations = null)
    {
        if (is_null($groupCombinations) || (is_array($groupCombinations) && empty($groupCombinations))) {
            unset($this->GroupCombinations);
        } else {
            $this->GroupCombinations = $groupCombinations;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get MealService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Service|null
     */
    public function getMealService()
    {
        return isset($this->MealService) ? $this->MealService : null;
    }
    /**
     * Set MealService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Service $mealService
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setMealService(\patest\StructType\Service $mealService = null)
    {
        if (is_null($mealService) || (is_array($mealService) && empty($mealService))) {
            unset($this->MealService);
        } else {
            $this->MealService = $mealService;
        }
        return $this;
    }
    /**
     * Get NewOrderDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrderDetails|null
     */
    public function getNewOrderDetails()
    {
        return isset($this->NewOrderDetails) ? $this->NewOrderDetails : null;
    }
    /**
     * Set NewOrderDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrderDetails $newOrderDetails
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setNewOrderDetails(\patest\StructType\OrderDetails $newOrderDetails = null)
    {
        if (is_null($newOrderDetails) || (is_array($newOrderDetails) && empty($newOrderDetails))) {
            unset($this->NewOrderDetails);
        } else {
            $this->NewOrderDetails = $newOrderDetails;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get PreferredEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredEndDate()
    {
        return isset($this->PreferredEndDate) ? $this->PreferredEndDate : null;
    }
    /**
     * Set PreferredEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredEndDate
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setPreferredEndDate($preferredEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredEndDate) && !is_string($preferredEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredEndDate, true), gettype($preferredEndDate)), __LINE__);
        }
        if (is_null($preferredEndDate) || (is_array($preferredEndDate) && empty($preferredEndDate))) {
            unset($this->PreferredEndDate);
        } else {
            $this->PreferredEndDate = $preferredEndDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartDate()
    {
        return isset($this->PreferredStartDate) ? $this->PreferredStartDate : null;
    }
    /**
     * Set PreferredStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartDate
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setPreferredStartDate($preferredStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartDate) && !is_string($preferredStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartDate, true), gettype($preferredStartDate)), __LINE__);
        }
        if (is_null($preferredStartDate) || (is_array($preferredStartDate) && empty($preferredStartDate))) {
            unset($this->PreferredStartDate);
        } else {
            $this->PreferredStartDate = $preferredStartDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartTime()
    {
        return isset($this->PreferredStartTime) ? $this->PreferredStartTime : null;
    }
    /**
     * Set PreferredStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartTime
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setPreferredStartTime($preferredStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartTime) && !is_string($preferredStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartTime, true), gettype($preferredStartTime)), __LINE__);
        }
        if (is_null($preferredStartTime) || (is_array($preferredStartTime) && empty($preferredStartTime))) {
            unset($this->PreferredStartTime);
        } else {
            $this->PreferredStartTime = $preferredStartTime;
        }
        return $this;
    }
    /**
     * Get PricingPerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingPerType()
    {
        return isset($this->PricingPerType) ? $this->PricingPerType : null;
    }
    /**
     * Set PricingPerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingPerType::valueIsValid()
     * @uses \patest\EnumType\PricingPerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingPerType
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setPricingPerType($pricingPerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingPerType::valueIsValid($pricingPerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingPerType', is_array($pricingPerType) ? implode(', ', $pricingPerType) : var_export($pricingPerType, true), implode(', ', \patest\EnumType\PricingPerType::getValidValues())), __LINE__);
        }
        if (is_null($pricingPerType) || (is_array($pricingPerType) && empty($pricingPerType))) {
            unset($this->PricingPerType);
        } else {
            $this->PricingPerType = $pricingPerType;
        }
        return $this;
    }
    /**
     * Get SpecialNeedsService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Service|null
     */
    public function getSpecialNeedsService()
    {
        return isset($this->SpecialNeedsService) ? $this->SpecialNeedsService : null;
    }
    /**
     * Set SpecialNeedsService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Service $specialNeedsService
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setSpecialNeedsService(\patest\StructType\Service $specialNeedsService = null)
    {
        if (is_null($specialNeedsService) || (is_array($specialNeedsService) && empty($specialNeedsService))) {
            unset($this->SpecialNeedsService);
        } else {
            $this->SpecialNeedsService = $specialNeedsService;
        }
        return $this;
    }
    /**
     * Get TransportationService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Service|null
     */
    public function getTransportationService()
    {
        return isset($this->TransportationService) ? $this->TransportationService : null;
    }
    /**
     * Set TransportationService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Service $transportationService
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setTransportationService(\patest\StructType\Service $transportationService = null)
    {
        if (is_null($transportationService) || (is_array($transportationService) && empty($transportationService))) {
            unset($this->TransportationService);
        } else {
            $this->TransportationService = $transportationService;
        }
        return $this;
    }
    /**
     * Get VisitComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitComment()
    {
        return isset($this->VisitComment) ? $this->VisitComment : null;
    }
    /**
     * Set VisitComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitComment
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitComment($visitComment = null)
    {
        // validation for constraint: string
        if (!is_null($visitComment) && !is_string($visitComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitComment, true), gettype($visitComment)), __LINE__);
        }
        if (is_null($visitComment) || (is_array($visitComment) && empty($visitComment))) {
            unset($this->VisitComment);
        } else {
            $this->VisitComment = $visitComment;
        }
        return $this;
    }
    /**
     * Get VisitContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactEmail()
    {
        return isset($this->VisitContactEmail) ? $this->VisitContactEmail : null;
    }
    /**
     * Set VisitContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactEmail
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitContactEmail($visitContactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactEmail) && !is_string($visitContactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactEmail, true), gettype($visitContactEmail)), __LINE__);
        }
        if (is_null($visitContactEmail) || (is_array($visitContactEmail) && empty($visitContactEmail))) {
            unset($this->VisitContactEmail);
        } else {
            $this->VisitContactEmail = $visitContactEmail;
        }
        return $this;
    }
    /**
     * Get VisitContactFax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactFax()
    {
        return isset($this->VisitContactFax) ? $this->VisitContactFax : null;
    }
    /**
     * Set VisitContactFax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactFax
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitContactFax($visitContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactFax) && !is_string($visitContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactFax, true), gettype($visitContactFax)), __LINE__);
        }
        if (is_null($visitContactFax) || (is_array($visitContactFax) && empty($visitContactFax))) {
            unset($this->VisitContactFax);
        } else {
            $this->VisitContactFax = $visitContactFax;
        }
        return $this;
    }
    /**
     * Get VisitContactHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactHomePhone()
    {
        return isset($this->VisitContactHomePhone) ? $this->VisitContactHomePhone : null;
    }
    /**
     * Set VisitContactHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactHomePhone
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitContactHomePhone($visitContactHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactHomePhone) && !is_string($visitContactHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactHomePhone, true), gettype($visitContactHomePhone)), __LINE__);
        }
        if (is_null($visitContactHomePhone) || (is_array($visitContactHomePhone) && empty($visitContactHomePhone))) {
            unset($this->VisitContactHomePhone);
        } else {
            $this->VisitContactHomePhone = $visitContactHomePhone;
        }
        return $this;
    }
    /**
     * Get VisitContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactId()
    {
        return isset($this->VisitContactId) ? $this->VisitContactId : null;
    }
    /**
     * Set VisitContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitContactId($visitContactId = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactId) && !is_string($visitContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactId, true), gettype($visitContactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitContactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitContactId, true)), __LINE__);
        }
        if (is_null($visitContactId) || (is_array($visitContactId) && empty($visitContactId))) {
            unset($this->VisitContactId);
        } else {
            $this->VisitContactId = $visitContactId;
        }
        return $this;
    }
    /**
     * Get VisitContactMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactMobile()
    {
        return isset($this->VisitContactMobile) ? $this->VisitContactMobile : null;
    }
    /**
     * Set VisitContactMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactMobile
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitContactMobile($visitContactMobile = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactMobile) && !is_string($visitContactMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactMobile, true), gettype($visitContactMobile)), __LINE__);
        }
        if (is_null($visitContactMobile) || (is_array($visitContactMobile) && empty($visitContactMobile))) {
            unset($this->VisitContactMobile);
        } else {
            $this->VisitContactMobile = $visitContactMobile;
        }
        return $this;
    }
    /**
     * Get VisitNatureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitNatureId()
    {
        return isset($this->VisitNatureId) ? $this->VisitNatureId : null;
    }
    /**
     * Set VisitNatureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitNatureId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitNatureId($visitNatureId = null)
    {
        // validation for constraint: string
        if (!is_null($visitNatureId) && !is_string($visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitNatureId, true), gettype($visitNatureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitNatureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitNatureId, true)), __LINE__);
        }
        if (is_null($visitNatureId) || (is_array($visitNatureId) && empty($visitNatureId))) {
            unset($this->VisitNatureId);
        } else {
            $this->VisitNatureId = $visitNatureId;
        }
        return $this;
    }
    /**
     * Get VisitPayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPayerAccountId()
    {
        return isset($this->VisitPayerAccountId) ? $this->VisitPayerAccountId : null;
    }
    /**
     * Set VisitPayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPayerAccountId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitPayerAccountId($visitPayerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPayerAccountId) && !is_string($visitPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPayerAccountId, true), gettype($visitPayerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPayerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPayerAccountId, true)), __LINE__);
        }
        if (is_null($visitPayerAccountId) || (is_array($visitPayerAccountId) && empty($visitPayerAccountId))) {
            unset($this->VisitPayerAccountId);
        } else {
            $this->VisitPayerAccountId = $visitPayerAccountId;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitSkills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getVisitSkills()
    {
        return isset($this->VisitSkills) ? $this->VisitSkills : null;
    }
    /**
     * Set VisitSkills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $visitSkills
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitSkills(\patest\ArrayType\ArrayOfguid $visitSkills = null)
    {
        if (is_null($visitSkills) || (is_array($visitSkills) && empty($visitSkills))) {
            unset($this->VisitSkills);
        } else {
            $this->VisitSkills = $visitSkills;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return $this->VisitTypeId;
    }
    /**
     * Set VisitTypeId value
     * @param string $visitTypeId
     * @return \patest\StructType\CreateVisitRequest
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        $this->VisitTypeId = $visitTypeId;
        return $this;
    }
}
