<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateTicketViewAssociation-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateTicketViewAssociation-Request
 * @subpackage Structs
 */
class CreateTicketViewAssociation_Request extends TicketViewAssociationRequestBase
{
    /**
     * The ApplicationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationLevel;
    /**
     * The ApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationObjectIdentifier;
    /**
     * The ComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComponentId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for CreateTicketViewAssociation-Request
     * @uses CreateTicketViewAssociation_Request::setApplicationLevel()
     * @uses CreateTicketViewAssociation_Request::setApplicationObjectIdentifier()
     * @uses CreateTicketViewAssociation_Request::setComponentId()
     * @uses CreateTicketViewAssociation_Request::setPriority()
     * @param string $applicationLevel
     * @param string $applicationObjectIdentifier
     * @param string $componentId
     * @param int $priority
     */
    public function __construct($applicationLevel = null, $applicationObjectIdentifier = null, $componentId = null, $priority = null)
    {
        $this
            ->setApplicationLevel($applicationLevel)
            ->setApplicationObjectIdentifier($applicationObjectIdentifier)
            ->setComponentId($componentId)
            ->setPriority($priority);
    }
    /**
     * Get ApplicationLevel value
     * @return string|null
     */
    public function getApplicationLevel()
    {
        return $this->ApplicationLevel;
    }
    /**
     * Set ApplicationLevel value
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationLevel
     * @return \patest\StructType\CreateTicketViewAssociation_Request
     */
    public function setApplicationLevel($applicationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid($applicationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationApplicationLevel', is_array($applicationLevel) ? implode(', ', $applicationLevel) : var_export($applicationLevel, true), implode(', ', \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues())), __LINE__);
        }
        $this->ApplicationLevel = $applicationLevel;
        return $this;
    }
    /**
     * Get ApplicationObjectIdentifier value
     * @return string|null
     */
    public function getApplicationObjectIdentifier()
    {
        return $this->ApplicationObjectIdentifier;
    }
    /**
     * Set ApplicationObjectIdentifier value
     * @param string $applicationObjectIdentifier
     * @return \patest\StructType\CreateTicketViewAssociation_Request
     */
    public function setApplicationObjectIdentifier($applicationObjectIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectIdentifier) && !is_string($applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectIdentifier, true), gettype($applicationObjectIdentifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationObjectIdentifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationObjectIdentifier, true)), __LINE__);
        }
        $this->ApplicationObjectIdentifier = $applicationObjectIdentifier;
        return $this;
    }
    /**
     * Get ComponentId value
     * @return string|null
     */
    public function getComponentId()
    {
        return $this->ComponentId;
    }
    /**
     * Set ComponentId value
     * @param string $componentId
     * @return \patest\StructType\CreateTicketViewAssociation_Request
     */
    public function setComponentId($componentId = null)
    {
        // validation for constraint: string
        if (!is_null($componentId) && !is_string($componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentId, true), gettype($componentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($componentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($componentId, true)), __LINE__);
        }
        $this->ComponentId = $componentId;
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\CreateTicketViewAssociation_Request
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
}
