<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentTokenWithoutPaymentResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePaymentTokenWithoutPaymentResponse
 * @subpackage Structs
 */
class CreatePaymentTokenWithoutPaymentResponse extends ExtensibleDataContract
{
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * The ProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProviderSpecificTokenId;
    /**
     * The RequiredUserInteractionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\UserInteractionDetails
     */
    public $RequiredUserInteractionDetails;
    /**
     * Constructor method for CreatePaymentTokenWithoutPaymentResponse
     * @uses CreatePaymentTokenWithoutPaymentResponse::setPaymentSessionId()
     * @uses CreatePaymentTokenWithoutPaymentResponse::setProviderSpecificTokenId()
     * @uses CreatePaymentTokenWithoutPaymentResponse::setRequiredUserInteractionDetails()
     * @param string $paymentSessionId
     * @param string $providerSpecificTokenId
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteractionDetails
     */
    public function __construct($paymentSessionId = null, $providerSpecificTokenId = null, \patest\StructType\UserInteractionDetails $requiredUserInteractionDetails = null)
    {
        $this
            ->setPaymentSessionId($paymentSessionId)
            ->setProviderSpecificTokenId($providerSpecificTokenId)
            ->setRequiredUserInteractionDetails($requiredUserInteractionDetails);
    }
    /**
     * Get PaymentSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return isset($this->PaymentSessionId) ? $this->PaymentSessionId : null;
    }
    /**
     * Set PaymentSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSessionId
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentResponse
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        if (is_null($paymentSessionId) || (is_array($paymentSessionId) && empty($paymentSessionId))) {
            unset($this->PaymentSessionId);
        } else {
            $this->PaymentSessionId = $paymentSessionId;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificTokenId()
    {
        return isset($this->ProviderSpecificTokenId) ? $this->ProviderSpecificTokenId : null;
    }
    /**
     * Set ProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificTokenId
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentResponse
     */
    public function setProviderSpecificTokenId($providerSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificTokenId) && !is_string($providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificTokenId, true), gettype($providerSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($providerSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($providerSpecificTokenId, true)), __LINE__);
        }
        if (is_null($providerSpecificTokenId) || (is_array($providerSpecificTokenId) && empty($providerSpecificTokenId))) {
            unset($this->ProviderSpecificTokenId);
        } else {
            $this->ProviderSpecificTokenId = $providerSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get RequiredUserInteractionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\UserInteractionDetails|null
     */
    public function getRequiredUserInteractionDetails()
    {
        return isset($this->RequiredUserInteractionDetails) ? $this->RequiredUserInteractionDetails : null;
    }
    /**
     * Set RequiredUserInteractionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteractionDetails
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentResponse
     */
    public function setRequiredUserInteractionDetails(\patest\StructType\UserInteractionDetails $requiredUserInteractionDetails = null)
    {
        if (is_null($requiredUserInteractionDetails) || (is_array($requiredUserInteractionDetails) && empty($requiredUserInteractionDetails))) {
            unset($this->RequiredUserInteractionDetails);
        } else {
            $this->RequiredUserInteractionDetails = $requiredUserInteractionDetails;
        }
        return $this;
    }
}
