<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentContextRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePaymentContextRequest
 * @subpackage Structs
 */
class CreatePaymentContextRequest extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The FrontendUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrontendUrl;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Locale;
    /**
     * The UserAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserAgent;
    /**
     * Constructor method for CreatePaymentContextRequest
     * @uses CreatePaymentContextRequest::setCountryCode()
     * @uses CreatePaymentContextRequest::setCurrency()
     * @uses CreatePaymentContextRequest::setFrontendUrl()
     * @uses CreatePaymentContextRequest::setLocale()
     * @uses CreatePaymentContextRequest::setUserAgent()
     * @param string $countryCode
     * @param string $currency
     * @param string $frontendUrl
     * @param string $locale
     * @param string $userAgent
     */
    public function __construct($countryCode = null, $currency = null, $frontendUrl = null, $locale = null, $userAgent = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setCurrency($currency)
            ->setFrontendUrl($frontendUrl)
            ->setLocale($locale)
            ->setUserAgent($userAgent);
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \patest\StructType\CreatePaymentContextRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \patest\StructType\CreatePaymentContextRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get FrontendUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrontendUrl()
    {
        return isset($this->FrontendUrl) ? $this->FrontendUrl : null;
    }
    /**
     * Set FrontendUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frontendUrl
     * @return \patest\StructType\CreatePaymentContextRequest
     */
    public function setFrontendUrl($frontendUrl = null)
    {
        // validation for constraint: string
        if (!is_null($frontendUrl) && !is_string($frontendUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontendUrl, true), gettype($frontendUrl)), __LINE__);
        }
        if (is_null($frontendUrl) || (is_array($frontendUrl) && empty($frontendUrl))) {
            unset($this->FrontendUrl);
        } else {
            $this->FrontendUrl = $frontendUrl;
        }
        return $this;
    }
    /**
     * Get Locale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocale()
    {
        return isset($this->Locale) ? $this->Locale : null;
    }
    /**
     * Set Locale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locale
     * @return \patest\StructType\CreatePaymentContextRequest
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        if (is_null($locale) || (is_array($locale) && empty($locale))) {
            unset($this->Locale);
        } else {
            $this->Locale = $locale;
        }
        return $this;
    }
    /**
     * Get UserAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserAgent()
    {
        return isset($this->UserAgent) ? $this->UserAgent : null;
    }
    /**
     * Set UserAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userAgent
     * @return \patest\StructType\CreatePaymentContextRequest
     */
    public function setUserAgent($userAgent = null)
    {
        // validation for constraint: string
        if (!is_null($userAgent) && !is_string($userAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userAgent, true), gettype($userAgent)), __LINE__);
        }
        if (is_null($userAgent) || (is_array($userAgent) && empty($userAgent))) {
            unset($this->UserAgent);
        } else {
            $this->UserAgent = $userAgent;
        }
        return $this;
    }
}
