<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateNewTransaction-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateNewTransaction-Request
 * @subpackage Structs
 */
class CreateNewTransaction_Request extends ExtensibleDataContract
{
    /**
     * The AccountContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContactPersonId;
    /**
     * The AssociatedClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionClientDetails
     */
    public $AssociatedClient;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The RetailerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerCompanyId;
    /**
     * The RetailerTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RetailerTransactionGuid;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleMode;
    /**
     * The UseUnpublishedRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseUnpublishedRules;
    /**
     * The SourceTransactionGuidToLink
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceTransactionGuidToLink;
    /**
     * The ReturnTransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnTransactionSnapshot;
    /**
     * Constructor method for CreateNewTransaction-Request
     * @uses CreateNewTransaction_Request::setAccountContactPersonId()
     * @uses CreateNewTransaction_Request::setAssociatedClient()
     * @uses CreateNewTransaction_Request::setInteractionChannel()
     * @uses CreateNewTransaction_Request::setOnBehalfOfAccountId()
     * @uses CreateNewTransaction_Request::setRetailerCompanyId()
     * @uses CreateNewTransaction_Request::setRetailerTransactionGuid()
     * @uses CreateNewTransaction_Request::setSaleMode()
     * @uses CreateNewTransaction_Request::setUseUnpublishedRules()
     * @uses CreateNewTransaction_Request::setSourceTransactionGuidToLink()
     * @uses CreateNewTransaction_Request::setReturnTransactionSnapshot()
     * @param string $accountContactPersonId
     * @param \patest\StructType\TransactionClientDetails $associatedClient
     * @param string $interactionChannel
     * @param string $onBehalfOfAccountId
     * @param int $retailerCompanyId
     * @param string $retailerTransactionGuid
     * @param string $saleMode
     * @param bool $useUnpublishedRules
     * @param string $sourceTransactionGuidToLink
     * @param bool $returnTransactionSnapshot
     */
    public function __construct($accountContactPersonId = null, \patest\StructType\TransactionClientDetails $associatedClient = null, $interactionChannel = null, $onBehalfOfAccountId = null, $retailerCompanyId = null, $retailerTransactionGuid = null, $saleMode = null, $useUnpublishedRules = null, $sourceTransactionGuidToLink = null, $returnTransactionSnapshot = null)
    {
        $this
            ->setAccountContactPersonId($accountContactPersonId)
            ->setAssociatedClient($associatedClient)
            ->setInteractionChannel($interactionChannel)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setRetailerCompanyId($retailerCompanyId)
            ->setRetailerTransactionGuid($retailerTransactionGuid)
            ->setSaleMode($saleMode)
            ->setUseUnpublishedRules($useUnpublishedRules)
            ->setSourceTransactionGuidToLink($sourceTransactionGuidToLink)
            ->setReturnTransactionSnapshot($returnTransactionSnapshot);
    }
    /**
     * Get AccountContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContactPersonId()
    {
        return isset($this->AccountContactPersonId) ? $this->AccountContactPersonId : null;
    }
    /**
     * Set AccountContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContactPersonId
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setAccountContactPersonId($accountContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContactPersonId) && !is_string($accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContactPersonId, true), gettype($accountContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContactPersonId, true)), __LINE__);
        }
        if (is_null($accountContactPersonId) || (is_array($accountContactPersonId) && empty($accountContactPersonId))) {
            unset($this->AccountContactPersonId);
        } else {
            $this->AccountContactPersonId = $accountContactPersonId;
        }
        return $this;
    }
    /**
     * Get AssociatedClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionClientDetails|null
     */
    public function getAssociatedClient()
    {
        return isset($this->AssociatedClient) ? $this->AssociatedClient : null;
    }
    /**
     * Set AssociatedClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionClientDetails $associatedClient
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setAssociatedClient(\patest\StructType\TransactionClientDetails $associatedClient = null)
    {
        if (is_null($associatedClient) || (is_array($associatedClient) && empty($associatedClient))) {
            unset($this->AssociatedClient);
        } else {
            $this->AssociatedClient = $associatedClient;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get RetailerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerCompanyId()
    {
        return isset($this->RetailerCompanyId) ? $this->RetailerCompanyId : null;
    }
    /**
     * Set RetailerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerCompanyId
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setRetailerCompanyId($retailerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($retailerCompanyId) && !(is_int($retailerCompanyId) || ctype_digit($retailerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerCompanyId, true), gettype($retailerCompanyId)), __LINE__);
        }
        if (is_null($retailerCompanyId) || (is_array($retailerCompanyId) && empty($retailerCompanyId))) {
            unset($this->RetailerCompanyId);
        } else {
            $this->RetailerCompanyId = $retailerCompanyId;
        }
        return $this;
    }
    /**
     * Get RetailerTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetailerTransactionGuid()
    {
        return isset($this->RetailerTransactionGuid) ? $this->RetailerTransactionGuid : null;
    }
    /**
     * Set RetailerTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retailerTransactionGuid
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setRetailerTransactionGuid($retailerTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($retailerTransactionGuid) && !is_string($retailerTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retailerTransactionGuid, true), gettype($retailerTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($retailerTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $retailerTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($retailerTransactionGuid, true)), __LINE__);
        }
        if (is_null($retailerTransactionGuid) || (is_array($retailerTransactionGuid) && empty($retailerTransactionGuid))) {
            unset($this->RetailerTransactionGuid);
        } else {
            $this->RetailerTransactionGuid = $retailerTransactionGuid;
        }
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleMode
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setSaleMode($saleMode = null)
    {
        // validation for constraint: string
        if (!is_null($saleMode) && !is_string($saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleMode, true), gettype($saleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleMode, true)), __LINE__);
        }
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get UseUnpublishedRules value
     * @return bool|null
     */
    public function getUseUnpublishedRules()
    {
        return $this->UseUnpublishedRules;
    }
    /**
     * Set UseUnpublishedRules value
     * @param bool $useUnpublishedRules
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setUseUnpublishedRules($useUnpublishedRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useUnpublishedRules) && !is_bool($useUnpublishedRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useUnpublishedRules, true), gettype($useUnpublishedRules)), __LINE__);
        }
        $this->UseUnpublishedRules = $useUnpublishedRules;
        return $this;
    }
    /**
     * Get SourceTransactionGuidToLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceTransactionGuidToLink()
    {
        return isset($this->SourceTransactionGuidToLink) ? $this->SourceTransactionGuidToLink : null;
    }
    /**
     * Set SourceTransactionGuidToLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceTransactionGuidToLink
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setSourceTransactionGuidToLink($sourceTransactionGuidToLink = null)
    {
        // validation for constraint: string
        if (!is_null($sourceTransactionGuidToLink) && !is_string($sourceTransactionGuidToLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceTransactionGuidToLink, true), gettype($sourceTransactionGuidToLink)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceTransactionGuidToLink) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceTransactionGuidToLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceTransactionGuidToLink, true)), __LINE__);
        }
        if (is_null($sourceTransactionGuidToLink) || (is_array($sourceTransactionGuidToLink) && empty($sourceTransactionGuidToLink))) {
            unset($this->SourceTransactionGuidToLink);
        } else {
            $this->SourceTransactionGuidToLink = $sourceTransactionGuidToLink;
        }
        return $this;
    }
    /**
     * Get ReturnTransactionSnapshot value
     * @return bool|null
     */
    public function getReturnTransactionSnapshot()
    {
        return $this->ReturnTransactionSnapshot;
    }
    /**
     * Set ReturnTransactionSnapshot value
     * @param bool $returnTransactionSnapshot
     * @return \patest\StructType\CreateNewTransaction_Request
     */
    public function setReturnTransactionSnapshot($returnTransactionSnapshot = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnTransactionSnapshot) && !is_bool($returnTransactionSnapshot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnTransactionSnapshot, true), gettype($returnTransactionSnapshot)), __LINE__);
        }
        $this->ReturnTransactionSnapshot = $returnTransactionSnapshot;
        return $this;
    }
}
