<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateDraftInvoicesDefaults StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateDraftInvoicesDefaults
 * @subpackage Structs
 */
class CreateDraftInvoicesDefaults extends AbstractStructBase
{
    /**
     * The CalculateCommissionPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CalculateCommissionPerTransaction;
    /**
     * The FromSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromSellDate;
    /**
     * The IncludeActualLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeActualLiabilities;
    /**
     * The IncludePendingLiabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePendingLiabilities;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The UntilSellDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilSellDate;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * Constructor method for CreateDraftInvoicesDefaults
     * @uses CreateDraftInvoicesDefaults::setCalculateCommissionPerTransaction()
     * @uses CreateDraftInvoicesDefaults::setFromSellDate()
     * @uses CreateDraftInvoicesDefaults::setIncludeActualLiabilities()
     * @uses CreateDraftInvoicesDefaults::setIncludePendingLiabilities()
     * @uses CreateDraftInvoicesDefaults::setRemark()
     * @uses CreateDraftInvoicesDefaults::setUntilSellDate()
     * @uses CreateDraftInvoicesDefaults::setPurposeId()
     * @uses CreateDraftInvoicesDefaults::setGroupByFullPrice()
     * @param bool $calculateCommissionPerTransaction
     * @param string $fromSellDate
     * @param bool $includeActualLiabilities
     * @param bool $includePendingLiabilities
     * @param string $remark
     * @param string $untilSellDate
     * @param string $purposeId
     * @param bool $groupByFullPrice
     */
    public function __construct($calculateCommissionPerTransaction = null, $fromSellDate = null, $includeActualLiabilities = null, $includePendingLiabilities = null, $remark = null, $untilSellDate = null, $purposeId = null, $groupByFullPrice = null)
    {
        $this
            ->setCalculateCommissionPerTransaction($calculateCommissionPerTransaction)
            ->setFromSellDate($fromSellDate)
            ->setIncludeActualLiabilities($includeActualLiabilities)
            ->setIncludePendingLiabilities($includePendingLiabilities)
            ->setRemark($remark)
            ->setUntilSellDate($untilSellDate)
            ->setPurposeId($purposeId)
            ->setGroupByFullPrice($groupByFullPrice);
    }
    /**
     * Get CalculateCommissionPerTransaction value
     * @return bool|null
     */
    public function getCalculateCommissionPerTransaction()
    {
        return $this->CalculateCommissionPerTransaction;
    }
    /**
     * Set CalculateCommissionPerTransaction value
     * @param bool $calculateCommissionPerTransaction
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setCalculateCommissionPerTransaction($calculateCommissionPerTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateCommissionPerTransaction) && !is_bool($calculateCommissionPerTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateCommissionPerTransaction, true), gettype($calculateCommissionPerTransaction)), __LINE__);
        }
        $this->CalculateCommissionPerTransaction = $calculateCommissionPerTransaction;
        return $this;
    }
    /**
     * Get FromSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromSellDate()
    {
        return isset($this->FromSellDate) ? $this->FromSellDate : null;
    }
    /**
     * Set FromSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromSellDate
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setFromSellDate($fromSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromSellDate) && !is_string($fromSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSellDate, true), gettype($fromSellDate)), __LINE__);
        }
        if (is_null($fromSellDate) || (is_array($fromSellDate) && empty($fromSellDate))) {
            unset($this->FromSellDate);
        } else {
            $this->FromSellDate = $fromSellDate;
        }
        return $this;
    }
    /**
     * Get IncludeActualLiabilities value
     * @return bool|null
     */
    public function getIncludeActualLiabilities()
    {
        return $this->IncludeActualLiabilities;
    }
    /**
     * Set IncludeActualLiabilities value
     * @param bool $includeActualLiabilities
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setIncludeActualLiabilities($includeActualLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeActualLiabilities) && !is_bool($includeActualLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeActualLiabilities, true), gettype($includeActualLiabilities)), __LINE__);
        }
        $this->IncludeActualLiabilities = $includeActualLiabilities;
        return $this;
    }
    /**
     * Get IncludePendingLiabilities value
     * @return bool|null
     */
    public function getIncludePendingLiabilities()
    {
        return $this->IncludePendingLiabilities;
    }
    /**
     * Set IncludePendingLiabilities value
     * @param bool $includePendingLiabilities
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setIncludePendingLiabilities($includePendingLiabilities = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePendingLiabilities) && !is_bool($includePendingLiabilities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePendingLiabilities, true), gettype($includePendingLiabilities)), __LINE__);
        }
        $this->IncludePendingLiabilities = $includePendingLiabilities;
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get UntilSellDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilSellDate()
    {
        return isset($this->UntilSellDate) ? $this->UntilSellDate : null;
    }
    /**
     * Set UntilSellDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilSellDate
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setUntilSellDate($untilSellDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilSellDate) && !is_string($untilSellDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilSellDate, true), gettype($untilSellDate)), __LINE__);
        }
        if (is_null($untilSellDate) || (is_array($untilSellDate) && empty($untilSellDate))) {
            unset($this->UntilSellDate);
        } else {
            $this->UntilSellDate = $untilSellDate;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return $this->GroupByFullPrice;
    }
    /**
     * Set GroupByFullPrice value
     * @param bool $groupByFullPrice
     * @return \patest\StructType\CreateDraftInvoicesDefaults
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        $this->GroupByFullPrice = $groupByFullPrice;
        return $this;
    }
}
