<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyEvent-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CopyEvent-Request
 * @subpackage Structs
 */
class CopyEvent_Request extends ExtensibleDataContract
{
    /**
     * The CopyOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CopyOptions;
    /**
     * The CopyRangeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyRangeFrom;
    /**
     * The CopyRangeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyRangeTo;
    /**
     * The CopyTimeOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CopyTimeOptions;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ExcludeDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDayOfWeek
     */
    public $ExcludeDays;
    /**
     * The ExcludeSpecificDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $ExcludeSpecificDates;
    /**
     * The SpecificHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $SpecificHours;
    /**
     * The RequestedSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $RequestedSaleStatus;
    /**
     * The CopyRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyRules;
    /**
     * The CopyAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyAccessControl;
    /**
     * The CopySeriesAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopySeriesAvailability;
    /**
     * The CopyResaleAvailabilityByApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyResaleAvailabilityByApplicationChannel;
    /**
     * The CountOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CountOnly;
    /**
     * The ReportOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReportOnly;
    /**
     * The SpecificDatesAndTimes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $SpecificDatesAndTimes;
    /**
     * The CopyEventClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyEventClassification;
    /**
     * The CopyPriceListAsNewInstance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyPriceListAsNewInstance;
    /**
     * The CopySeatLevelPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopySeatLevelPrices;
    /**
     * Constructor method for CopyEvent-Request
     * @uses CopyEvent_Request::setCopyOptions()
     * @uses CopyEvent_Request::setCopyRangeFrom()
     * @uses CopyEvent_Request::setCopyRangeTo()
     * @uses CopyEvent_Request::setCopyTimeOptions()
     * @uses CopyEvent_Request::setEventId()
     * @uses CopyEvent_Request::setExcludeDays()
     * @uses CopyEvent_Request::setExcludeSpecificDates()
     * @uses CopyEvent_Request::setSpecificHours()
     * @uses CopyEvent_Request::setRequestedSaleStatus()
     * @uses CopyEvent_Request::setCopyRules()
     * @uses CopyEvent_Request::setCopyAccessControl()
     * @uses CopyEvent_Request::setCopySeriesAvailability()
     * @uses CopyEvent_Request::setCopyResaleAvailabilityByApplicationChannel()
     * @uses CopyEvent_Request::setCountOnly()
     * @uses CopyEvent_Request::setReportOnly()
     * @uses CopyEvent_Request::setSpecificDatesAndTimes()
     * @uses CopyEvent_Request::setCopyEventClassification()
     * @uses CopyEvent_Request::setCopyPriceListAsNewInstance()
     * @uses CopyEvent_Request::setCopySeatLevelPrices()
     * @param string[] $copyOptions
     * @param string $copyRangeFrom
     * @param string $copyRangeTo
     * @param string $copyTimeOptions
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfDayOfWeek $excludeDays
     * @param \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates
     * @param \patest\ArrayType\ArrayOfdateTime $specificHours
     * @param string[] $requestedSaleStatus
     * @param bool $copyRules
     * @param bool $copyAccessControl
     * @param bool $copySeriesAvailability
     * @param bool $copyResaleAvailabilityByApplicationChannel
     * @param bool $countOnly
     * @param bool $reportOnly
     * @param \patest\ArrayType\ArrayOfdateTime $specificDatesAndTimes
     * @param bool $copyEventClassification
     * @param bool $copyPriceListAsNewInstance
     * @param bool $copySeatLevelPrices
     */
    public function __construct(array $copyOptions = array(), $copyRangeFrom = null, $copyRangeTo = null, $copyTimeOptions = null, $eventId = null, \patest\ArrayType\ArrayOfDayOfWeek $excludeDays = null, \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates = null, \patest\ArrayType\ArrayOfdateTime $specificHours = null, array $requestedSaleStatus = array(), $copyRules = null, $copyAccessControl = null, $copySeriesAvailability = null, $copyResaleAvailabilityByApplicationChannel = null, $countOnly = null, $reportOnly = null, \patest\ArrayType\ArrayOfdateTime $specificDatesAndTimes = null, $copyEventClassification = null, $copyPriceListAsNewInstance = null, $copySeatLevelPrices = null)
    {
        $this
            ->setCopyOptions($copyOptions)
            ->setCopyRangeFrom($copyRangeFrom)
            ->setCopyRangeTo($copyRangeTo)
            ->setCopyTimeOptions($copyTimeOptions)
            ->setEventId($eventId)
            ->setExcludeDays($excludeDays)
            ->setExcludeSpecificDates($excludeSpecificDates)
            ->setSpecificHours($specificHours)
            ->setRequestedSaleStatus($requestedSaleStatus)
            ->setCopyRules($copyRules)
            ->setCopyAccessControl($copyAccessControl)
            ->setCopySeriesAvailability($copySeriesAvailability)
            ->setCopyResaleAvailabilityByApplicationChannel($copyResaleAvailabilityByApplicationChannel)
            ->setCountOnly($countOnly)
            ->setReportOnly($reportOnly)
            ->setSpecificDatesAndTimes($specificDatesAndTimes)
            ->setCopyEventClassification($copyEventClassification)
            ->setCopyPriceListAsNewInstance($copyPriceListAsNewInstance)
            ->setCopySeatLevelPrices($copySeatLevelPrices);
    }
    /**
     * Get CopyOptions value
     * @return string[]|null
     */
    public function getCopyOptions()
    {
        return $this->CopyOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setCopyOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyOptionsForArrayConstraintsFromSetCopyOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $copyEvent_RequestCopyOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CopyEventPropertyOptions::valueIsValid($copyEvent_RequestCopyOptionsItem)) {
                $invalidValues[] = is_object($copyEvent_RequestCopyOptionsItem) ? get_class($copyEvent_RequestCopyOptionsItem) : sprintf('%s(%s)', gettype($copyEvent_RequestCopyOptionsItem), var_export($copyEvent_RequestCopyOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CopyEventPropertyOptions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CopyEventPropertyOptions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CopyOptions value
     * @uses \patest\EnumType\CopyEventPropertyOptions::valueIsValid()
     * @uses \patest\EnumType\CopyEventPropertyOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $copyOptions
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyOptions(array $copyOptions = array())
    {
        // validation for constraint: list
        if ('' !== ($copyOptionsArrayErrorMessage = self::validateCopyOptionsForArrayConstraintsFromSetCopyOptions($copyOptions))) {
            throw new \InvalidArgumentException($copyOptionsArrayErrorMessage, __LINE__);
        }
        $this->CopyOptions = is_array($copyOptions) ? implode(' ', $copyOptions) : null;
        return $this;
    }
    /**
     * Get CopyRangeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyRangeFrom()
    {
        return isset($this->CopyRangeFrom) ? $this->CopyRangeFrom : null;
    }
    /**
     * Set CopyRangeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyRangeFrom
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyRangeFrom($copyRangeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeFrom) && !is_string($copyRangeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeFrom, true), gettype($copyRangeFrom)), __LINE__);
        }
        if (is_null($copyRangeFrom) || (is_array($copyRangeFrom) && empty($copyRangeFrom))) {
            unset($this->CopyRangeFrom);
        } else {
            $this->CopyRangeFrom = $copyRangeFrom;
        }
        return $this;
    }
    /**
     * Get CopyRangeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyRangeTo()
    {
        return isset($this->CopyRangeTo) ? $this->CopyRangeTo : null;
    }
    /**
     * Set CopyRangeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyRangeTo
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyRangeTo($copyRangeTo = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeTo) && !is_string($copyRangeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeTo, true), gettype($copyRangeTo)), __LINE__);
        }
        if (is_null($copyRangeTo) || (is_array($copyRangeTo) && empty($copyRangeTo))) {
            unset($this->CopyRangeTo);
        } else {
            $this->CopyRangeTo = $copyRangeTo;
        }
        return $this;
    }
    /**
     * Get CopyTimeOptions value
     * @return string|null
     */
    public function getCopyTimeOptions()
    {
        return $this->CopyTimeOptions;
    }
    /**
     * Set CopyTimeOptions value
     * @uses \patest\EnumType\CopyEventTimeOptions::valueIsValid()
     * @uses \patest\EnumType\CopyEventTimeOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $copyTimeOptions
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyTimeOptions($copyTimeOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CopyEventTimeOptions::valueIsValid($copyTimeOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CopyEventTimeOptions', is_array($copyTimeOptions) ? implode(', ', $copyTimeOptions) : var_export($copyTimeOptions, true), implode(', ', \patest\EnumType\CopyEventTimeOptions::getValidValues())), __LINE__);
        }
        $this->CopyTimeOptions = $copyTimeOptions;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get ExcludeDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDayOfWeek|null
     */
    public function getExcludeDays()
    {
        return isset($this->ExcludeDays) ? $this->ExcludeDays : null;
    }
    /**
     * Set ExcludeDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDayOfWeek $excludeDays
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setExcludeDays(\patest\ArrayType\ArrayOfDayOfWeek $excludeDays = null)
    {
        if (is_null($excludeDays) || (is_array($excludeDays) && empty($excludeDays))) {
            unset($this->ExcludeDays);
        } else {
            $this->ExcludeDays = $excludeDays;
        }
        return $this;
    }
    /**
     * Get ExcludeSpecificDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getExcludeSpecificDates()
    {
        return isset($this->ExcludeSpecificDates) ? $this->ExcludeSpecificDates : null;
    }
    /**
     * Set ExcludeSpecificDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setExcludeSpecificDates(\patest\ArrayType\ArrayOfdateTime $excludeSpecificDates = null)
    {
        if (is_null($excludeSpecificDates) || (is_array($excludeSpecificDates) && empty($excludeSpecificDates))) {
            unset($this->ExcludeSpecificDates);
        } else {
            $this->ExcludeSpecificDates = $excludeSpecificDates;
        }
        return $this;
    }
    /**
     * Get SpecificHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getSpecificHours()
    {
        return isset($this->SpecificHours) ? $this->SpecificHours : null;
    }
    /**
     * Set SpecificHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $specificHours
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setSpecificHours(\patest\ArrayType\ArrayOfdateTime $specificHours = null)
    {
        if (is_null($specificHours) || (is_array($specificHours) && empty($specificHours))) {
            unset($this->SpecificHours);
        } else {
            $this->SpecificHours = $specificHours;
        }
        return $this;
    }
    /**
     * Get RequestedSaleStatus value
     * @return string[]|null
     */
    public function getRequestedSaleStatus()
    {
        return $this->RequestedSaleStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestedSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedSaleStatusForArrayConstraintsFromSetRequestedSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $copyEvent_RequestRequestedSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($copyEvent_RequestRequestedSaleStatusItem)) {
                $invalidValues[] = is_object($copyEvent_RequestRequestedSaleStatusItem) ? get_class($copyEvent_RequestRequestedSaleStatusItem) : sprintf('%s(%s)', gettype($copyEvent_RequestRequestedSaleStatusItem), var_export($copyEvent_RequestRequestedSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequestedSaleStatus value
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $requestedSaleStatus
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setRequestedSaleStatus(array $requestedSaleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($requestedSaleStatusArrayErrorMessage = self::validateRequestedSaleStatusForArrayConstraintsFromSetRequestedSaleStatus($requestedSaleStatus))) {
            throw new \InvalidArgumentException($requestedSaleStatusArrayErrorMessage, __LINE__);
        }
        $this->RequestedSaleStatus = is_array($requestedSaleStatus) ? implode(' ', $requestedSaleStatus) : null;
        return $this;
    }
    /**
     * Get CopyRules value
     * @return bool|null
     */
    public function getCopyRules()
    {
        return $this->CopyRules;
    }
    /**
     * Set CopyRules value
     * @param bool $copyRules
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyRules($copyRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyRules) && !is_bool($copyRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyRules, true), gettype($copyRules)), __LINE__);
        }
        $this->CopyRules = $copyRules;
        return $this;
    }
    /**
     * Get CopyAccessControl value
     * @return bool|null
     */
    public function getCopyAccessControl()
    {
        return $this->CopyAccessControl;
    }
    /**
     * Set CopyAccessControl value
     * @param bool $copyAccessControl
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyAccessControl($copyAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyAccessControl) && !is_bool($copyAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyAccessControl, true), gettype($copyAccessControl)), __LINE__);
        }
        $this->CopyAccessControl = $copyAccessControl;
        return $this;
    }
    /**
     * Get CopySeriesAvailability value
     * @return bool|null
     */
    public function getCopySeriesAvailability()
    {
        return $this->CopySeriesAvailability;
    }
    /**
     * Set CopySeriesAvailability value
     * @param bool $copySeriesAvailability
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopySeriesAvailability($copySeriesAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($copySeriesAvailability) && !is_bool($copySeriesAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copySeriesAvailability, true), gettype($copySeriesAvailability)), __LINE__);
        }
        $this->CopySeriesAvailability = $copySeriesAvailability;
        return $this;
    }
    /**
     * Get CopyResaleAvailabilityByApplicationChannel value
     * @return bool|null
     */
    public function getCopyResaleAvailabilityByApplicationChannel()
    {
        return $this->CopyResaleAvailabilityByApplicationChannel;
    }
    /**
     * Set CopyResaleAvailabilityByApplicationChannel value
     * @param bool $copyResaleAvailabilityByApplicationChannel
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyResaleAvailabilityByApplicationChannel($copyResaleAvailabilityByApplicationChannel = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyResaleAvailabilityByApplicationChannel) && !is_bool($copyResaleAvailabilityByApplicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyResaleAvailabilityByApplicationChannel, true), gettype($copyResaleAvailabilityByApplicationChannel)), __LINE__);
        }
        $this->CopyResaleAvailabilityByApplicationChannel = $copyResaleAvailabilityByApplicationChannel;
        return $this;
    }
    /**
     * Get CountOnly value
     * @return bool|null
     */
    public function getCountOnly()
    {
        return $this->CountOnly;
    }
    /**
     * Set CountOnly value
     * @param bool $countOnly
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCountOnly($countOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($countOnly) && !is_bool($countOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($countOnly, true), gettype($countOnly)), __LINE__);
        }
        $this->CountOnly = $countOnly;
        return $this;
    }
    /**
     * Get ReportOnly value
     * @return bool|null
     */
    public function getReportOnly()
    {
        return $this->ReportOnly;
    }
    /**
     * Set ReportOnly value
     * @param bool $reportOnly
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setReportOnly($reportOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($reportOnly) && !is_bool($reportOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reportOnly, true), gettype($reportOnly)), __LINE__);
        }
        $this->ReportOnly = $reportOnly;
        return $this;
    }
    /**
     * Get SpecificDatesAndTimes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getSpecificDatesAndTimes()
    {
        return isset($this->SpecificDatesAndTimes) ? $this->SpecificDatesAndTimes : null;
    }
    /**
     * Set SpecificDatesAndTimes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $specificDatesAndTimes
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setSpecificDatesAndTimes(\patest\ArrayType\ArrayOfdateTime $specificDatesAndTimes = null)
    {
        if (is_null($specificDatesAndTimes) || (is_array($specificDatesAndTimes) && empty($specificDatesAndTimes))) {
            unset($this->SpecificDatesAndTimes);
        } else {
            $this->SpecificDatesAndTimes = $specificDatesAndTimes;
        }
        return $this;
    }
    /**
     * Get CopyEventClassification value
     * @return bool|null
     */
    public function getCopyEventClassification()
    {
        return $this->CopyEventClassification;
    }
    /**
     * Set CopyEventClassification value
     * @param bool $copyEventClassification
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyEventClassification($copyEventClassification = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyEventClassification) && !is_bool($copyEventClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyEventClassification, true), gettype($copyEventClassification)), __LINE__);
        }
        $this->CopyEventClassification = $copyEventClassification;
        return $this;
    }
    /**
     * Get CopyPriceListAsNewInstance value
     * @return bool|null
     */
    public function getCopyPriceListAsNewInstance()
    {
        return $this->CopyPriceListAsNewInstance;
    }
    /**
     * Set CopyPriceListAsNewInstance value
     * @param bool $copyPriceListAsNewInstance
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopyPriceListAsNewInstance($copyPriceListAsNewInstance = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyPriceListAsNewInstance) && !is_bool($copyPriceListAsNewInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyPriceListAsNewInstance, true), gettype($copyPriceListAsNewInstance)), __LINE__);
        }
        $this->CopyPriceListAsNewInstance = $copyPriceListAsNewInstance;
        return $this;
    }
    /**
     * Get CopySeatLevelPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopySeatLevelPrices()
    {
        return isset($this->CopySeatLevelPrices) ? $this->CopySeatLevelPrices : null;
    }
    /**
     * Set CopySeatLevelPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copySeatLevelPrices
     * @return \patest\StructType\CopyEvent_Request
     */
    public function setCopySeatLevelPrices($copySeatLevelPrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($copySeatLevelPrices) && !is_bool($copySeatLevelPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copySeatLevelPrices, true), gettype($copySeatLevelPrices)), __LINE__);
        }
        if (is_null($copySeatLevelPrices) || (is_array($copySeatLevelPrices) && empty($copySeatLevelPrices))) {
            unset($this->CopySeatLevelPrices);
        } else {
            $this->CopySeatLevelPrices = $copySeatLevelPrices;
        }
        return $this;
    }
}
