<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyEventProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CopyEventProperties-Request
 * @subpackage Structs
 */
class CopyEventProperties_Request extends ExtensibleDataContract
{
    /**
     * The CopyOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CopyOptions;
    /**
     * The CopyRangeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CopyRangeFrom;
    /**
     * The CopyRangeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CopyRangeTo;
    /**
     * The ExcludeDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDayOfWeek
     */
    public $ExcludeDays;
    /**
     * The ExcludeSpecificDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $ExcludeSpecificDates;
    /**
     * The SourceEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceEventId;
    /**
     * The TargetShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetShowId;
    /**
     * The IsMergeSourceAndTargetValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMergeSourceAndTargetValues;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * Constructor method for CopyEventProperties-Request
     * @uses CopyEventProperties_Request::setCopyOptions()
     * @uses CopyEventProperties_Request::setCopyRangeFrom()
     * @uses CopyEventProperties_Request::setCopyRangeTo()
     * @uses CopyEventProperties_Request::setExcludeDays()
     * @uses CopyEventProperties_Request::setExcludeSpecificDates()
     * @uses CopyEventProperties_Request::setSourceEventId()
     * @uses CopyEventProperties_Request::setTargetShowId()
     * @uses CopyEventProperties_Request::setIsMergeSourceAndTargetValues()
     * @uses CopyEventProperties_Request::setEventIds()
     * @param string[] $copyOptions
     * @param string $copyRangeFrom
     * @param string $copyRangeTo
     * @param \patest\ArrayType\ArrayOfDayOfWeek $excludeDays
     * @param \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates
     * @param string $sourceEventId
     * @param string $targetShowId
     * @param bool $isMergeSourceAndTargetValues
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     */
    public function __construct(array $copyOptions = array(), $copyRangeFrom = null, $copyRangeTo = null, \patest\ArrayType\ArrayOfDayOfWeek $excludeDays = null, \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates = null, $sourceEventId = null, $targetShowId = null, $isMergeSourceAndTargetValues = null, \patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        $this
            ->setCopyOptions($copyOptions)
            ->setCopyRangeFrom($copyRangeFrom)
            ->setCopyRangeTo($copyRangeTo)
            ->setExcludeDays($excludeDays)
            ->setExcludeSpecificDates($excludeSpecificDates)
            ->setSourceEventId($sourceEventId)
            ->setTargetShowId($targetShowId)
            ->setIsMergeSourceAndTargetValues($isMergeSourceAndTargetValues)
            ->setEventIds($eventIds);
    }
    /**
     * Get CopyOptions value
     * @return string[]|null
     */
    public function getCopyOptions()
    {
        return $this->CopyOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setCopyOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyOptionsForArrayConstraintsFromSetCopyOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $copyEventProperties_RequestCopyOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CopyEventPropertyOptions::valueIsValid($copyEventProperties_RequestCopyOptionsItem)) {
                $invalidValues[] = is_object($copyEventProperties_RequestCopyOptionsItem) ? get_class($copyEventProperties_RequestCopyOptionsItem) : sprintf('%s(%s)', gettype($copyEventProperties_RequestCopyOptionsItem), var_export($copyEventProperties_RequestCopyOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CopyEventPropertyOptions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CopyEventPropertyOptions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CopyOptions value
     * @uses \patest\EnumType\CopyEventPropertyOptions::valueIsValid()
     * @uses \patest\EnumType\CopyEventPropertyOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $copyOptions
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setCopyOptions(array $copyOptions = array())
    {
        // validation for constraint: list
        if ('' !== ($copyOptionsArrayErrorMessage = self::validateCopyOptionsForArrayConstraintsFromSetCopyOptions($copyOptions))) {
            throw new \InvalidArgumentException($copyOptionsArrayErrorMessage, __LINE__);
        }
        $this->CopyOptions = is_array($copyOptions) ? implode(' ', $copyOptions) : null;
        return $this;
    }
    /**
     * Get CopyRangeFrom value
     * @return string|null
     */
    public function getCopyRangeFrom()
    {
        return $this->CopyRangeFrom;
    }
    /**
     * Set CopyRangeFrom value
     * @param string $copyRangeFrom
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setCopyRangeFrom($copyRangeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeFrom) && !is_string($copyRangeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeFrom, true), gettype($copyRangeFrom)), __LINE__);
        }
        $this->CopyRangeFrom = $copyRangeFrom;
        return $this;
    }
    /**
     * Get CopyRangeTo value
     * @return string|null
     */
    public function getCopyRangeTo()
    {
        return $this->CopyRangeTo;
    }
    /**
     * Set CopyRangeTo value
     * @param string $copyRangeTo
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setCopyRangeTo($copyRangeTo = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeTo) && !is_string($copyRangeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeTo, true), gettype($copyRangeTo)), __LINE__);
        }
        $this->CopyRangeTo = $copyRangeTo;
        return $this;
    }
    /**
     * Get ExcludeDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDayOfWeek|null
     */
    public function getExcludeDays()
    {
        return isset($this->ExcludeDays) ? $this->ExcludeDays : null;
    }
    /**
     * Set ExcludeDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDayOfWeek $excludeDays
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setExcludeDays(\patest\ArrayType\ArrayOfDayOfWeek $excludeDays = null)
    {
        if (is_null($excludeDays) || (is_array($excludeDays) && empty($excludeDays))) {
            unset($this->ExcludeDays);
        } else {
            $this->ExcludeDays = $excludeDays;
        }
        return $this;
    }
    /**
     * Get ExcludeSpecificDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getExcludeSpecificDates()
    {
        return isset($this->ExcludeSpecificDates) ? $this->ExcludeSpecificDates : null;
    }
    /**
     * Set ExcludeSpecificDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $excludeSpecificDates
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setExcludeSpecificDates(\patest\ArrayType\ArrayOfdateTime $excludeSpecificDates = null)
    {
        if (is_null($excludeSpecificDates) || (is_array($excludeSpecificDates) && empty($excludeSpecificDates))) {
            unset($this->ExcludeSpecificDates);
        } else {
            $this->ExcludeSpecificDates = $excludeSpecificDates;
        }
        return $this;
    }
    /**
     * Get SourceEventId value
     * @return string|null
     */
    public function getSourceEventId()
    {
        return $this->SourceEventId;
    }
    /**
     * Set SourceEventId value
     * @param string $sourceEventId
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setSourceEventId($sourceEventId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEventId) && !is_string($sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEventId, true), gettype($sourceEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceEventId, true)), __LINE__);
        }
        $this->SourceEventId = $sourceEventId;
        return $this;
    }
    /**
     * Get TargetShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetShowId()
    {
        return isset($this->TargetShowId) ? $this->TargetShowId : null;
    }
    /**
     * Set TargetShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetShowId
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setTargetShowId($targetShowId = null)
    {
        // validation for constraint: string
        if (!is_null($targetShowId) && !is_string($targetShowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetShowId, true), gettype($targetShowId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetShowId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetShowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetShowId, true)), __LINE__);
        }
        if (is_null($targetShowId) || (is_array($targetShowId) && empty($targetShowId))) {
            unset($this->TargetShowId);
        } else {
            $this->TargetShowId = $targetShowId;
        }
        return $this;
    }
    /**
     * Get IsMergeSourceAndTargetValues value
     * @return bool|null
     */
    public function getIsMergeSourceAndTargetValues()
    {
        return $this->IsMergeSourceAndTargetValues;
    }
    /**
     * Set IsMergeSourceAndTargetValues value
     * @param bool $isMergeSourceAndTargetValues
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setIsMergeSourceAndTargetValues($isMergeSourceAndTargetValues = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMergeSourceAndTargetValues) && !is_bool($isMergeSourceAndTargetValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMergeSourceAndTargetValues, true), gettype($isMergeSourceAndTargetValues)), __LINE__);
        }
        $this->IsMergeSourceAndTargetValues = $isMergeSourceAndTargetValues;
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\CopyEventProperties_Request
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
}
