<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Context StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Context
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * The ForeignSessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignSessionId;
    /**
     * The TargetTenant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetTenant;
    /**
     * Constructor method for Context
     * @uses Context::setContextId()
     * @uses Context::setForeignSessionId()
     * @uses Context::setTargetTenant()
     * @param string $contextId
     * @param string $foreignSessionId
     * @param string $targetTenant
     */
    public function __construct($contextId = null, $foreignSessionId = null, $targetTenant = null)
    {
        $this
            ->setContextId($contextId)
            ->setForeignSessionId($foreignSessionId)
            ->setTargetTenant($targetTenant);
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\Context
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
    /**
     * Get ForeignSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignSessionId()
    {
        return isset($this->ForeignSessionId) ? $this->ForeignSessionId : null;
    }
    /**
     * Set ForeignSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignSessionId
     * @return \patest\StructType\Context
     */
    public function setForeignSessionId($foreignSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($foreignSessionId) && !is_string($foreignSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignSessionId, true), gettype($foreignSessionId)), __LINE__);
        }
        if (is_null($foreignSessionId) || (is_array($foreignSessionId) && empty($foreignSessionId))) {
            unset($this->ForeignSessionId);
        } else {
            $this->ForeignSessionId = $foreignSessionId;
        }
        return $this;
    }
    /**
     * Get TargetTenant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetTenant()
    {
        return isset($this->TargetTenant) ? $this->TargetTenant : null;
    }
    /**
     * Set TargetTenant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetTenant
     * @return \patest\StructType\Context
     */
    public function setTargetTenant($targetTenant = null)
    {
        // validation for constraint: string
        if (!is_null($targetTenant) && !is_string($targetTenant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetTenant, true), gettype($targetTenant)), __LINE__);
        }
        if (is_null($targetTenant) || (is_array($targetTenant) && empty($targetTenant))) {
            unset($this->TargetTenant);
        } else {
            $this->TargetTenant = $targetTenant;
        }
        return $this;
    }
}
