<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectWithOTP-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConnectWithOTP-Request
 * @subpackage Structs
 */
class ConnectWithOTP_Request extends ExtensibleDataContract
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CultureName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointIdentifier;
    /**
     * The TenantCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TenantCompanyId;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The WebLinkUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebLinkUri;
    /**
     * Constructor method for ConnectWithOTP-Request
     * @uses ConnectWithOTP_Request::setApplication()
     * @uses ConnectWithOTP_Request::setApplicationChannel()
     * @uses ConnectWithOTP_Request::setCode()
     * @uses ConnectWithOTP_Request::setCultureName()
     * @uses ConnectWithOTP_Request::setSalePointId()
     * @uses ConnectWithOTP_Request::setSalePointIdentifier()
     * @uses ConnectWithOTP_Request::setTenantCompanyId()
     * @uses ConnectWithOTP_Request::setTillId()
     * @uses ConnectWithOTP_Request::setUserId()
     * @uses ConnectWithOTP_Request::setWebLinkUri()
     * @param string $application
     * @param string $applicationChannel
     * @param string $code
     * @param string $cultureName
     * @param string $salePointId
     * @param string $salePointIdentifier
     * @param int $tenantCompanyId
     * @param string $tillId
     * @param string $userId
     * @param string $webLinkUri
     */
    public function __construct($application = null, $applicationChannel = null, $code = null, $cultureName = null, $salePointId = null, $salePointIdentifier = null, $tenantCompanyId = null, $tillId = null, $userId = null, $webLinkUri = null)
    {
        $this
            ->setApplication($application)
            ->setApplicationChannel($applicationChannel)
            ->setCode($code)
            ->setCultureName($cultureName)
            ->setSalePointId($salePointId)
            ->setSalePointIdentifier($salePointIdentifier)
            ->setTenantCompanyId($tenantCompanyId)
            ->setTillId($tillId)
            ->setUserId($userId)
            ->setWebLinkUri($webLinkUri);
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get SalePointIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointIdentifier()
    {
        return isset($this->SalePointIdentifier) ? $this->SalePointIdentifier : null;
    }
    /**
     * Set SalePointIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointIdentifier
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setSalePointIdentifier($salePointIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($salePointIdentifier) && !is_string($salePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointIdentifier, true), gettype($salePointIdentifier)), __LINE__);
        }
        if (is_null($salePointIdentifier) || (is_array($salePointIdentifier) && empty($salePointIdentifier))) {
            unset($this->SalePointIdentifier);
        } else {
            $this->SalePointIdentifier = $salePointIdentifier;
        }
        return $this;
    }
    /**
     * Get TenantCompanyId value
     * @return int|null
     */
    public function getTenantCompanyId()
    {
        return $this->TenantCompanyId;
    }
    /**
     * Set TenantCompanyId value
     * @param int $tenantCompanyId
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setTenantCompanyId($tenantCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($tenantCompanyId) && !(is_int($tenantCompanyId) || ctype_digit($tenantCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tenantCompanyId, true), gettype($tenantCompanyId)), __LINE__);
        }
        $this->TenantCompanyId = $tenantCompanyId;
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get WebLinkUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebLinkUri()
    {
        return isset($this->WebLinkUri) ? $this->WebLinkUri : null;
    }
    /**
     * Set WebLinkUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webLinkUri
     * @return \patest\StructType\ConnectWithOTP_Request
     */
    public function setWebLinkUri($webLinkUri = null)
    {
        // validation for constraint: string
        if (!is_null($webLinkUri) && !is_string($webLinkUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webLinkUri, true), gettype($webLinkUri)), __LINE__);
        }
        if (is_null($webLinkUri) || (is_array($webLinkUri) && empty($webLinkUri))) {
            unset($this->WebLinkUri);
        } else {
            $this->WebLinkUri = $webLinkUri;
        }
        return $this;
    }
}
