<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfirmDataReceivedRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConfirmDataReceivedRequest
 * @subpackage Structs
 */
class ConfirmDataReceivedRequest extends AbstractStructBase
{
    /**
     * The DataFeedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DataFeedId;
    /**
     * The TransmissionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransmissionId;
    /**
     * Constructor method for ConfirmDataReceivedRequest
     * @uses ConfirmDataReceivedRequest::setDataFeedId()
     * @uses ConfirmDataReceivedRequest::setTransmissionId()
     * @param string $dataFeedId
     * @param string $transmissionId
     */
    public function __construct($dataFeedId = null, $transmissionId = null)
    {
        $this
            ->setDataFeedId($dataFeedId)
            ->setTransmissionId($transmissionId);
    }
    /**
     * Get DataFeedId value
     * @return string|null
     */
    public function getDataFeedId()
    {
        return $this->DataFeedId;
    }
    /**
     * Set DataFeedId value
     * @param string $dataFeedId
     * @return \patest\StructType\ConfirmDataReceivedRequest
     */
    public function setDataFeedId($dataFeedId = null)
    {
        // validation for constraint: string
        if (!is_null($dataFeedId) && !is_string($dataFeedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFeedId, true), gettype($dataFeedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dataFeedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dataFeedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dataFeedId, true)), __LINE__);
        }
        $this->DataFeedId = $dataFeedId;
        return $this;
    }
    /**
     * Get TransmissionId value
     * @return string|null
     */
    public function getTransmissionId()
    {
        return $this->TransmissionId;
    }
    /**
     * Set TransmissionId value
     * @param string $transmissionId
     * @return \patest\StructType\ConfirmDataReceivedRequest
     */
    public function setTransmissionId($transmissionId = null)
    {
        // validation for constraint: string
        if (!is_null($transmissionId) && !is_string($transmissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmissionId, true), gettype($transmissionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transmissionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transmissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transmissionId, true)), __LINE__);
        }
        $this->TransmissionId = $transmissionId;
        return $this;
    }
}
