<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectAndPrintTickets-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CollectAndPrintTickets-Response
 * @subpackage Structs
 */
class CollectAndPrintTickets_Response extends ExtensibleDataContract
{
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketPrintStatus
     */
    public $Tickets;
    /**
     * The TicketsToTransactionGuidMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidguid
     */
    public $TicketsToTransactionGuidMap;
    /**
     * Constructor method for CollectAndPrintTickets-Response
     * @uses CollectAndPrintTickets_Response::setTickets()
     * @uses CollectAndPrintTickets_Response::setTicketsToTransactionGuidMap()
     * @param \patest\ArrayType\ArrayOfTicketPrintStatus $tickets
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $ticketsToTransactionGuidMap
     */
    public function __construct(\patest\ArrayType\ArrayOfTicketPrintStatus $tickets = null, \patest\ArrayType\ArrayOfKeyValueOfguidguid $ticketsToTransactionGuidMap = null)
    {
        $this
            ->setTickets($tickets)
            ->setTicketsToTransactionGuidMap($ticketsToTransactionGuidMap);
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketPrintStatus|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketPrintStatus $tickets
     * @return \patest\StructType\CollectAndPrintTickets_Response
     */
    public function setTickets(\patest\ArrayType\ArrayOfTicketPrintStatus $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TicketsToTransactionGuidMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidguid|null
     */
    public function getTicketsToTransactionGuidMap()
    {
        return isset($this->TicketsToTransactionGuidMap) ? $this->TicketsToTransactionGuidMap : null;
    }
    /**
     * Set TicketsToTransactionGuidMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidguid $ticketsToTransactionGuidMap
     * @return \patest\StructType\CollectAndPrintTickets_Response
     */
    public function setTicketsToTransactionGuidMap(\patest\ArrayType\ArrayOfKeyValueOfguidguid $ticketsToTransactionGuidMap = null)
    {
        if (is_null($ticketsToTransactionGuidMap) || (is_array($ticketsToTransactionGuidMap) && empty($ticketsToTransactionGuidMap))) {
            unset($this->TicketsToTransactionGuidMap);
        } else {
            $this->TicketsToTransactionGuidMap = $ticketsToTransactionGuidMap;
        }
        return $this;
    }
}
