<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientRelationship StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientRelationship
 * @subpackage Structs
 */
class ClientRelationship extends AbstractStructBase
{
    /**
     * The IsPendingConfirmation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPendingConfirmation;
    /**
     * The IsStrong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsStrong;
    /**
     * The RelatedClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedClientCrmId;
    /**
     * The RelatedClientFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedClientFullName;
    /**
     * The RelatedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedClientId;
    /**
     * Constructor method for ClientRelationship
     * @uses ClientRelationship::setIsPendingConfirmation()
     * @uses ClientRelationship::setIsStrong()
     * @uses ClientRelationship::setRelatedClientCrmId()
     * @uses ClientRelationship::setRelatedClientFullName()
     * @uses ClientRelationship::setRelatedClientId()
     * @param bool $isPendingConfirmation
     * @param bool $isStrong
     * @param string $relatedClientCrmId
     * @param string $relatedClientFullName
     * @param string $relatedClientId
     */
    public function __construct($isPendingConfirmation = null, $isStrong = null, $relatedClientCrmId = null, $relatedClientFullName = null, $relatedClientId = null)
    {
        $this
            ->setIsPendingConfirmation($isPendingConfirmation)
            ->setIsStrong($isStrong)
            ->setRelatedClientCrmId($relatedClientCrmId)
            ->setRelatedClientFullName($relatedClientFullName)
            ->setRelatedClientId($relatedClientId);
    }
    /**
     * Get IsPendingConfirmation value
     * @return bool|null
     */
    public function getIsPendingConfirmation()
    {
        return $this->IsPendingConfirmation;
    }
    /**
     * Set IsPendingConfirmation value
     * @param bool $isPendingConfirmation
     * @return \patest\StructType\ClientRelationship
     */
    public function setIsPendingConfirmation($isPendingConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPendingConfirmation) && !is_bool($isPendingConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPendingConfirmation, true), gettype($isPendingConfirmation)), __LINE__);
        }
        $this->IsPendingConfirmation = $isPendingConfirmation;
        return $this;
    }
    /**
     * Get IsStrong value
     * @return bool|null
     */
    public function getIsStrong()
    {
        return $this->IsStrong;
    }
    /**
     * Set IsStrong value
     * @param bool $isStrong
     * @return \patest\StructType\ClientRelationship
     */
    public function setIsStrong($isStrong = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStrong) && !is_bool($isStrong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStrong, true), gettype($isStrong)), __LINE__);
        }
        $this->IsStrong = $isStrong;
        return $this;
    }
    /**
     * Get RelatedClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedClientCrmId()
    {
        return isset($this->RelatedClientCrmId) ? $this->RelatedClientCrmId : null;
    }
    /**
     * Set RelatedClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedClientCrmId
     * @return \patest\StructType\ClientRelationship
     */
    public function setRelatedClientCrmId($relatedClientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedClientCrmId) && !is_string($relatedClientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedClientCrmId, true), gettype($relatedClientCrmId)), __LINE__);
        }
        if (is_null($relatedClientCrmId) || (is_array($relatedClientCrmId) && empty($relatedClientCrmId))) {
            unset($this->RelatedClientCrmId);
        } else {
            $this->RelatedClientCrmId = $relatedClientCrmId;
        }
        return $this;
    }
    /**
     * Get RelatedClientFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedClientFullName()
    {
        return isset($this->RelatedClientFullName) ? $this->RelatedClientFullName : null;
    }
    /**
     * Set RelatedClientFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedClientFullName
     * @return \patest\StructType\ClientRelationship
     */
    public function setRelatedClientFullName($relatedClientFullName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedClientFullName) && !is_string($relatedClientFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedClientFullName, true), gettype($relatedClientFullName)), __LINE__);
        }
        if (is_null($relatedClientFullName) || (is_array($relatedClientFullName) && empty($relatedClientFullName))) {
            unset($this->RelatedClientFullName);
        } else {
            $this->RelatedClientFullName = $relatedClientFullName;
        }
        return $this;
    }
    /**
     * Get RelatedClientId value
     * @return string|null
     */
    public function getRelatedClientId()
    {
        return $this->RelatedClientId;
    }
    /**
     * Set RelatedClientId value
     * @param string $relatedClientId
     * @return \patest\StructType\ClientRelationship
     */
    public function setRelatedClientId($relatedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedClientId) && !is_string($relatedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedClientId, true), gettype($relatedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedClientId, true)), __LINE__);
        }
        $this->RelatedClientId = $relatedClientId;
        return $this;
    }
}
