<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearingOperationFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClearingOperationFault
 * @subpackage Structs
 */
class ClearingOperationFault extends BasicFault
{
    /**
     * The FaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultDescription;
    /**
     * The FaultPaymentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FaultPaymentId;
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * Constructor method for ClearingOperationFault
     * @uses ClearingOperationFault::setFaultCode()
     * @uses ClearingOperationFault::setFaultDescription()
     * @uses ClearingOperationFault::setFaultPaymentId()
     * @uses ClearingOperationFault::setPaymentSessionId()
     * @param string $faultCode
     * @param string $faultDescription
     * @param string $faultPaymentId
     * @param string $paymentSessionId
     */
    public function __construct($faultCode = null, $faultDescription = null, $faultPaymentId = null, $paymentSessionId = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultDescription($faultDescription)
            ->setFaultPaymentId($faultPaymentId)
            ->setPaymentSessionId($paymentSessionId);
    }
    /**
     * Get FaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultCode()
    {
        return isset($this->FaultCode) ? $this->FaultCode : null;
    }
    /**
     * Set FaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultCode
     * @return \patest\StructType\ClearingOperationFault
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        if (is_null($faultCode) || (is_array($faultCode) && empty($faultCode))) {
            unset($this->FaultCode);
        } else {
            $this->FaultCode = $faultCode;
        }
        return $this;
    }
    /**
     * Get FaultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultDescription()
    {
        return isset($this->FaultDescription) ? $this->FaultDescription : null;
    }
    /**
     * Set FaultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultDescription
     * @return \patest\StructType\ClearingOperationFault
     */
    public function setFaultDescription($faultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($faultDescription) && !is_string($faultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultDescription, true), gettype($faultDescription)), __LINE__);
        }
        if (is_null($faultDescription) || (is_array($faultDescription) && empty($faultDescription))) {
            unset($this->FaultDescription);
        } else {
            $this->FaultDescription = $faultDescription;
        }
        return $this;
    }
    /**
     * Get FaultPaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultPaymentId()
    {
        return isset($this->FaultPaymentId) ? $this->FaultPaymentId : null;
    }
    /**
     * Set FaultPaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultPaymentId
     * @return \patest\StructType\ClearingOperationFault
     */
    public function setFaultPaymentId($faultPaymentId = null)
    {
        // validation for constraint: string
        if (!is_null($faultPaymentId) && !is_string($faultPaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultPaymentId, true), gettype($faultPaymentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($faultPaymentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $faultPaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($faultPaymentId, true)), __LINE__);
        }
        if (is_null($faultPaymentId) || (is_array($faultPaymentId) && empty($faultPaymentId))) {
            unset($this->FaultPaymentId);
        } else {
            $this->FaultPaymentId = $faultPaymentId;
        }
        return $this;
    }
    /**
     * Get PaymentSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return isset($this->PaymentSessionId) ? $this->PaymentSessionId : null;
    }
    /**
     * Set PaymentSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSessionId
     * @return \patest\StructType\ClearingOperationFault
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        if (is_null($paymentSessionId) || (is_array($paymentSessionId) && empty($paymentSessionId))) {
            unset($this->PaymentSessionId);
        } else {
            $this->PaymentSessionId = $paymentSessionId;
        }
        return $this;
    }
}
