<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckTicketsForHolderResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckTicketsForHolderResponse
 * @subpackage Structs
 */
class CheckTicketsForHolderResponse extends AbstractStructBase
{
    /**
     * The HasHolders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasHolders;
    /**
     * The TicketIdsWithHolders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValuePairOfguidstring
     */
    public $TicketIdsWithHolders;
    /**
     * Constructor method for CheckTicketsForHolderResponse
     * @uses CheckTicketsForHolderResponse::setHasHolders()
     * @uses CheckTicketsForHolderResponse::setTicketIdsWithHolders()
     * @param bool $hasHolders
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $ticketIdsWithHolders
     */
    public function __construct($hasHolders = null, \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $ticketIdsWithHolders = null)
    {
        $this
            ->setHasHolders($hasHolders)
            ->setTicketIdsWithHolders($ticketIdsWithHolders);
    }
    /**
     * Get HasHolders value
     * @return bool|null
     */
    public function getHasHolders()
    {
        return $this->HasHolders;
    }
    /**
     * Set HasHolders value
     * @param bool $hasHolders
     * @return \patest\StructType\CheckTicketsForHolderResponse
     */
    public function setHasHolders($hasHolders = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHolders) && !is_bool($hasHolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHolders, true), gettype($hasHolders)), __LINE__);
        }
        $this->HasHolders = $hasHolders;
        return $this;
    }
    /**
     * Get TicketIdsWithHolders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValuePairOfguidstring|null
     */
    public function getTicketIdsWithHolders()
    {
        return isset($this->TicketIdsWithHolders) ? $this->TicketIdsWithHolders : null;
    }
    /**
     * Set TicketIdsWithHolders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $ticketIdsWithHolders
     * @return \patest\StructType\CheckTicketsForHolderResponse
     */
    public function setTicketIdsWithHolders(\patest\ArrayType\ArrayOfKeyValuePairOfguidstring $ticketIdsWithHolders = null)
    {
        if (is_null($ticketIdsWithHolders) || (is_array($ticketIdsWithHolders) && empty($ticketIdsWithHolders))) {
            unset($this->TicketIdsWithHolders);
        } else {
            $this->TicketIdsWithHolders = $ticketIdsWithHolders;
        }
        return $this;
    }
}
