<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckSGOServicesStatusResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckSGOServicesStatusResponse
 * @subpackage Structs
 */
class CheckSGOServicesStatusResponse extends AbstractStructBase
{
    /**
     * The IsServiceActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsServiceActive;
    /**
     * The ServiceStatusMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceStatusMessage;
    /**
     * Constructor method for CheckSGOServicesStatusResponse
     * @uses CheckSGOServicesStatusResponse::setIsServiceActive()
     * @uses CheckSGOServicesStatusResponse::setServiceStatusMessage()
     * @param bool $isServiceActive
     * @param string $serviceStatusMessage
     */
    public function __construct($isServiceActive = null, $serviceStatusMessage = null)
    {
        $this
            ->setIsServiceActive($isServiceActive)
            ->setServiceStatusMessage($serviceStatusMessage);
    }
    /**
     * Get IsServiceActive value
     * @return bool|null
     */
    public function getIsServiceActive()
    {
        return $this->IsServiceActive;
    }
    /**
     * Set IsServiceActive value
     * @param bool $isServiceActive
     * @return \patest\StructType\CheckSGOServicesStatusResponse
     */
    public function setIsServiceActive($isServiceActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isServiceActive) && !is_bool($isServiceActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isServiceActive, true), gettype($isServiceActive)), __LINE__);
        }
        $this->IsServiceActive = $isServiceActive;
        return $this;
    }
    /**
     * Get ServiceStatusMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceStatusMessage()
    {
        return isset($this->ServiceStatusMessage) ? $this->ServiceStatusMessage : null;
    }
    /**
     * Set ServiceStatusMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceStatusMessage
     * @return \patest\StructType\CheckSGOServicesStatusResponse
     */
    public function setServiceStatusMessage($serviceStatusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStatusMessage) && !is_string($serviceStatusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceStatusMessage, true), gettype($serviceStatusMessage)), __LINE__);
        }
        if (is_null($serviceStatusMessage) || (is_array($serviceStatusMessage) && empty($serviceStatusMessage))) {
            unset($this->ServiceStatusMessage);
        } else {
            $this->ServiceStatusMessage = $serviceStatusMessage;
        }
        return $this;
    }
}
