<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckClientDuplicationsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckClientDuplicationsResponse
 * @subpackage Structs
 */
class CheckClientDuplicationsResponse extends AbstractStructBase
{
    /**
     * The DuplicatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCrm_Client
     */
    public $DuplicatedClients;
    /**
     * The IsExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExists;
    /**
     * The RulesCausingDuplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCrm_DuplicationCheckRule
     */
    public $RulesCausingDuplications;
    /**
     * Constructor method for CheckClientDuplicationsResponse
     * @uses CheckClientDuplicationsResponse::setDuplicatedClients()
     * @uses CheckClientDuplicationsResponse::setIsExists()
     * @uses CheckClientDuplicationsResponse::setRulesCausingDuplications()
     * @param \patest\ArrayType\ArrayOfCrm_Client $duplicatedClients
     * @param bool $isExists
     * @param \patest\ArrayType\ArrayOfCrm_DuplicationCheckRule $rulesCausingDuplications
     */
    public function __construct(\patest\ArrayType\ArrayOfCrm_Client $duplicatedClients = null, $isExists = null, \patest\ArrayType\ArrayOfCrm_DuplicationCheckRule $rulesCausingDuplications = null)
    {
        $this
            ->setDuplicatedClients($duplicatedClients)
            ->setIsExists($isExists)
            ->setRulesCausingDuplications($rulesCausingDuplications);
    }
    /**
     * Get DuplicatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCrm_Client|null
     */
    public function getDuplicatedClients()
    {
        return isset($this->DuplicatedClients) ? $this->DuplicatedClients : null;
    }
    /**
     * Set DuplicatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCrm_Client $duplicatedClients
     * @return \patest\StructType\CheckClientDuplicationsResponse
     */
    public function setDuplicatedClients(\patest\ArrayType\ArrayOfCrm_Client $duplicatedClients = null)
    {
        if (is_null($duplicatedClients) || (is_array($duplicatedClients) && empty($duplicatedClients))) {
            unset($this->DuplicatedClients);
        } else {
            $this->DuplicatedClients = $duplicatedClients;
        }
        return $this;
    }
    /**
     * Get IsExists value
     * @return bool|null
     */
    public function getIsExists()
    {
        return $this->IsExists;
    }
    /**
     * Set IsExists value
     * @param bool $isExists
     * @return \patest\StructType\CheckClientDuplicationsResponse
     */
    public function setIsExists($isExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExists) && !is_bool($isExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExists, true), gettype($isExists)), __LINE__);
        }
        $this->IsExists = $isExists;
        return $this;
    }
    /**
     * Get RulesCausingDuplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCrm_DuplicationCheckRule|null
     */
    public function getRulesCausingDuplications()
    {
        return isset($this->RulesCausingDuplications) ? $this->RulesCausingDuplications : null;
    }
    /**
     * Set RulesCausingDuplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCrm_DuplicationCheckRule $rulesCausingDuplications
     * @return \patest\StructType\CheckClientDuplicationsResponse
     */
    public function setRulesCausingDuplications(\patest\ArrayType\ArrayOfCrm_DuplicationCheckRule $rulesCausingDuplications = null)
    {
        if (is_null($rulesCausingDuplications) || (is_array($rulesCausingDuplications) && empty($rulesCausingDuplications))) {
            unset($this->RulesCausingDuplications);
        } else {
            $this->RulesCausingDuplications = $rulesCausingDuplications;
        }
        return $this;
    }
}
