<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckClientDuplicationsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckClientDuplicationsRequest
 * @subpackage Structs
 */
class CheckClientDuplicationsRequest extends AbstractStructBase
{
    /**
     * The CheckByWeakDuplicationRuleSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CheckByWeakDuplicationRuleSet;
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Client
     */
    public $Client;
    /**
     * The IsEditing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEditing;
    /**
     * Constructor method for CheckClientDuplicationsRequest
     * @uses CheckClientDuplicationsRequest::setCheckByWeakDuplicationRuleSet()
     * @uses CheckClientDuplicationsRequest::setClient()
     * @uses CheckClientDuplicationsRequest::setIsEditing()
     * @param bool $checkByWeakDuplicationRuleSet
     * @param \patest\StructType\Crm_Client $client
     * @param bool $isEditing
     */
    public function __construct($checkByWeakDuplicationRuleSet = null, \patest\StructType\Crm_Client $client = null, $isEditing = null)
    {
        $this
            ->setCheckByWeakDuplicationRuleSet($checkByWeakDuplicationRuleSet)
            ->setClient($client)
            ->setIsEditing($isEditing);
    }
    /**
     * Get CheckByWeakDuplicationRuleSet value
     * @return bool|null
     */
    public function getCheckByWeakDuplicationRuleSet()
    {
        return $this->CheckByWeakDuplicationRuleSet;
    }
    /**
     * Set CheckByWeakDuplicationRuleSet value
     * @param bool $checkByWeakDuplicationRuleSet
     * @return \patest\StructType\CheckClientDuplicationsRequest
     */
    public function setCheckByWeakDuplicationRuleSet($checkByWeakDuplicationRuleSet = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkByWeakDuplicationRuleSet) && !is_bool($checkByWeakDuplicationRuleSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkByWeakDuplicationRuleSet, true), gettype($checkByWeakDuplicationRuleSet)), __LINE__);
        }
        $this->CheckByWeakDuplicationRuleSet = $checkByWeakDuplicationRuleSet;
        return $this;
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Client|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Client $client
     * @return \patest\StructType\CheckClientDuplicationsRequest
     */
    public function setClient(\patest\StructType\Crm_Client $client = null)
    {
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Get IsEditing value
     * @return bool|null
     */
    public function getIsEditing()
    {
        return $this->IsEditing;
    }
    /**
     * Set IsEditing value
     * @param bool $isEditing
     * @return \patest\StructType\CheckClientDuplicationsRequest
     */
    public function setIsEditing($isEditing = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditing) && !is_bool($isEditing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditing, true), gettype($isEditing)), __LINE__);
        }
        $this->IsEditing = $isEditing;
        return $this;
    }
}
