<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapacityCounters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CapacityCounters
 * @subpackage Structs
 */
class CapacityCounters extends AbstractStructBase
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Available;
    /**
     * The Occupied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Occupied;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Total;
    /**
     * The ConsumedQuantityByRestriction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea
     */
    public $ConsumedQuantityByRestriction;
    /**
     * The AvailableBulk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AvailableBulk;
    /**
     * The IsSoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSoldOut;
    /**
     * The ReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservedCount;
    /**
     * The SoldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SoldCount;
    /**
     * The TemporarilyReservedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TemporarilyReservedCount;
    /**
     * The FreeCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FreeCount;
    /**
     * The HeldForSubscribersCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HeldForSubscribersCount;
    /**
     * The LockedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LockedCount;
    /**
     * The OccupiedByPeersCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OccupiedByPeersCount;
    /**
     * The ForResaleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ForResaleCount;
    /**
     * The PendingResaleMDCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PendingResaleMDCount;
    /**
     * The PendingTransfersMDCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PendingTransfersMDCount;
    /**
     * The ResoldMDCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResoldMDCount;
    /**
     * The TransferredMDCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransferredMDCount;
    /**
     * Constructor method for CapacityCounters
     * @uses CapacityCounters::setAvailable()
     * @uses CapacityCounters::setOccupied()
     * @uses CapacityCounters::setTotal()
     * @uses CapacityCounters::setConsumedQuantityByRestriction()
     * @uses CapacityCounters::setAvailableBulk()
     * @uses CapacityCounters::setIsSoldOut()
     * @uses CapacityCounters::setReservedCount()
     * @uses CapacityCounters::setSoldCount()
     * @uses CapacityCounters::setTemporarilyReservedCount()
     * @uses CapacityCounters::setFreeCount()
     * @uses CapacityCounters::setHeldForSubscribersCount()
     * @uses CapacityCounters::setLockedCount()
     * @uses CapacityCounters::setOccupiedByPeersCount()
     * @uses CapacityCounters::setForResaleCount()
     * @uses CapacityCounters::setPendingResaleMDCount()
     * @uses CapacityCounters::setPendingTransfersMDCount()
     * @uses CapacityCounters::setResoldMDCount()
     * @uses CapacityCounters::setTransferredMDCount()
     * @param int $available
     * @param int $occupied
     * @param int $total
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea $consumedQuantityByRestriction
     * @param int $availableBulk
     * @param bool $isSoldOut
     * @param int $reservedCount
     * @param int $soldCount
     * @param int $temporarilyReservedCount
     * @param int $freeCount
     * @param int $heldForSubscribersCount
     * @param int $lockedCount
     * @param int $occupiedByPeersCount
     * @param int $forResaleCount
     * @param int $pendingResaleMDCount
     * @param int $pendingTransfersMDCount
     * @param int $resoldMDCount
     * @param int $transferredMDCount
     */
    public function __construct($available = null, $occupied = null, $total = null, \patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea $consumedQuantityByRestriction = null, $availableBulk = null, $isSoldOut = null, $reservedCount = null, $soldCount = null, $temporarilyReservedCount = null, $freeCount = null, $heldForSubscribersCount = null, $lockedCount = null, $occupiedByPeersCount = null, $forResaleCount = null, $pendingResaleMDCount = null, $pendingTransfersMDCount = null, $resoldMDCount = null, $transferredMDCount = null)
    {
        $this
            ->setAvailable($available)
            ->setOccupied($occupied)
            ->setTotal($total)
            ->setConsumedQuantityByRestriction($consumedQuantityByRestriction)
            ->setAvailableBulk($availableBulk)
            ->setIsSoldOut($isSoldOut)
            ->setReservedCount($reservedCount)
            ->setSoldCount($soldCount)
            ->setTemporarilyReservedCount($temporarilyReservedCount)
            ->setFreeCount($freeCount)
            ->setHeldForSubscribersCount($heldForSubscribersCount)
            ->setLockedCount($lockedCount)
            ->setOccupiedByPeersCount($occupiedByPeersCount)
            ->setForResaleCount($forResaleCount)
            ->setPendingResaleMDCount($pendingResaleMDCount)
            ->setPendingTransfersMDCount($pendingTransfersMDCount)
            ->setResoldMDCount($resoldMDCount)
            ->setTransferredMDCount($transferredMDCount);
    }
    /**
     * Get Available value
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param int $available
     * @return \patest\StructType\CapacityCounters
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: int
        if (!is_null($available) && !(is_int($available) || ctype_digit($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get Occupied value
     * @return int|null
     */
    public function getOccupied()
    {
        return $this->Occupied;
    }
    /**
     * Set Occupied value
     * @param int $occupied
     * @return \patest\StructType\CapacityCounters
     */
    public function setOccupied($occupied = null)
    {
        // validation for constraint: int
        if (!is_null($occupied) && !(is_int($occupied) || ctype_digit($occupied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupied, true), gettype($occupied)), __LINE__);
        }
        $this->Occupied = $occupied;
        return $this;
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \patest\StructType\CapacityCounters
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get ConsumedQuantityByRestriction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea|null
     */
    public function getConsumedQuantityByRestriction()
    {
        return isset($this->ConsumedQuantityByRestriction) ? $this->ConsumedQuantityByRestriction : null;
    }
    /**
     * Set ConsumedQuantityByRestriction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea $consumedQuantityByRestriction
     * @return \patest\StructType\CapacityCounters
     */
    public function setConsumedQuantityByRestriction(\patest\ArrayType\ArrayOfKeyValueOfguidRestrctionConsumptionItemhpjoQDea $consumedQuantityByRestriction = null)
    {
        if (is_null($consumedQuantityByRestriction) || (is_array($consumedQuantityByRestriction) && empty($consumedQuantityByRestriction))) {
            unset($this->ConsumedQuantityByRestriction);
        } else {
            $this->ConsumedQuantityByRestriction = $consumedQuantityByRestriction;
        }
        return $this;
    }
    /**
     * Get AvailableBulk value
     * @return int|null
     */
    public function getAvailableBulk()
    {
        return $this->AvailableBulk;
    }
    /**
     * Set AvailableBulk value
     * @param int $availableBulk
     * @return \patest\StructType\CapacityCounters
     */
    public function setAvailableBulk($availableBulk = null)
    {
        // validation for constraint: int
        if (!is_null($availableBulk) && !(is_int($availableBulk) || ctype_digit($availableBulk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableBulk, true), gettype($availableBulk)), __LINE__);
        }
        $this->AvailableBulk = $availableBulk;
        return $this;
    }
    /**
     * Get IsSoldOut value
     * @return bool|null
     */
    public function getIsSoldOut()
    {
        return $this->IsSoldOut;
    }
    /**
     * Set IsSoldOut value
     * @param bool $isSoldOut
     * @return \patest\StructType\CapacityCounters
     */
    public function setIsSoldOut($isSoldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSoldOut) && !is_bool($isSoldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSoldOut, true), gettype($isSoldOut)), __LINE__);
        }
        $this->IsSoldOut = $isSoldOut;
        return $this;
    }
    /**
     * Get ReservedCount value
     * @return int|null
     */
    public function getReservedCount()
    {
        return $this->ReservedCount;
    }
    /**
     * Set ReservedCount value
     * @param int $reservedCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setReservedCount($reservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($reservedCount) && !(is_int($reservedCount) || ctype_digit($reservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedCount, true), gettype($reservedCount)), __LINE__);
        }
        $this->ReservedCount = $reservedCount;
        return $this;
    }
    /**
     * Get SoldCount value
     * @return int|null
     */
    public function getSoldCount()
    {
        return $this->SoldCount;
    }
    /**
     * Set SoldCount value
     * @param int $soldCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        $this->SoldCount = $soldCount;
        return $this;
    }
    /**
     * Get TemporarilyReservedCount value
     * @return int|null
     */
    public function getTemporarilyReservedCount()
    {
        return $this->TemporarilyReservedCount;
    }
    /**
     * Set TemporarilyReservedCount value
     * @param int $temporarilyReservedCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setTemporarilyReservedCount($temporarilyReservedCount = null)
    {
        // validation for constraint: int
        if (!is_null($temporarilyReservedCount) && !(is_int($temporarilyReservedCount) || ctype_digit($temporarilyReservedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temporarilyReservedCount, true), gettype($temporarilyReservedCount)), __LINE__);
        }
        $this->TemporarilyReservedCount = $temporarilyReservedCount;
        return $this;
    }
    /**
     * Get FreeCount value
     * @return int|null
     */
    public function getFreeCount()
    {
        return $this->FreeCount;
    }
    /**
     * Set FreeCount value
     * @param int $freeCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setFreeCount($freeCount = null)
    {
        // validation for constraint: int
        if (!is_null($freeCount) && !(is_int($freeCount) || ctype_digit($freeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freeCount, true), gettype($freeCount)), __LINE__);
        }
        $this->FreeCount = $freeCount;
        return $this;
    }
    /**
     * Get HeldForSubscribersCount value
     * @return int|null
     */
    public function getHeldForSubscribersCount()
    {
        return $this->HeldForSubscribersCount;
    }
    /**
     * Set HeldForSubscribersCount value
     * @param int $heldForSubscribersCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setHeldForSubscribersCount($heldForSubscribersCount = null)
    {
        // validation for constraint: int
        if (!is_null($heldForSubscribersCount) && !(is_int($heldForSubscribersCount) || ctype_digit($heldForSubscribersCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heldForSubscribersCount, true), gettype($heldForSubscribersCount)), __LINE__);
        }
        $this->HeldForSubscribersCount = $heldForSubscribersCount;
        return $this;
    }
    /**
     * Get LockedCount value
     * @return int|null
     */
    public function getLockedCount()
    {
        return $this->LockedCount;
    }
    /**
     * Set LockedCount value
     * @param int $lockedCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setLockedCount($lockedCount = null)
    {
        // validation for constraint: int
        if (!is_null($lockedCount) && !(is_int($lockedCount) || ctype_digit($lockedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lockedCount, true), gettype($lockedCount)), __LINE__);
        }
        $this->LockedCount = $lockedCount;
        return $this;
    }
    /**
     * Get OccupiedByPeersCount value
     * @return int|null
     */
    public function getOccupiedByPeersCount()
    {
        return $this->OccupiedByPeersCount;
    }
    /**
     * Set OccupiedByPeersCount value
     * @param int $occupiedByPeersCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setOccupiedByPeersCount($occupiedByPeersCount = null)
    {
        // validation for constraint: int
        if (!is_null($occupiedByPeersCount) && !(is_int($occupiedByPeersCount) || ctype_digit($occupiedByPeersCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupiedByPeersCount, true), gettype($occupiedByPeersCount)), __LINE__);
        }
        $this->OccupiedByPeersCount = $occupiedByPeersCount;
        return $this;
    }
    /**
     * Get ForResaleCount value
     * @return int|null
     */
    public function getForResaleCount()
    {
        return $this->ForResaleCount;
    }
    /**
     * Set ForResaleCount value
     * @param int $forResaleCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setForResaleCount($forResaleCount = null)
    {
        // validation for constraint: int
        if (!is_null($forResaleCount) && !(is_int($forResaleCount) || ctype_digit($forResaleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forResaleCount, true), gettype($forResaleCount)), __LINE__);
        }
        $this->ForResaleCount = $forResaleCount;
        return $this;
    }
    /**
     * Get PendingResaleMDCount value
     * @return int|null
     */
    public function getPendingResaleMDCount()
    {
        return $this->PendingResaleMDCount;
    }
    /**
     * Set PendingResaleMDCount value
     * @param int $pendingResaleMDCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setPendingResaleMDCount($pendingResaleMDCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingResaleMDCount) && !(is_int($pendingResaleMDCount) || ctype_digit($pendingResaleMDCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingResaleMDCount, true), gettype($pendingResaleMDCount)), __LINE__);
        }
        $this->PendingResaleMDCount = $pendingResaleMDCount;
        return $this;
    }
    /**
     * Get PendingTransfersMDCount value
     * @return int|null
     */
    public function getPendingTransfersMDCount()
    {
        return $this->PendingTransfersMDCount;
    }
    /**
     * Set PendingTransfersMDCount value
     * @param int $pendingTransfersMDCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setPendingTransfersMDCount($pendingTransfersMDCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingTransfersMDCount) && !(is_int($pendingTransfersMDCount) || ctype_digit($pendingTransfersMDCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingTransfersMDCount, true), gettype($pendingTransfersMDCount)), __LINE__);
        }
        $this->PendingTransfersMDCount = $pendingTransfersMDCount;
        return $this;
    }
    /**
     * Get ResoldMDCount value
     * @return int|null
     */
    public function getResoldMDCount()
    {
        return $this->ResoldMDCount;
    }
    /**
     * Set ResoldMDCount value
     * @param int $resoldMDCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setResoldMDCount($resoldMDCount = null)
    {
        // validation for constraint: int
        if (!is_null($resoldMDCount) && !(is_int($resoldMDCount) || ctype_digit($resoldMDCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resoldMDCount, true), gettype($resoldMDCount)), __LINE__);
        }
        $this->ResoldMDCount = $resoldMDCount;
        return $this;
    }
    /**
     * Get TransferredMDCount value
     * @return int|null
     */
    public function getTransferredMDCount()
    {
        return $this->TransferredMDCount;
    }
    /**
     * Set TransferredMDCount value
     * @param int $transferredMDCount
     * @return \patest\StructType\CapacityCounters
     */
    public function setTransferredMDCount($transferredMDCount = null)
    {
        // validation for constraint: int
        if (!is_null($transferredMDCount) && !(is_int($transferredMDCount) || ctype_digit($transferredMDCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transferredMDCount, true), gettype($transferredMDCount)), __LINE__);
        }
        $this->TransferredMDCount = $transferredMDCount;
        return $this;
    }
}
