<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelEventReservations-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelEventReservations-Request
 * @subpackage Structs
 */
class CancelEventReservations_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Reservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfReservedTicket
     */
    public $Reservations;
    /**
     * Constructor method for CancelEventReservations-Request
     * @uses CancelEventReservations_Request::setEventId()
     * @uses CancelEventReservations_Request::setReservations()
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfReservedTicket $reservations
     */
    public function __construct($eventId = null, \patest\ArrayType\ArrayOfReservedTicket $reservations = null)
    {
        $this
            ->setEventId($eventId)
            ->setReservations($reservations);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\CancelEventReservations_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Reservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfReservedTicket|null
     */
    public function getReservations()
    {
        return isset($this->Reservations) ? $this->Reservations : null;
    }
    /**
     * Set Reservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfReservedTicket $reservations
     * @return \patest\StructType\CancelEventReservations_Request
     */
    public function setReservations(\patest\ArrayType\ArrayOfReservedTicket $reservations = null)
    {
        if (is_null($reservations) || (is_array($reservations) && empty($reservations))) {
            unset($this->Reservations);
        } else {
            $this->Reservations = $reservations;
        }
        return $this;
    }
}
