<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleElementAvailableProductsEventItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleElementAvailableProductsEventItem
 * @subpackage Structs
 */
class BundleElementAvailableProductsEventItem extends BundleElementAvailableProductsItem
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The IsSoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSoldOut;
    /**
     * The OccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OccupancyStatus;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The AllDayEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllDayEvent;
    /**
     * Constructor method for BundleElementAvailableProductsEventItem
     * @uses BundleElementAvailableProductsEventItem::setDate()
     * @uses BundleElementAvailableProductsEventItem::setFormattedDate()
     * @uses BundleElementAvailableProductsEventItem::setIsSoldOut()
     * @uses BundleElementAvailableProductsEventItem::setOccupancyStatus()
     * @uses BundleElementAvailableProductsEventItem::setShowId()
     * @uses BundleElementAvailableProductsEventItem::setDuration()
     * @uses BundleElementAvailableProductsEventItem::setAllDayEvent()
     * @param string $date
     * @param string $formattedDate
     * @param bool $isSoldOut
     * @param string $occupancyStatus
     * @param string $showId
     * @param int $duration
     * @param bool $allDayEvent
     */
    public function __construct($date = null, $formattedDate = null, $isSoldOut = null, $occupancyStatus = null, $showId = null, $duration = null, $allDayEvent = null)
    {
        $this
            ->setDate($date)
            ->setFormattedDate($formattedDate)
            ->setIsSoldOut($isSoldOut)
            ->setOccupancyStatus($occupancyStatus)
            ->setShowId($showId)
            ->setDuration($duration)
            ->setAllDayEvent($allDayEvent);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get IsSoldOut value
     * @return bool|null
     */
    public function getIsSoldOut()
    {
        return $this->IsSoldOut;
    }
    /**
     * Set IsSoldOut value
     * @param bool $isSoldOut
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setIsSoldOut($isSoldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSoldOut) && !is_bool($isSoldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSoldOut, true), gettype($isSoldOut)), __LINE__);
        }
        $this->IsSoldOut = $isSoldOut;
        return $this;
    }
    /**
     * Get OccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupancyStatus()
    {
        return isset($this->OccupancyStatus) ? $this->OccupancyStatus : null;
    }
    /**
     * Set OccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyStatus
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setOccupancyStatus($occupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($occupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($occupancyStatus) ? implode(', ', $occupancyStatus) : var_export($occupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($occupancyStatus) || (is_array($occupancyStatus) && empty($occupancyStatus))) {
            unset($this->OccupancyStatus);
        } else {
            $this->OccupancyStatus = $occupancyStatus;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get AllDayEvent value
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return $this->AllDayEvent;
    }
    /**
     * Set AllDayEvent value
     * @param bool $allDayEvent
     * @return \patest\StructType\BundleElementAvailableProductsEventItem
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allDayEvent, true), gettype($allDayEvent)), __LINE__);
        }
        $this->AllDayEvent = $allDayEvent;
        return $this;
    }
}
