<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BundleAvailabilityInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BundleAvailabilityInfo
 * @subpackage Structs
 */
class BundleAvailabilityInfo extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for BundleAvailabilityInfo
     * @uses BundleAvailabilityInfo::setDate()
     * @uses BundleAvailabilityInfo::setStatus()
     * @param string $date
     * @param string $status
     */
    public function __construct($date = null, $status = null)
    {
        $this
            ->setDate($date)
            ->setStatus($status);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \patest\StructType\BundleAvailabilityInfo
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\BundleAvailabilityStatus::valueIsValid()
     * @uses \patest\EnumType\BundleAvailabilityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\BundleAvailabilityInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BundleAvailabilityStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BundleAvailabilityStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BundleAvailabilityStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
