<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkEventOwnershipEntryV2 StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BulkEventOwnershipEntryV2
 * @subpackage Structs
 */
class BulkEventOwnershipEntryV2 extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsLastVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLastVersion;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorGlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorGlobalName;
    /**
     * Constructor method for BulkEventOwnershipEntryV2
     * @uses BulkEventOwnershipEntryV2::setClientId()
     * @uses BulkEventOwnershipEntryV2::setIsLastVersion()
     * @uses BulkEventOwnershipEntryV2::setLocalId()
     * @uses BulkEventOwnershipEntryV2::setRowName()
     * @uses BulkEventOwnershipEntryV2::setSeatName()
     * @uses BulkEventOwnershipEntryV2::setSectorGlobalName()
     * @param string $clientId
     * @param bool $isLastVersion
     * @param int $localId
     * @param string $rowName
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorGlobalName
     */
    public function __construct($clientId = null, $isLastVersion = null, $localId = null, $rowName = null, $seatName = null, \patest\StructType\GlobalString $sectorGlobalName = null)
    {
        $this
            ->setClientId($clientId)
            ->setIsLastVersion($isLastVersion)
            ->setLocalId($localId)
            ->setRowName($rowName)
            ->setSeatName($seatName)
            ->setSectorGlobalName($sectorGlobalName);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get IsLastVersion value
     * @return bool|null
     */
    public function getIsLastVersion()
    {
        return $this->IsLastVersion;
    }
    /**
     * Set IsLastVersion value
     * @param bool $isLastVersion
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setIsLastVersion($isLastVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastVersion) && !is_bool($isLastVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastVersion, true), gettype($isLastVersion)), __LINE__);
        }
        $this->IsLastVersion = $isLastVersion;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorGlobalName()
    {
        return isset($this->SectorGlobalName) ? $this->SectorGlobalName : null;
    }
    /**
     * Set SectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @return \patest\StructType\BulkEventOwnershipEntryV2
     */
    public function setSectorGlobalName(\patest\StructType\GlobalString $sectorGlobalName = null)
    {
        if (is_null($sectorGlobalName) || (is_array($sectorGlobalName) && empty($sectorGlobalName))) {
            unset($this->SectorGlobalName);
        } else {
            $this->SectorGlobalName = $sectorGlobalName;
        }
        return $this;
    }
}
