<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookVisitResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookVisitResponse
 * @subpackage Structs
 */
class BookVisitResponse extends ExtensibleDataContract
{
    /**
     * The ErrorMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ErrorMessages;
    /**
     * The IsSchedulingSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSchedulingSucceeded;
    /**
     * The VisitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitDate;
    /**
     * The WarningMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $WarningMessages;
    /**
     * Constructor method for BookVisitResponse
     * @uses BookVisitResponse::setErrorMessages()
     * @uses BookVisitResponse::setIsSchedulingSucceeded()
     * @uses BookVisitResponse::setVisitDate()
     * @uses BookVisitResponse::setWarningMessages()
     * @param \patest\ArrayType\ArrayOfstring $errorMessages
     * @param bool $isSchedulingSucceeded
     * @param string $visitDate
     * @param \patest\ArrayType\ArrayOfstring $warningMessages
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $errorMessages = null, $isSchedulingSucceeded = null, $visitDate = null, \patest\ArrayType\ArrayOfstring $warningMessages = null)
    {
        $this
            ->setErrorMessages($errorMessages)
            ->setIsSchedulingSucceeded($isSchedulingSucceeded)
            ->setVisitDate($visitDate)
            ->setWarningMessages($warningMessages);
    }
    /**
     * Get ErrorMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getErrorMessages()
    {
        return isset($this->ErrorMessages) ? $this->ErrorMessages : null;
    }
    /**
     * Set ErrorMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $errorMessages
     * @return \patest\StructType\BookVisitResponse
     */
    public function setErrorMessages(\patest\ArrayType\ArrayOfstring $errorMessages = null)
    {
        if (is_null($errorMessages) || (is_array($errorMessages) && empty($errorMessages))) {
            unset($this->ErrorMessages);
        } else {
            $this->ErrorMessages = $errorMessages;
        }
        return $this;
    }
    /**
     * Get IsSchedulingSucceeded value
     * @return bool|null
     */
    public function getIsSchedulingSucceeded()
    {
        return $this->IsSchedulingSucceeded;
    }
    /**
     * Set IsSchedulingSucceeded value
     * @param bool $isSchedulingSucceeded
     * @return \patest\StructType\BookVisitResponse
     */
    public function setIsSchedulingSucceeded($isSchedulingSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSchedulingSucceeded) && !is_bool($isSchedulingSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSchedulingSucceeded, true), gettype($isSchedulingSucceeded)), __LINE__);
        }
        $this->IsSchedulingSucceeded = $isSchedulingSucceeded;
        return $this;
    }
    /**
     * Get VisitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitDate()
    {
        return isset($this->VisitDate) ? $this->VisitDate : null;
    }
    /**
     * Set VisitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitDate
     * @return \patest\StructType\BookVisitResponse
     */
    public function setVisitDate($visitDate = null)
    {
        // validation for constraint: string
        if (!is_null($visitDate) && !is_string($visitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitDate, true), gettype($visitDate)), __LINE__);
        }
        if (is_null($visitDate) || (is_array($visitDate) && empty($visitDate))) {
            unset($this->VisitDate);
        } else {
            $this->VisitDate = $visitDate;
        }
        return $this;
    }
    /**
     * Get WarningMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getWarningMessages()
    {
        return isset($this->WarningMessages) ? $this->WarningMessages : null;
    }
    /**
     * Set WarningMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $warningMessages
     * @return \patest\StructType\BookVisitResponse
     */
    public function setWarningMessages(\patest\ArrayType\ArrayOfstring $warningMessages = null)
    {
        if (is_null($warningMessages) || (is_array($warningMessages) && empty($warningMessages))) {
            unset($this->WarningMessages);
        } else {
            $this->WarningMessages = $warningMessages;
        }
        return $this;
    }
}
