<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.VisitWeeklyView StructType
 * @subpackage Structs
 */
class BizResource_VisitWeeklyView extends BizResource_CalendarWeeklyView
{
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * Constructor method for BizResource.VisitWeeklyView
     * @uses BizResource_VisitWeeklyView::setOrderVisitId()
     * @param string $orderVisitId
     */
    public function __construct($orderVisitId = null)
    {
        $this
            ->setOrderVisitId($orderVisitId);
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_VisitWeeklyView
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
}
