<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.TemplateActivity StructType
 * @subpackage Structs
 */
class BizResource_TemplateActivity extends BizResource_PersistableEntityBase
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The CreatedMissingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CreatedMissingEvent;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EffectiveName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveName;
    /**
     * The Intermission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Intermission;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsFullCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullCapacity;
    /**
     * The MaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxCapacity;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The RoomCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomCategoryId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TemplateId;
    /**
     * Constructor method for BizResource.TemplateActivity
     * @uses BizResource_TemplateActivity::setActivityId()
     * @uses BizResource_TemplateActivity::setCreatedMissingEvent()
     * @uses BizResource_TemplateActivity::setDuration()
     * @uses BizResource_TemplateActivity::setEffectiveName()
     * @uses BizResource_TemplateActivity::setIntermission()
     * @uses BizResource_TemplateActivity::setIsActive()
     * @uses BizResource_TemplateActivity::setIsFullCapacity()
     * @uses BizResource_TemplateActivity::setMaxCapacity()
     * @uses BizResource_TemplateActivity::setOrder()
     * @uses BizResource_TemplateActivity::setRoomCategoryId()
     * @uses BizResource_TemplateActivity::setShowId()
     * @uses BizResource_TemplateActivity::setTemplateId()
     * @param string $activityId
     * @param bool $createdMissingEvent
     * @param int $duration
     * @param string $effectiveName
     * @param int $intermission
     * @param bool $isActive
     * @param bool $isFullCapacity
     * @param int $maxCapacity
     * @param int $order
     * @param string $roomCategoryId
     * @param string $showId
     * @param string $templateId
     */
    public function __construct($activityId = null, $createdMissingEvent = null, $duration = null, $effectiveName = null, $intermission = null, $isActive = null, $isFullCapacity = null, $maxCapacity = null, $order = null, $roomCategoryId = null, $showId = null, $templateId = null)
    {
        $this
            ->setActivityId($activityId)
            ->setCreatedMissingEvent($createdMissingEvent)
            ->setDuration($duration)
            ->setEffectiveName($effectiveName)
            ->setIntermission($intermission)
            ->setIsActive($isActive)
            ->setIsFullCapacity($isFullCapacity)
            ->setMaxCapacity($maxCapacity)
            ->setOrder($order)
            ->setRoomCategoryId($roomCategoryId)
            ->setShowId($showId)
            ->setTemplateId($templateId);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get CreatedMissingEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreatedMissingEvent()
    {
        return isset($this->CreatedMissingEvent) ? $this->CreatedMissingEvent : null;
    }
    /**
     * Set CreatedMissingEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createdMissingEvent
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setCreatedMissingEvent($createdMissingEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdMissingEvent) && !is_bool($createdMissingEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdMissingEvent, true), gettype($createdMissingEvent)), __LINE__);
        }
        if (is_null($createdMissingEvent) || (is_array($createdMissingEvent) && empty($createdMissingEvent))) {
            unset($this->CreatedMissingEvent);
        } else {
            $this->CreatedMissingEvent = $createdMissingEvent;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EffectiveName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveName()
    {
        return isset($this->EffectiveName) ? $this->EffectiveName : null;
    }
    /**
     * Set EffectiveName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveName
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setEffectiveName($effectiveName = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveName) && !is_string($effectiveName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveName, true), gettype($effectiveName)), __LINE__);
        }
        if (is_null($effectiveName) || (is_array($effectiveName) && empty($effectiveName))) {
            unset($this->EffectiveName);
        } else {
            $this->EffectiveName = $effectiveName;
        }
        return $this;
    }
    /**
     * Get Intermission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntermission()
    {
        return isset($this->Intermission) ? $this->Intermission : null;
    }
    /**
     * Set Intermission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intermission
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setIntermission($intermission = null)
    {
        // validation for constraint: int
        if (!is_null($intermission) && !(is_int($intermission) || ctype_digit($intermission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermission, true), gettype($intermission)), __LINE__);
        }
        if (is_null($intermission) || (is_array($intermission) && empty($intermission))) {
            unset($this->Intermission);
        } else {
            $this->Intermission = $intermission;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsFullCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullCapacity()
    {
        return isset($this->IsFullCapacity) ? $this->IsFullCapacity : null;
    }
    /**
     * Set IsFullCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullCapacity
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setIsFullCapacity($isFullCapacity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullCapacity) && !is_bool($isFullCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullCapacity, true), gettype($isFullCapacity)), __LINE__);
        }
        if (is_null($isFullCapacity) || (is_array($isFullCapacity) && empty($isFullCapacity))) {
            unset($this->IsFullCapacity);
        } else {
            $this->IsFullCapacity = $isFullCapacity;
        }
        return $this;
    }
    /**
     * Get MaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxCapacity()
    {
        return isset($this->MaxCapacity) ? $this->MaxCapacity : null;
    }
    /**
     * Set MaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxCapacity
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setMaxCapacity($maxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maxCapacity) && !(is_int($maxCapacity) || ctype_digit($maxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCapacity, true), gettype($maxCapacity)), __LINE__);
        }
        if (is_null($maxCapacity) || (is_array($maxCapacity) && empty($maxCapacity))) {
            unset($this->MaxCapacity);
        } else {
            $this->MaxCapacity = $maxCapacity;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get RoomCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCategoryId()
    {
        return isset($this->RoomCategoryId) ? $this->RoomCategoryId : null;
    }
    /**
     * Set RoomCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCategoryId
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setRoomCategoryId($roomCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategoryId) && !is_string($roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategoryId, true), gettype($roomCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomCategoryId, true)), __LINE__);
        }
        if (is_null($roomCategoryId) || (is_array($roomCategoryId) && empty($roomCategoryId))) {
            unset($this->RoomCategoryId);
        } else {
            $this->RoomCategoryId = $roomCategoryId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get TemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplateId()
    {
        return isset($this->TemplateId) ? $this->TemplateId : null;
    }
    /**
     * Set TemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $templateId
     * @return \patest\StructType\BizResource_TemplateActivity
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: string
        if (!is_null($templateId) && !is_string($templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($templateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($templateId, true)), __LINE__);
        }
        if (is_null($templateId) || (is_array($templateId) && empty($templateId))) {
            unset($this->TemplateId);
        } else {
            $this->TemplateId = $templateId;
        }
        return $this;
    }
}
