<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.Template StructType
 * @subpackage Structs
 */
class BizResource_Template extends BizResource_PersistableEntityBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_TemplateActivity
     */
    public $Activities;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaxParticipants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxParticipants;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * Constructor method for BizResource.Template
     * @uses BizResource_Template::setAclSchemeId()
     * @uses BizResource_Template::setActivities()
     * @uses BizResource_Template::setDescription()
     * @uses BizResource_Template::setIsActive()
     * @uses BizResource_Template::setLedgerId()
     * @uses BizResource_Template::setMaxParticipants()
     * @uses BizResource_Template::setName()
     * @uses BizResource_Template::setOrganizationUnitId()
     * @uses BizResource_Template::setProjectIdentifierId()
     * @uses BizResource_Template::setVisibleBySubordinates()
     * @uses BizResource_Template::setVisitPlanId()
     * @param int $aclSchemeId
     * @param \patest\StructType\RecordSetOfBizResource_TemplateActivity $activities
     * @param \patest\StructType\GlobalString $description
     * @param bool $isActive
     * @param string $ledgerId
     * @param int $maxParticipants
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $projectIdentifierId
     * @param bool $visibleBySubordinates
     * @param string $visitPlanId
     */
    public function __construct($aclSchemeId = null, \patest\StructType\RecordSetOfBizResource_TemplateActivity $activities = null, \patest\StructType\GlobalString $description = null, $isActive = null, $ledgerId = null, $maxParticipants = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $projectIdentifierId = null, $visibleBySubordinates = null, $visitPlanId = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setActivities($activities)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setLedgerId($ledgerId)
            ->setMaxParticipants($maxParticipants)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setVisitPlanId($visitPlanId);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\BizResource_Template
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_TemplateActivity|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_TemplateActivity $activities
     * @return \patest\StructType\BizResource_Template
     */
    public function setActivities(\patest\StructType\RecordSetOfBizResource_TemplateActivity $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BizResource_Template
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\BizResource_Template
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\BizResource_Template
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaxParticipants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxParticipants()
    {
        return isset($this->MaxParticipants) ? $this->MaxParticipants : null;
    }
    /**
     * Set MaxParticipants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxParticipants
     * @return \patest\StructType\BizResource_Template
     */
    public function setMaxParticipants($maxParticipants = null)
    {
        // validation for constraint: int
        if (!is_null($maxParticipants) && !(is_int($maxParticipants) || ctype_digit($maxParticipants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxParticipants, true), gettype($maxParticipants)), __LINE__);
        }
        if (is_null($maxParticipants) || (is_array($maxParticipants) && empty($maxParticipants))) {
            unset($this->MaxParticipants);
        } else {
            $this->MaxParticipants = $maxParticipants;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\BizResource_Template
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizResource_Template
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\BizResource_Template
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\BizResource_Template
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizResource_Template
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
}
