<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.OrderVisitActivity StructType
 * @subpackage Structs
 */
class BizResource_OrderVisitActivity extends BizResource_PersistableEntityBase
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The CreatedMissingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CreatedMissingEvent;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The Intermission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Intermission;
    /**
     * The IsEventCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEventCreated;
    /**
     * The IsFullCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullCapacity;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The OtherCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory
     */
    public $OtherCategories;
    /**
     * The RequestedPeople
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedPeople;
    /**
     * The RoomCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomCategoryId;
    /**
     * The RoomId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomId;
    /**
     * The RoomReservationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomReservationId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizResource.OrderVisitActivity
     * @uses BizResource_OrderVisitActivity::setActivityId()
     * @uses BizResource_OrderVisitActivity::setCreatedMissingEvent()
     * @uses BizResource_OrderVisitActivity::setDuration()
     * @uses BizResource_OrderVisitActivity::setEventId()
     * @uses BizResource_OrderVisitActivity::setFromDate()
     * @uses BizResource_OrderVisitActivity::setIntermission()
     * @uses BizResource_OrderVisitActivity::setIsEventCreated()
     * @uses BizResource_OrderVisitActivity::setIsFullCapacity()
     * @uses BizResource_OrderVisitActivity::setName()
     * @uses BizResource_OrderVisitActivity::setOrder()
     * @uses BizResource_OrderVisitActivity::setOrderVisitId()
     * @uses BizResource_OrderVisitActivity::setOtherCategories()
     * @uses BizResource_OrderVisitActivity::setRequestedPeople()
     * @uses BizResource_OrderVisitActivity::setRoomCategoryId()
     * @uses BizResource_OrderVisitActivity::setRoomId()
     * @uses BizResource_OrderVisitActivity::setRoomReservationId()
     * @uses BizResource_OrderVisitActivity::setShowId()
     * @uses BizResource_OrderVisitActivity::setUntilDate()
     * @param string $activityId
     * @param bool $createdMissingEvent
     * @param int $duration
     * @param string $eventId
     * @param string $fromDate
     * @param int $intermission
     * @param bool $isEventCreated
     * @param bool $isFullCapacity
     * @param string $name
     * @param int $order
     * @param string $orderVisitId
     * @param \patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory $otherCategories
     * @param int $requestedPeople
     * @param string $roomCategoryId
     * @param string $roomId
     * @param string $roomReservationId
     * @param string $showId
     * @param string $untilDate
     */
    public function __construct($activityId = null, $createdMissingEvent = null, $duration = null, $eventId = null, $fromDate = null, $intermission = null, $isEventCreated = null, $isFullCapacity = null, $name = null, $order = null, $orderVisitId = null, \patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory $otherCategories = null, $requestedPeople = null, $roomCategoryId = null, $roomId = null, $roomReservationId = null, $showId = null, $untilDate = null)
    {
        $this
            ->setActivityId($activityId)
            ->setCreatedMissingEvent($createdMissingEvent)
            ->setDuration($duration)
            ->setEventId($eventId)
            ->setFromDate($fromDate)
            ->setIntermission($intermission)
            ->setIsEventCreated($isEventCreated)
            ->setIsFullCapacity($isFullCapacity)
            ->setName($name)
            ->setOrder($order)
            ->setOrderVisitId($orderVisitId)
            ->setOtherCategories($otherCategories)
            ->setRequestedPeople($requestedPeople)
            ->setRoomCategoryId($roomCategoryId)
            ->setRoomId($roomId)
            ->setRoomReservationId($roomReservationId)
            ->setShowId($showId)
            ->setUntilDate($untilDate);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get CreatedMissingEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreatedMissingEvent()
    {
        return isset($this->CreatedMissingEvent) ? $this->CreatedMissingEvent : null;
    }
    /**
     * Set CreatedMissingEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createdMissingEvent
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setCreatedMissingEvent($createdMissingEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdMissingEvent) && !is_bool($createdMissingEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdMissingEvent, true), gettype($createdMissingEvent)), __LINE__);
        }
        if (is_null($createdMissingEvent) || (is_array($createdMissingEvent) && empty($createdMissingEvent))) {
            unset($this->CreatedMissingEvent);
        } else {
            $this->CreatedMissingEvent = $createdMissingEvent;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get Intermission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntermission()
    {
        return isset($this->Intermission) ? $this->Intermission : null;
    }
    /**
     * Set Intermission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intermission
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setIntermission($intermission = null)
    {
        // validation for constraint: int
        if (!is_null($intermission) && !(is_int($intermission) || ctype_digit($intermission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermission, true), gettype($intermission)), __LINE__);
        }
        if (is_null($intermission) || (is_array($intermission) && empty($intermission))) {
            unset($this->Intermission);
        } else {
            $this->Intermission = $intermission;
        }
        return $this;
    }
    /**
     * Get IsEventCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEventCreated()
    {
        return isset($this->IsEventCreated) ? $this->IsEventCreated : null;
    }
    /**
     * Set IsEventCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEventCreated
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setIsEventCreated($isEventCreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEventCreated) && !is_bool($isEventCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEventCreated, true), gettype($isEventCreated)), __LINE__);
        }
        if (is_null($isEventCreated) || (is_array($isEventCreated) && empty($isEventCreated))) {
            unset($this->IsEventCreated);
        } else {
            $this->IsEventCreated = $isEventCreated;
        }
        return $this;
    }
    /**
     * Get IsFullCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullCapacity()
    {
        return isset($this->IsFullCapacity) ? $this->IsFullCapacity : null;
    }
    /**
     * Set IsFullCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullCapacity
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setIsFullCapacity($isFullCapacity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullCapacity) && !is_bool($isFullCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullCapacity, true), gettype($isFullCapacity)), __LINE__);
        }
        if (is_null($isFullCapacity) || (is_array($isFullCapacity) && empty($isFullCapacity))) {
            unset($this->IsFullCapacity);
        } else {
            $this->IsFullCapacity = $isFullCapacity;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get OtherCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory|null
     */
    public function getOtherCategories()
    {
        return isset($this->OtherCategories) ? $this->OtherCategories : null;
    }
    /**
     * Set OtherCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory $otherCategories
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setOtherCategories(\patest\StructType\RecordSetOfBizResource_OrderVisitActivityCategory $otherCategories = null)
    {
        if (is_null($otherCategories) || (is_array($otherCategories) && empty($otherCategories))) {
            unset($this->OtherCategories);
        } else {
            $this->OtherCategories = $otherCategories;
        }
        return $this;
    }
    /**
     * Get RequestedPeople value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedPeople()
    {
        return isset($this->RequestedPeople) ? $this->RequestedPeople : null;
    }
    /**
     * Set RequestedPeople value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedPeople
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setRequestedPeople($requestedPeople = null)
    {
        // validation for constraint: int
        if (!is_null($requestedPeople) && !(is_int($requestedPeople) || ctype_digit($requestedPeople))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedPeople, true), gettype($requestedPeople)), __LINE__);
        }
        if (is_null($requestedPeople) || (is_array($requestedPeople) && empty($requestedPeople))) {
            unset($this->RequestedPeople);
        } else {
            $this->RequestedPeople = $requestedPeople;
        }
        return $this;
    }
    /**
     * Get RoomCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCategoryId()
    {
        return isset($this->RoomCategoryId) ? $this->RoomCategoryId : null;
    }
    /**
     * Set RoomCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCategoryId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setRoomCategoryId($roomCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategoryId) && !is_string($roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategoryId, true), gettype($roomCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomCategoryId, true)), __LINE__);
        }
        if (is_null($roomCategoryId) || (is_array($roomCategoryId) && empty($roomCategoryId))) {
            unset($this->RoomCategoryId);
        } else {
            $this->RoomCategoryId = $roomCategoryId;
        }
        return $this;
    }
    /**
     * Get RoomId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomId()
    {
        return isset($this->RoomId) ? $this->RoomId : null;
    }
    /**
     * Set RoomId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setRoomId($roomId = null)
    {
        // validation for constraint: string
        if (!is_null($roomId) && !is_string($roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomId, true), gettype($roomId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomId, true)), __LINE__);
        }
        if (is_null($roomId) || (is_array($roomId) && empty($roomId))) {
            unset($this->RoomId);
        } else {
            $this->RoomId = $roomId;
        }
        return $this;
    }
    /**
     * Get RoomReservationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomReservationId()
    {
        return isset($this->RoomReservationId) ? $this->RoomReservationId : null;
    }
    /**
     * Set RoomReservationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomReservationId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setRoomReservationId($roomReservationId = null)
    {
        // validation for constraint: string
        if (!is_null($roomReservationId) && !is_string($roomReservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomReservationId, true), gettype($roomReservationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomReservationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomReservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomReservationId, true)), __LINE__);
        }
        if (is_null($roomReservationId) || (is_array($roomReservationId) && empty($roomReservationId))) {
            unset($this->RoomReservationId);
        } else {
            $this->RoomReservationId = $roomReservationId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizResource_OrderVisitActivity
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
