<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.Order StructType
 * @subpackage Structs
 */
class BizResource_Order extends BizResource_PersistableEntityBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The BillingStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingStatus;
    /**
     * The BookingStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingStatus;
    /**
     * The CancellationStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancellationStatus;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The ConfirmationStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationStatus;
    /**
     * The CreatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedByUserId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DocumentIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DocumentIds
     */
    public $DocumentIds;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraData;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The GroupsNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupsNumber;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The InternalComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $InternalComment;
    /**
     * The IsResourcesAllocated
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResourcesAllocated;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mobile;
    /**
     * The OrderContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderContactId;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The OrderVisits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_OrderVisit
     */
    public $OrderVisits;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The ProposalDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProposalDate;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for BizResource.Order
     * @uses BizResource_Order::setAclSchemeId()
     * @uses BizResource_Order::setBillingStatus()
     * @uses BizResource_Order::setBookingStatus()
     * @uses BizResource_Order::setCancellationStatus()
     * @uses BizResource_Order::setComment()
     * @uses BizResource_Order::setConfirmationStatus()
     * @uses BizResource_Order::setCreatedByUserId()
     * @uses BizResource_Order::setCreationDate()
     * @uses BizResource_Order::setDocumentIds()
     * @uses BizResource_Order::setEmail()
     * @uses BizResource_Order::setExtraData()
     * @uses BizResource_Order::setFax()
     * @uses BizResource_Order::setGroupsNumber()
     * @uses BizResource_Order::setHomePhone()
     * @uses BizResource_Order::setInternalComment()
     * @uses BizResource_Order::setIsResourcesAllocated()
     * @uses BizResource_Order::setMobile()
     * @uses BizResource_Order::setOrderContactId()
     * @uses BizResource_Order::setOrderNumber()
     * @uses BizResource_Order::setOrderType()
     * @uses BizResource_Order::setOrderVisits()
     * @uses BizResource_Order::setOrganizationUnitId()
     * @uses BizResource_Order::setPayerAccountId()
     * @uses BizResource_Order::setProposalDate()
     * @uses BizResource_Order::setTotalPrice()
     * @uses BizResource_Order::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $billingStatus
     * @param string $bookingStatus
     * @param string $cancellationStatus
     * @param \patest\StructType\GlobalString $comment
     * @param string $confirmationStatus
     * @param string $createdByUserId
     * @param string $creationDate
     * @param \patest\StructType\DocumentIds $documentIds
     * @param string $email
     * @param string $extraData
     * @param string $fax
     * @param int $groupsNumber
     * @param string $homePhone
     * @param \patest\StructType\GlobalString $internalComment
     * @param bool $isResourcesAllocated
     * @param string $mobile
     * @param string $orderContactId
     * @param int $orderNumber
     * @param string $orderType
     * @param \patest\StructType\RecordSetOfBizResource_OrderVisit $orderVisits
     * @param string $organizationUnitId
     * @param string $payerAccountId
     * @param string $proposalDate
     * @param float $totalPrice
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $billingStatus = null, $bookingStatus = null, $cancellationStatus = null, \patest\StructType\GlobalString $comment = null, $confirmationStatus = null, $createdByUserId = null, $creationDate = null, \patest\StructType\DocumentIds $documentIds = null, $email = null, $extraData = null, $fax = null, $groupsNumber = null, $homePhone = null, \patest\StructType\GlobalString $internalComment = null, $isResourcesAllocated = null, $mobile = null, $orderContactId = null, $orderNumber = null, $orderType = null, \patest\StructType\RecordSetOfBizResource_OrderVisit $orderVisits = null, $organizationUnitId = null, $payerAccountId = null, $proposalDate = null, $totalPrice = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setBillingStatus($billingStatus)
            ->setBookingStatus($bookingStatus)
            ->setCancellationStatus($cancellationStatus)
            ->setComment($comment)
            ->setConfirmationStatus($confirmationStatus)
            ->setCreatedByUserId($createdByUserId)
            ->setCreationDate($creationDate)
            ->setDocumentIds($documentIds)
            ->setEmail($email)
            ->setExtraData($extraData)
            ->setFax($fax)
            ->setGroupsNumber($groupsNumber)
            ->setHomePhone($homePhone)
            ->setInternalComment($internalComment)
            ->setIsResourcesAllocated($isResourcesAllocated)
            ->setMobile($mobile)
            ->setOrderContactId($orderContactId)
            ->setOrderNumber($orderNumber)
            ->setOrderType($orderType)
            ->setOrderVisits($orderVisits)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPayerAccountId($payerAccountId)
            ->setProposalDate($proposalDate)
            ->setTotalPrice($totalPrice)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\BizResource_Order
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get BillingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingStatus()
    {
        return isset($this->BillingStatus) ? $this->BillingStatus : null;
    }
    /**
     * Set BillingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationStatus::valueIsValid()
     * @uses \patest\EnumType\AllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingStatus
     * @return \patest\StructType\BizResource_Order
     */
    public function setBillingStatus($billingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationStatus::valueIsValid($billingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationStatus', is_array($billingStatus) ? implode(', ', $billingStatus) : var_export($billingStatus, true), implode(', ', \patest\EnumType\AllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($billingStatus) || (is_array($billingStatus) && empty($billingStatus))) {
            unset($this->BillingStatus);
        } else {
            $this->BillingStatus = $billingStatus;
        }
        return $this;
    }
    /**
     * Get BookingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingStatus()
    {
        return isset($this->BookingStatus) ? $this->BookingStatus : null;
    }
    /**
     * Set BookingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationStatus::valueIsValid()
     * @uses \patest\EnumType\AllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatus
     * @return \patest\StructType\BizResource_Order
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationStatus::valueIsValid($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationStatus', is_array($bookingStatus) ? implode(', ', $bookingStatus) : var_export($bookingStatus, true), implode(', ', \patest\EnumType\AllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($bookingStatus) || (is_array($bookingStatus) && empty($bookingStatus))) {
            unset($this->BookingStatus);
        } else {
            $this->BookingStatus = $bookingStatus;
        }
        return $this;
    }
    /**
     * Get CancellationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancellationStatus()
    {
        return isset($this->CancellationStatus) ? $this->CancellationStatus : null;
    }
    /**
     * Set CancellationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationStatus::valueIsValid()
     * @uses \patest\EnumType\AllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancellationStatus
     * @return \patest\StructType\BizResource_Order
     */
    public function setCancellationStatus($cancellationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationStatus::valueIsValid($cancellationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationStatus', is_array($cancellationStatus) ? implode(', ', $cancellationStatus) : var_export($cancellationStatus, true), implode(', ', \patest\EnumType\AllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($cancellationStatus) || (is_array($cancellationStatus) && empty($cancellationStatus))) {
            unset($this->CancellationStatus);
        } else {
            $this->CancellationStatus = $cancellationStatus;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\BizResource_Order
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get ConfirmationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationStatus()
    {
        return isset($this->ConfirmationStatus) ? $this->ConfirmationStatus : null;
    }
    /**
     * Set ConfirmationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationStatus::valueIsValid()
     * @uses \patest\EnumType\AllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confirmationStatus
     * @return \patest\StructType\BizResource_Order
     */
    public function setConfirmationStatus($confirmationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationStatus::valueIsValid($confirmationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationStatus', is_array($confirmationStatus) ? implode(', ', $confirmationStatus) : var_export($confirmationStatus, true), implode(', ', \patest\EnumType\AllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($confirmationStatus) || (is_array($confirmationStatus) && empty($confirmationStatus))) {
            unset($this->ConfirmationStatus);
        } else {
            $this->ConfirmationStatus = $confirmationStatus;
        }
        return $this;
    }
    /**
     * Get CreatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUserId()
    {
        return isset($this->CreatedByUserId) ? $this->CreatedByUserId : null;
    }
    /**
     * Set CreatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUserId
     * @return \patest\StructType\BizResource_Order
     */
    public function setCreatedByUserId($createdByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserId) && !is_string($createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUserId, true), gettype($createdByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdByUserId, true)), __LINE__);
        }
        if (is_null($createdByUserId) || (is_array($createdByUserId) && empty($createdByUserId))) {
            unset($this->CreatedByUserId);
        } else {
            $this->CreatedByUserId = $createdByUserId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\BizResource_Order
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DocumentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DocumentIds|null
     */
    public function getDocumentIds()
    {
        return isset($this->DocumentIds) ? $this->DocumentIds : null;
    }
    /**
     * Set DocumentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DocumentIds $documentIds
     * @return \patest\StructType\BizResource_Order
     */
    public function setDocumentIds(\patest\StructType\DocumentIds $documentIds = null)
    {
        if (is_null($documentIds) || (is_array($documentIds) && empty($documentIds))) {
            unset($this->DocumentIds);
        } else {
            $this->DocumentIds = $documentIds;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\BizResource_Order
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraData
     * @return \patest\StructType\BizResource_Order
     */
    public function setExtraData($extraData = null)
    {
        // validation for constraint: string
        if (!is_null($extraData) && !is_string($extraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraData, true), gettype($extraData)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraData) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraData, true)), __LINE__);
        }
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\BizResource_Order
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get GroupsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupsNumber()
    {
        return isset($this->GroupsNumber) ? $this->GroupsNumber : null;
    }
    /**
     * Set GroupsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupsNumber
     * @return \patest\StructType\BizResource_Order
     */
    public function setGroupsNumber($groupsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($groupsNumber) && !(is_int($groupsNumber) || ctype_digit($groupsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupsNumber, true), gettype($groupsNumber)), __LINE__);
        }
        if (is_null($groupsNumber) || (is_array($groupsNumber) && empty($groupsNumber))) {
            unset($this->GroupsNumber);
        } else {
            $this->GroupsNumber = $groupsNumber;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\BizResource_Order
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get InternalComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getInternalComment()
    {
        return isset($this->InternalComment) ? $this->InternalComment : null;
    }
    /**
     * Set InternalComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $internalComment
     * @return \patest\StructType\BizResource_Order
     */
    public function setInternalComment(\patest\StructType\GlobalString $internalComment = null)
    {
        if (is_null($internalComment) || (is_array($internalComment) && empty($internalComment))) {
            unset($this->InternalComment);
        } else {
            $this->InternalComment = $internalComment;
        }
        return $this;
    }
    /**
     * Get IsResourcesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResourcesAllocated()
    {
        return isset($this->IsResourcesAllocated) ? $this->IsResourcesAllocated : null;
    }
    /**
     * Set IsResourcesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResourcesAllocated
     * @return \patest\StructType\BizResource_Order
     */
    public function setIsResourcesAllocated($isResourcesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResourcesAllocated) && !is_bool($isResourcesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResourcesAllocated, true), gettype($isResourcesAllocated)), __LINE__);
        }
        if (is_null($isResourcesAllocated) || (is_array($isResourcesAllocated) && empty($isResourcesAllocated))) {
            unset($this->IsResourcesAllocated);
        } else {
            $this->IsResourcesAllocated = $isResourcesAllocated;
        }
        return $this;
    }
    /**
     * Get Mobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobile()
    {
        return isset($this->Mobile) ? $this->Mobile : null;
    }
    /**
     * Set Mobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobile
     * @return \patest\StructType\BizResource_Order
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        if (is_null($mobile) || (is_array($mobile) && empty($mobile))) {
            unset($this->Mobile);
        } else {
            $this->Mobile = $mobile;
        }
        return $this;
    }
    /**
     * Get OrderContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactId()
    {
        return isset($this->OrderContactId) ? $this->OrderContactId : null;
    }
    /**
     * Set OrderContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactId
     * @return \patest\StructType\BizResource_Order
     */
    public function setOrderContactId($orderContactId = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactId) && !is_string($orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactId, true), gettype($orderContactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderContactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderContactId, true)), __LINE__);
        }
        if (is_null($orderContactId) || (is_array($orderContactId) && empty($orderContactId))) {
            unset($this->OrderContactId);
        } else {
            $this->OrderContactId = $orderContactId;
        }
        return $this;
    }
    /**
     * Get OrderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNumber()
    {
        return isset($this->OrderNumber) ? $this->OrderNumber : null;
    }
    /**
     * Set OrderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNumber
     * @return \patest\StructType\BizResource_Order
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->OrderNumber);
        } else {
            $this->OrderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\BizResource_Order
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrderVisits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_OrderVisit|null
     */
    public function getOrderVisits()
    {
        return isset($this->OrderVisits) ? $this->OrderVisits : null;
    }
    /**
     * Set OrderVisits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_OrderVisit $orderVisits
     * @return \patest\StructType\BizResource_Order
     */
    public function setOrderVisits(\patest\StructType\RecordSetOfBizResource_OrderVisit $orderVisits = null)
    {
        if (is_null($orderVisits) || (is_array($orderVisits) && empty($orderVisits))) {
            unset($this->OrderVisits);
        } else {
            $this->OrderVisits = $orderVisits;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizResource_Order
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizResource_Order
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get ProposalDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProposalDate()
    {
        return isset($this->ProposalDate) ? $this->ProposalDate : null;
    }
    /**
     * Set ProposalDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proposalDate
     * @return \patest\StructType\BizResource_Order
     */
    public function setProposalDate($proposalDate = null)
    {
        // validation for constraint: string
        if (!is_null($proposalDate) && !is_string($proposalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalDate, true), gettype($proposalDate)), __LINE__);
        }
        if (is_null($proposalDate) || (is_array($proposalDate) && empty($proposalDate))) {
            unset($this->ProposalDate);
        } else {
            $this->ProposalDate = $proposalDate;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \patest\StructType\BizResource_Order
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\BizResource_Order
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
