<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.GuidanceBasketItemData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BizResource.GuidanceBasketItemData
 * @subpackage Structs
 */
class BizResource_GuidanceBasketItemData extends Sales_AbstractItemDetails
{
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The FixedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FixedPrice;
    /**
     * The GuidanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceId;
    /**
     * The GuidanceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuidanceName;
    /**
     * The GuidanceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidanceTypeId;
    /**
     * The GuideId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideId;
    /**
     * The GuideRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideRequestId;
    /**
     * The IsFixedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFixedPrice;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The MinutesFromStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinutesFromStart;
    /**
     * The SkillIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SkillIds
     */
    public $SkillIds;
    /**
     * The StartAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartAt;
    /**
     * Constructor method for BizResource.GuidanceBasketItemData
     * @uses BizResource_GuidanceBasketItemData::setDuration()
     * @uses BizResource_GuidanceBasketItemData::setEventId()
     * @uses BizResource_GuidanceBasketItemData::setEventName()
     * @uses BizResource_GuidanceBasketItemData::setFixedPrice()
     * @uses BizResource_GuidanceBasketItemData::setGuidanceId()
     * @uses BizResource_GuidanceBasketItemData::setGuidanceName()
     * @uses BizResource_GuidanceBasketItemData::setGuidanceTypeId()
     * @uses BizResource_GuidanceBasketItemData::setGuideId()
     * @uses BizResource_GuidanceBasketItemData::setGuideRequestId()
     * @uses BizResource_GuidanceBasketItemData::setIsFixedPrice()
     * @uses BizResource_GuidanceBasketItemData::setIsValid()
     * @uses BizResource_GuidanceBasketItemData::setMinutesFromStart()
     * @uses BizResource_GuidanceBasketItemData::setSkillIds()
     * @uses BizResource_GuidanceBasketItemData::setStartAt()
     * @param int $duration
     * @param string $eventId
     * @param string $eventName
     * @param float $fixedPrice
     * @param string $guidanceId
     * @param string $guidanceName
     * @param string $guidanceTypeId
     * @param string $guideId
     * @param string $guideRequestId
     * @param bool $isFixedPrice
     * @param bool $isValid
     * @param int $minutesFromStart
     * @param \patest\StructType\SkillIds $skillIds
     * @param string $startAt
     */
    public function __construct($duration = null, $eventId = null, $eventName = null, $fixedPrice = null, $guidanceId = null, $guidanceName = null, $guidanceTypeId = null, $guideId = null, $guideRequestId = null, $isFixedPrice = null, $isValid = null, $minutesFromStart = null, \patest\StructType\SkillIds $skillIds = null, $startAt = null)
    {
        $this
            ->setDuration($duration)
            ->setEventId($eventId)
            ->setEventName($eventName)
            ->setFixedPrice($fixedPrice)
            ->setGuidanceId($guidanceId)
            ->setGuidanceName($guidanceName)
            ->setGuidanceTypeId($guidanceTypeId)
            ->setGuideId($guideId)
            ->setGuideRequestId($guideRequestId)
            ->setIsFixedPrice($isFixedPrice)
            ->setIsValid($isValid)
            ->setMinutesFromStart($minutesFromStart)
            ->setSkillIds($skillIds)
            ->setStartAt($startAt);
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get FixedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFixedPrice()
    {
        return isset($this->FixedPrice) ? $this->FixedPrice : null;
    }
    /**
     * Set FixedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fixedPrice
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setFixedPrice($fixedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($fixedPrice) && !(is_float($fixedPrice) || is_numeric($fixedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedPrice, true), gettype($fixedPrice)), __LINE__);
        }
        if (is_null($fixedPrice) || (is_array($fixedPrice) && empty($fixedPrice))) {
            unset($this->FixedPrice);
        } else {
            $this->FixedPrice = $fixedPrice;
        }
        return $this;
    }
    /**
     * Get GuidanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceId()
    {
        return isset($this->GuidanceId) ? $this->GuidanceId : null;
    }
    /**
     * Set GuidanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceId
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setGuidanceId($guidanceId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceId) && !is_string($guidanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceId, true), gettype($guidanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceId, true)), __LINE__);
        }
        if (is_null($guidanceId) || (is_array($guidanceId) && empty($guidanceId))) {
            unset($this->GuidanceId);
        } else {
            $this->GuidanceId = $guidanceId;
        }
        return $this;
    }
    /**
     * Get GuidanceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceName()
    {
        return isset($this->GuidanceName) ? $this->GuidanceName : null;
    }
    /**
     * Set GuidanceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceName
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setGuidanceName($guidanceName = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceName) && !is_string($guidanceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceName, true), gettype($guidanceName)), __LINE__);
        }
        if (is_null($guidanceName) || (is_array($guidanceName) && empty($guidanceName))) {
            unset($this->GuidanceName);
        } else {
            $this->GuidanceName = $guidanceName;
        }
        return $this;
    }
    /**
     * Get GuidanceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidanceTypeId()
    {
        return isset($this->GuidanceTypeId) ? $this->GuidanceTypeId : null;
    }
    /**
     * Set GuidanceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidanceTypeId
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setGuidanceTypeId($guidanceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guidanceTypeId) && !is_string($guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidanceTypeId, true), gettype($guidanceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidanceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidanceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidanceTypeId, true)), __LINE__);
        }
        if (is_null($guidanceTypeId) || (is_array($guidanceTypeId) && empty($guidanceTypeId))) {
            unset($this->GuidanceTypeId);
        } else {
            $this->GuidanceTypeId = $guidanceTypeId;
        }
        return $this;
    }
    /**
     * Get GuideId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideId()
    {
        return isset($this->GuideId) ? $this->GuideId : null;
    }
    /**
     * Set GuideId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideId
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setGuideId($guideId = null)
    {
        // validation for constraint: string
        if (!is_null($guideId) && !is_string($guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideId, true), gettype($guideId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideId, true)), __LINE__);
        }
        if (is_null($guideId) || (is_array($guideId) && empty($guideId))) {
            unset($this->GuideId);
        } else {
            $this->GuideId = $guideId;
        }
        return $this;
    }
    /**
     * Get GuideRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideRequestId()
    {
        return isset($this->GuideRequestId) ? $this->GuideRequestId : null;
    }
    /**
     * Set GuideRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideRequestId
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setGuideRequestId($guideRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($guideRequestId) && !is_string($guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideRequestId, true), gettype($guideRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideRequestId, true)), __LINE__);
        }
        if (is_null($guideRequestId) || (is_array($guideRequestId) && empty($guideRequestId))) {
            unset($this->GuideRequestId);
        } else {
            $this->GuideRequestId = $guideRequestId;
        }
        return $this;
    }
    /**
     * Get IsFixedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFixedPrice()
    {
        return isset($this->IsFixedPrice) ? $this->IsFixedPrice : null;
    }
    /**
     * Set IsFixedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFixedPrice
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setIsFixedPrice($isFixedPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFixedPrice) && !is_bool($isFixedPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFixedPrice, true), gettype($isFixedPrice)), __LINE__);
        }
        if (is_null($isFixedPrice) || (is_array($isFixedPrice) && empty($isFixedPrice))) {
            unset($this->IsFixedPrice);
        } else {
            $this->IsFixedPrice = $isFixedPrice;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get MinutesFromStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinutesFromStart()
    {
        return isset($this->MinutesFromStart) ? $this->MinutesFromStart : null;
    }
    /**
     * Set MinutesFromStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minutesFromStart
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setMinutesFromStart($minutesFromStart = null)
    {
        // validation for constraint: int
        if (!is_null($minutesFromStart) && !(is_int($minutesFromStart) || ctype_digit($minutesFromStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesFromStart, true), gettype($minutesFromStart)), __LINE__);
        }
        if (is_null($minutesFromStart) || (is_array($minutesFromStart) && empty($minutesFromStart))) {
            unset($this->MinutesFromStart);
        } else {
            $this->MinutesFromStart = $minutesFromStart;
        }
        return $this;
    }
    /**
     * Get SkillIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SkillIds|null
     */
    public function getSkillIds()
    {
        return isset($this->SkillIds) ? $this->SkillIds : null;
    }
    /**
     * Set SkillIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SkillIds $skillIds
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setSkillIds(\patest\StructType\SkillIds $skillIds = null)
    {
        if (is_null($skillIds) || (is_array($skillIds) && empty($skillIds))) {
            unset($this->SkillIds);
        } else {
            $this->SkillIds = $skillIds;
        }
        return $this;
    }
    /**
     * Get StartAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartAt()
    {
        return isset($this->StartAt) ? $this->StartAt : null;
    }
    /**
     * Set StartAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestStartType::valueIsValid()
     * @uses \patest\EnumType\RequestStartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startAt
     * @return \patest\StructType\BizResource_GuidanceBasketItemData
     */
    public function setStartAt($startAt = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestStartType::valueIsValid($startAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestStartType', is_array($startAt) ? implode(', ', $startAt) : var_export($startAt, true), implode(', ', \patest\EnumType\RequestStartType::getValidValues())), __LINE__);
        }
        if (is_null($startAt) || (is_array($startAt) && empty($startAt))) {
            unset($this->StartAt);
        } else {
            $this->StartAt = $startAt;
        }
        return $this;
    }
}
