<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BookingScheduleView StructType
 * @subpackage Structs
 */
class BizResource_BookingScheduleView extends BizResource_RoomScheduleView
{
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BookRoomActivity
     */
    public $Activities;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ExpandCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExpandCalendar;
    /**
     * The IsSchedulingSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSchedulingSucceeded;
    /**
     * The IsVisitAllocatedToday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisitAllocatedToday;
    /**
     * The MinStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartTime;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TemplateId;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * The WarningMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarningMessage;
    /**
     * Constructor method for BizResource.BookingScheduleView
     * @uses BizResource_BookingScheduleView::setActivities()
     * @uses BizResource_BookingScheduleView::setErrorMessage()
     * @uses BizResource_BookingScheduleView::setExpandCalendar()
     * @uses BizResource_BookingScheduleView::setIsSchedulingSucceeded()
     * @uses BizResource_BookingScheduleView::setIsVisitAllocatedToday()
     * @uses BizResource_BookingScheduleView::setMinStartTime()
     * @uses BizResource_BookingScheduleView::setOrderVisitId()
     * @uses BizResource_BookingScheduleView::setTemplateId()
     * @uses BizResource_BookingScheduleView::setVisitPlanId()
     * @uses BizResource_BookingScheduleView::setVisitTypeId()
     * @uses BizResource_BookingScheduleView::setWarningMessage()
     * @param \patest\StructType\RecordSetOfBizResource_BookRoomActivity $activities
     * @param string $errorMessage
     * @param bool $expandCalendar
     * @param bool $isSchedulingSucceeded
     * @param bool $isVisitAllocatedToday
     * @param string $minStartTime
     * @param string $orderVisitId
     * @param string $templateId
     * @param string $visitPlanId
     * @param string $visitTypeId
     * @param string $warningMessage
     */
    public function __construct(\patest\StructType\RecordSetOfBizResource_BookRoomActivity $activities = null, $errorMessage = null, $expandCalendar = null, $isSchedulingSucceeded = null, $isVisitAllocatedToday = null, $minStartTime = null, $orderVisitId = null, $templateId = null, $visitPlanId = null, $visitTypeId = null, $warningMessage = null)
    {
        $this
            ->setActivities($activities)
            ->setErrorMessage($errorMessage)
            ->setExpandCalendar($expandCalendar)
            ->setIsSchedulingSucceeded($isSchedulingSucceeded)
            ->setIsVisitAllocatedToday($isVisitAllocatedToday)
            ->setMinStartTime($minStartTime)
            ->setOrderVisitId($orderVisitId)
            ->setTemplateId($templateId)
            ->setVisitPlanId($visitPlanId)
            ->setVisitTypeId($visitTypeId)
            ->setWarningMessage($warningMessage);
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BookRoomActivity|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BookRoomActivity $activities
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setActivities(\patest\StructType\RecordSetOfBizResource_BookRoomActivity $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get ExpandCalendar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExpandCalendar()
    {
        return isset($this->ExpandCalendar) ? $this->ExpandCalendar : null;
    }
    /**
     * Set ExpandCalendar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $expandCalendar
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setExpandCalendar($expandCalendar = null)
    {
        // validation for constraint: boolean
        if (!is_null($expandCalendar) && !is_bool($expandCalendar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expandCalendar, true), gettype($expandCalendar)), __LINE__);
        }
        if (is_null($expandCalendar) || (is_array($expandCalendar) && empty($expandCalendar))) {
            unset($this->ExpandCalendar);
        } else {
            $this->ExpandCalendar = $expandCalendar;
        }
        return $this;
    }
    /**
     * Get IsSchedulingSucceeded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSchedulingSucceeded()
    {
        return isset($this->IsSchedulingSucceeded) ? $this->IsSchedulingSucceeded : null;
    }
    /**
     * Set IsSchedulingSucceeded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSchedulingSucceeded
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setIsSchedulingSucceeded($isSchedulingSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSchedulingSucceeded) && !is_bool($isSchedulingSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSchedulingSucceeded, true), gettype($isSchedulingSucceeded)), __LINE__);
        }
        if (is_null($isSchedulingSucceeded) || (is_array($isSchedulingSucceeded) && empty($isSchedulingSucceeded))) {
            unset($this->IsSchedulingSucceeded);
        } else {
            $this->IsSchedulingSucceeded = $isSchedulingSucceeded;
        }
        return $this;
    }
    /**
     * Get IsVisitAllocatedToday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisitAllocatedToday()
    {
        return isset($this->IsVisitAllocatedToday) ? $this->IsVisitAllocatedToday : null;
    }
    /**
     * Set IsVisitAllocatedToday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisitAllocatedToday
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setIsVisitAllocatedToday($isVisitAllocatedToday = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisitAllocatedToday) && !is_bool($isVisitAllocatedToday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisitAllocatedToday, true), gettype($isVisitAllocatedToday)), __LINE__);
        }
        if (is_null($isVisitAllocatedToday) || (is_array($isVisitAllocatedToday) && empty($isVisitAllocatedToday))) {
            unset($this->IsVisitAllocatedToday);
        } else {
            $this->IsVisitAllocatedToday = $isVisitAllocatedToday;
        }
        return $this;
    }
    /**
     * Get MinStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartTime()
    {
        return isset($this->MinStartTime) ? $this->MinStartTime : null;
    }
    /**
     * Set MinStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartTime
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setMinStartTime($minStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($minStartTime) && !is_string($minStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartTime, true), gettype($minStartTime)), __LINE__);
        }
        if (is_null($minStartTime) || (is_array($minStartTime) && empty($minStartTime))) {
            unset($this->MinStartTime);
        } else {
            $this->MinStartTime = $minStartTime;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get TemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemplateId()
    {
        return isset($this->TemplateId) ? $this->TemplateId : null;
    }
    /**
     * Set TemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $templateId
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: string
        if (!is_null($templateId) && !is_string($templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($templateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($templateId, true)), __LINE__);
        }
        if (is_null($templateId) || (is_array($templateId) && empty($templateId))) {
            unset($this->TemplateId);
        } else {
            $this->TemplateId = $templateId;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
    /**
     * Get WarningMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarningMessage()
    {
        return isset($this->WarningMessage) ? $this->WarningMessage : null;
    }
    /**
     * Set WarningMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warningMessage
     * @return \patest\StructType\BizResource_BookingScheduleView
     */
    public function setWarningMessage($warningMessage = null)
    {
        // validation for constraint: string
        if (!is_null($warningMessage) && !is_string($warningMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningMessage, true), gettype($warningMessage)), __LINE__);
        }
        if (is_null($warningMessage) || (is_array($warningMessage) && empty($warningMessage))) {
            unset($this->WarningMessage);
        } else {
            $this->WarningMessage = $warningMessage;
        }
        return $this;
    }
}
