<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BookRoomActivity StructType
 * @subpackage Structs
 */
class BizResource_BookRoomActivity extends AnyEntity
{
    /**
     * The ActivityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActivityId;
    /**
     * The CreatedMissingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CreatedMissingEvent;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Intermission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Intermission;
    /**
     * The IsFixedRoom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFixedRoom;
    /**
     * The IsFullCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullCapacity;
    /**
     * The JsonRoomList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JsonRoomList;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The OtherCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory
     */
    public $OtherCategories;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RoomCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomCategoryId;
    /**
     * The RoomId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoomId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizResource.BookRoomActivity
     * @uses BizResource_BookRoomActivity::setActivityId()
     * @uses BizResource_BookRoomActivity::setCreatedMissingEvent()
     * @uses BizResource_BookRoomActivity::setDuration()
     * @uses BizResource_BookRoomActivity::setEventId()
     * @uses BizResource_BookRoomActivity::setFromDate()
     * @uses BizResource_BookRoomActivity::setId()
     * @uses BizResource_BookRoomActivity::setIntermission()
     * @uses BizResource_BookRoomActivity::setIsFixedRoom()
     * @uses BizResource_BookRoomActivity::setIsFullCapacity()
     * @uses BizResource_BookRoomActivity::setJsonRoomList()
     * @uses BizResource_BookRoomActivity::setName()
     * @uses BizResource_BookRoomActivity::setOrder()
     * @uses BizResource_BookRoomActivity::setOtherCategories()
     * @uses BizResource_BookRoomActivity::setQuantity()
     * @uses BizResource_BookRoomActivity::setRoomCategoryId()
     * @uses BizResource_BookRoomActivity::setRoomId()
     * @uses BizResource_BookRoomActivity::setShowId()
     * @uses BizResource_BookRoomActivity::setUntilDate()
     * @param string $activityId
     * @param bool $createdMissingEvent
     * @param int $duration
     * @param string $eventId
     * @param string $fromDate
     * @param string $id
     * @param int $intermission
     * @param bool $isFixedRoom
     * @param bool $isFullCapacity
     * @param string $jsonRoomList
     * @param string $name
     * @param int $order
     * @param \patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory $otherCategories
     * @param int $quantity
     * @param string $roomCategoryId
     * @param string $roomId
     * @param string $showId
     * @param string $untilDate
     */
    public function __construct($activityId = null, $createdMissingEvent = null, $duration = null, $eventId = null, $fromDate = null, $id = null, $intermission = null, $isFixedRoom = null, $isFullCapacity = null, $jsonRoomList = null, $name = null, $order = null, \patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory $otherCategories = null, $quantity = null, $roomCategoryId = null, $roomId = null, $showId = null, $untilDate = null)
    {
        $this
            ->setActivityId($activityId)
            ->setCreatedMissingEvent($createdMissingEvent)
            ->setDuration($duration)
            ->setEventId($eventId)
            ->setFromDate($fromDate)
            ->setId($id)
            ->setIntermission($intermission)
            ->setIsFixedRoom($isFixedRoom)
            ->setIsFullCapacity($isFullCapacity)
            ->setJsonRoomList($jsonRoomList)
            ->setName($name)
            ->setOrder($order)
            ->setOtherCategories($otherCategories)
            ->setQuantity($quantity)
            ->setRoomCategoryId($roomCategoryId)
            ->setRoomId($roomId)
            ->setShowId($showId)
            ->setUntilDate($untilDate);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get CreatedMissingEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreatedMissingEvent()
    {
        return isset($this->CreatedMissingEvent) ? $this->CreatedMissingEvent : null;
    }
    /**
     * Set CreatedMissingEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createdMissingEvent
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setCreatedMissingEvent($createdMissingEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdMissingEvent) && !is_bool($createdMissingEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdMissingEvent, true), gettype($createdMissingEvent)), __LINE__);
        }
        if (is_null($createdMissingEvent) || (is_array($createdMissingEvent) && empty($createdMissingEvent))) {
            unset($this->CreatedMissingEvent);
        } else {
            $this->CreatedMissingEvent = $createdMissingEvent;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Intermission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntermission()
    {
        return isset($this->Intermission) ? $this->Intermission : null;
    }
    /**
     * Set Intermission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intermission
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setIntermission($intermission = null)
    {
        // validation for constraint: int
        if (!is_null($intermission) && !(is_int($intermission) || ctype_digit($intermission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intermission, true), gettype($intermission)), __LINE__);
        }
        if (is_null($intermission) || (is_array($intermission) && empty($intermission))) {
            unset($this->Intermission);
        } else {
            $this->Intermission = $intermission;
        }
        return $this;
    }
    /**
     * Get IsFixedRoom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFixedRoom()
    {
        return isset($this->IsFixedRoom) ? $this->IsFixedRoom : null;
    }
    /**
     * Set IsFixedRoom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFixedRoom
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setIsFixedRoom($isFixedRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFixedRoom) && !is_bool($isFixedRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFixedRoom, true), gettype($isFixedRoom)), __LINE__);
        }
        if (is_null($isFixedRoom) || (is_array($isFixedRoom) && empty($isFixedRoom))) {
            unset($this->IsFixedRoom);
        } else {
            $this->IsFixedRoom = $isFixedRoom;
        }
        return $this;
    }
    /**
     * Get IsFullCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullCapacity()
    {
        return isset($this->IsFullCapacity) ? $this->IsFullCapacity : null;
    }
    /**
     * Set IsFullCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullCapacity
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setIsFullCapacity($isFullCapacity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullCapacity) && !is_bool($isFullCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullCapacity, true), gettype($isFullCapacity)), __LINE__);
        }
        if (is_null($isFullCapacity) || (is_array($isFullCapacity) && empty($isFullCapacity))) {
            unset($this->IsFullCapacity);
        } else {
            $this->IsFullCapacity = $isFullCapacity;
        }
        return $this;
    }
    /**
     * Get JsonRoomList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJsonRoomList()
    {
        return isset($this->JsonRoomList) ? $this->JsonRoomList : null;
    }
    /**
     * Set JsonRoomList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jsonRoomList
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setJsonRoomList($jsonRoomList = null)
    {
        // validation for constraint: string
        if (!is_null($jsonRoomList) && !is_string($jsonRoomList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jsonRoomList, true), gettype($jsonRoomList)), __LINE__);
        }
        if (is_null($jsonRoomList) || (is_array($jsonRoomList) && empty($jsonRoomList))) {
            unset($this->JsonRoomList);
        } else {
            $this->JsonRoomList = $jsonRoomList;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get OtherCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory|null
     */
    public function getOtherCategories()
    {
        return isset($this->OtherCategories) ? $this->OtherCategories : null;
    }
    /**
     * Set OtherCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory $otherCategories
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setOtherCategories(\patest\StructType\RecordSetOfBizResource_BookRoomActivityCategory $otherCategories = null)
    {
        if (is_null($otherCategories) || (is_array($otherCategories) && empty($otherCategories))) {
            unset($this->OtherCategories);
        } else {
            $this->OtherCategories = $otherCategories;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RoomCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomCategoryId()
    {
        return isset($this->RoomCategoryId) ? $this->RoomCategoryId : null;
    }
    /**
     * Set RoomCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomCategoryId
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setRoomCategoryId($roomCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategoryId) && !is_string($roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCategoryId, true), gettype($roomCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomCategoryId, true)), __LINE__);
        }
        if (is_null($roomCategoryId) || (is_array($roomCategoryId) && empty($roomCategoryId))) {
            unset($this->RoomCategoryId);
        } else {
            $this->RoomCategoryId = $roomCategoryId;
        }
        return $this;
    }
    /**
     * Get RoomId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomId()
    {
        return isset($this->RoomId) ? $this->RoomId : null;
    }
    /**
     * Set RoomId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomId
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setRoomId($roomId = null)
    {
        // validation for constraint: string
        if (!is_null($roomId) && !is_string($roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomId, true), gettype($roomId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roomId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roomId, true)), __LINE__);
        }
        if (is_null($roomId) || (is_array($roomId) && empty($roomId))) {
            unset($this->RoomId);
        } else {
            $this->RoomId = $roomId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizResource_BookRoomActivity
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
