<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.BillingItem StructType
 * @subpackage Structs
 */
class BizResource_BillingItem extends BizResource_PersistableEntityBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The BackwardTransaction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransaction;
    /**
     * The BillDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillDate;
    /**
     * The IsValidForBilling
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValidForBilling;
    /**
     * The MerchandiseItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemTypeId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderId;
    /**
     * The OrderItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderItemId;
    /**
     * The OrderPartId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderPartId;
    /**
     * The PayerAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayerAccountId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Transaction;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UpdatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UpdatedAmount;
    /**
     * Constructor method for BizResource.BillingItem
     * @uses BizResource_BillingItem::setAmount()
     * @uses BizResource_BillingItem::setBackwardTransaction()
     * @uses BizResource_BillingItem::setBillDate()
     * @uses BizResource_BillingItem::setIsValidForBilling()
     * @uses BizResource_BillingItem::setMerchandiseItemTypeId()
     * @uses BizResource_BillingItem::setOrderId()
     * @uses BizResource_BillingItem::setOrderItemId()
     * @uses BizResource_BillingItem::setOrderPartId()
     * @uses BizResource_BillingItem::setPayerAccountId()
     * @uses BizResource_BillingItem::setStatus()
     * @uses BizResource_BillingItem::setTransaction()
     * @uses BizResource_BillingItem::setType()
     * @uses BizResource_BillingItem::setUpdatedAmount()
     * @param float $amount
     * @param string $backwardTransaction
     * @param string $billDate
     * @param bool $isValidForBilling
     * @param string $merchandiseItemTypeId
     * @param string $orderId
     * @param string $orderItemId
     * @param string $orderPartId
     * @param string $payerAccountId
     * @param string $status
     * @param string $transaction
     * @param string $type
     * @param float $updatedAmount
     */
    public function __construct($amount = null, $backwardTransaction = null, $billDate = null, $isValidForBilling = null, $merchandiseItemTypeId = null, $orderId = null, $orderItemId = null, $orderPartId = null, $payerAccountId = null, $status = null, $transaction = null, $type = null, $updatedAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setBackwardTransaction($backwardTransaction)
            ->setBillDate($billDate)
            ->setIsValidForBilling($isValidForBilling)
            ->setMerchandiseItemTypeId($merchandiseItemTypeId)
            ->setOrderId($orderId)
            ->setOrderItemId($orderItemId)
            ->setOrderPartId($orderPartId)
            ->setPayerAccountId($payerAccountId)
            ->setStatus($status)
            ->setTransaction($transaction)
            ->setType($type)
            ->setUpdatedAmount($updatedAmount);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransaction()
    {
        return isset($this->BackwardTransaction) ? $this->BackwardTransaction : null;
    }
    /**
     * Set BackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransaction
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setBackwardTransaction($backwardTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransaction) && !is_string($backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransaction, true), gettype($backwardTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransaction, true)), __LINE__);
        }
        if (is_null($backwardTransaction) || (is_array($backwardTransaction) && empty($backwardTransaction))) {
            unset($this->BackwardTransaction);
        } else {
            $this->BackwardTransaction = $backwardTransaction;
        }
        return $this;
    }
    /**
     * Get BillDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillDate()
    {
        return isset($this->BillDate) ? $this->BillDate : null;
    }
    /**
     * Set BillDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billDate
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDate, true), gettype($billDate)), __LINE__);
        }
        if (is_null($billDate) || (is_array($billDate) && empty($billDate))) {
            unset($this->BillDate);
        } else {
            $this->BillDate = $billDate;
        }
        return $this;
    }
    /**
     * Get IsValidForBilling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValidForBilling()
    {
        return isset($this->IsValidForBilling) ? $this->IsValidForBilling : null;
    }
    /**
     * Set IsValidForBilling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValidForBilling
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setIsValidForBilling($isValidForBilling = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValidForBilling) && !is_bool($isValidForBilling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValidForBilling, true), gettype($isValidForBilling)), __LINE__);
        }
        if (is_null($isValidForBilling) || (is_array($isValidForBilling) && empty($isValidForBilling))) {
            unset($this->IsValidForBilling);
        } else {
            $this->IsValidForBilling = $isValidForBilling;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseItemTypeId()
    {
        return isset($this->MerchandiseItemTypeId) ? $this->MerchandiseItemTypeId : null;
    }
    /**
     * Set MerchandiseItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseItemTypeId
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setMerchandiseItemTypeId($merchandiseItemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemTypeId) && !is_string($merchandiseItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemTypeId, true), gettype($merchandiseItemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemTypeId, true)), __LINE__);
        }
        if (is_null($merchandiseItemTypeId) || (is_array($merchandiseItemTypeId) && empty($merchandiseItemTypeId))) {
            unset($this->MerchandiseItemTypeId);
        } else {
            $this->MerchandiseItemTypeId = $merchandiseItemTypeId;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get OrderItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderItemId()
    {
        return isset($this->OrderItemId) ? $this->OrderItemId : null;
    }
    /**
     * Set OrderItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderItemId
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setOrderItemId($orderItemId = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemId) && !is_string($orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemId, true), gettype($orderItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderItemId, true)), __LINE__);
        }
        if (is_null($orderItemId) || (is_array($orderItemId) && empty($orderItemId))) {
            unset($this->OrderItemId);
        } else {
            $this->OrderItemId = $orderItemId;
        }
        return $this;
    }
    /**
     * Get OrderPartId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderPartId()
    {
        return isset($this->OrderPartId) ? $this->OrderPartId : null;
    }
    /**
     * Set OrderPartId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderPartId
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setOrderPartId($orderPartId = null)
    {
        // validation for constraint: string
        if (!is_null($orderPartId) && !is_string($orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderPartId, true), gettype($orderPartId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderPartId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderPartId, true)), __LINE__);
        }
        if (is_null($orderPartId) || (is_array($orderPartId) && empty($orderPartId))) {
            unset($this->OrderPartId);
        } else {
            $this->OrderPartId = $orderPartId;
        }
        return $this;
    }
    /**
     * Get PayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccountId()
    {
        return isset($this->PayerAccountId) ? $this->PayerAccountId : null;
    }
    /**
     * Set PayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccountId
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setPayerAccountId($payerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccountId) && !is_string($payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccountId, true), gettype($payerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payerAccountId, true)), __LINE__);
        }
        if (is_null($payerAccountId) || (is_array($payerAccountId) && empty($payerAccountId))) {
            unset($this->PayerAccountId);
        } else {
            $this->PayerAccountId = $payerAccountId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BillingItemStatus::valueIsValid()
     * @uses \patest\EnumType\BillingItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BillingItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BillingItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BillingItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transaction
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: string
        if (!is_null($transaction) && !is_string($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction, true), gettype($transaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transaction, true)), __LINE__);
        }
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BillingItemType::valueIsValid()
     * @uses \patest\EnumType\BillingItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BillingItemType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BillingItemType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\BillingItemType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UpdatedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUpdatedAmount()
    {
        return isset($this->UpdatedAmount) ? $this->UpdatedAmount : null;
    }
    /**
     * Set UpdatedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $updatedAmount
     * @return \patest\StructType\BizResource_BillingItem
     */
    public function setUpdatedAmount($updatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($updatedAmount) && !(is_float($updatedAmount) || is_numeric($updatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($updatedAmount, true), gettype($updatedAmount)), __LINE__);
        }
        if (is_null($updatedAmount) || (is_array($updatedAmount) && empty($updatedAmount))) {
            unset($this->UpdatedAmount);
        } else {
            $this->UpdatedAmount = $updatedAmount;
        }
        return $this;
    }
}
