<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizResource.AllocatedCalendar StructType
 * @subpackage Structs
 */
class BizResource_AllocatedCalendar extends BizResource_PersistableEntityBase
{
    /**
     * The CalendarId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CalendarId;
    /**
     * The CalendarLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalendarLevel;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * Constructor method for BizResource.AllocatedCalendar
     * @uses BizResource_AllocatedCalendar::setCalendarId()
     * @uses BizResource_AllocatedCalendar::setCalendarLevel()
     * @uses BizResource_AllocatedCalendar::setOwnerId()
     * @param string $calendarId
     * @param string $calendarLevel
     * @param string $ownerId
     */
    public function __construct($calendarId = null, $calendarLevel = null, $ownerId = null)
    {
        $this
            ->setCalendarId($calendarId)
            ->setCalendarLevel($calendarLevel)
            ->setOwnerId($ownerId);
    }
    /**
     * Get CalendarId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarId()
    {
        return isset($this->CalendarId) ? $this->CalendarId : null;
    }
    /**
     * Set CalendarId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calendarId
     * @return \patest\StructType\BizResource_AllocatedCalendar
     */
    public function setCalendarId($calendarId = null)
    {
        // validation for constraint: string
        if (!is_null($calendarId) && !is_string($calendarId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendarId, true), gettype($calendarId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($calendarId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $calendarId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($calendarId, true)), __LINE__);
        }
        if (is_null($calendarId) || (is_array($calendarId) && empty($calendarId))) {
            unset($this->CalendarId);
        } else {
            $this->CalendarId = $calendarId;
        }
        return $this;
    }
    /**
     * Get CalendarLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarLevel()
    {
        return isset($this->CalendarLevel) ? $this->CalendarLevel : null;
    }
    /**
     * Set CalendarLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CalendarLevel::valueIsValid()
     * @uses \patest\EnumType\CalendarLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarLevel
     * @return \patest\StructType\BizResource_AllocatedCalendar
     */
    public function setCalendarLevel($calendarLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CalendarLevel::valueIsValid($calendarLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CalendarLevel', is_array($calendarLevel) ? implode(', ', $calendarLevel) : var_export($calendarLevel, true), implode(', ', \patest\EnumType\CalendarLevel::getValidValues())), __LINE__);
        }
        if (is_null($calendarLevel) || (is_array($calendarLevel) && empty($calendarLevel))) {
            unset($this->CalendarLevel);
        } else {
            $this->CalendarLevel = $calendarLevel;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\BizResource_AllocatedCalendar
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
}
