<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.UI.SetPrioritiesEntity StructType
 * @subpackage Structs
 */
class BizAction_UI_SetPrioritiesEntity extends AnyEntity
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OriginalOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OriginalOrdinal;
    /**
     * Constructor method for BizAction.UI.SetPrioritiesEntity
     * @uses BizAction_UI_SetPrioritiesEntity::setId()
     * @uses BizAction_UI_SetPrioritiesEntity::setIsActive()
     * @uses BizAction_UI_SetPrioritiesEntity::setName()
     * @uses BizAction_UI_SetPrioritiesEntity::setOrdinal()
     * @uses BizAction_UI_SetPrioritiesEntity::setOriginalOrdinal()
     * @param string $id
     * @param bool $isActive
     * @param string $name
     * @param int $ordinal
     * @param int $originalOrdinal
     */
    public function __construct($id = null, $isActive = null, $name = null, $ordinal = null, $originalOrdinal = null)
    {
        $this
            ->setId($id)
            ->setIsActive($isActive)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setOriginalOrdinal($originalOrdinal);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\BizAction_UI_SetPrioritiesEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\BizAction_UI_SetPrioritiesEntity
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizAction_UI_SetPrioritiesEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\BizAction_UI_SetPrioritiesEntity
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OriginalOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOriginalOrdinal()
    {
        return isset($this->OriginalOrdinal) ? $this->OriginalOrdinal : null;
    }
    /**
     * Set OriginalOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $originalOrdinal
     * @return \patest\StructType\BizAction_UI_SetPrioritiesEntity
     */
    public function setOriginalOrdinal($originalOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($originalOrdinal) && !(is_int($originalOrdinal) || ctype_digit($originalOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalOrdinal, true), gettype($originalOrdinal)), __LINE__);
        }
        if (is_null($originalOrdinal) || (is_array($originalOrdinal) && empty($originalOrdinal))) {
            unset($this->OriginalOrdinal);
        } else {
            $this->OriginalOrdinal = $originalOrdinal;
        }
        return $this;
    }
}
