<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.TicketAction.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_TicketAction_Request extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIds;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsInClientCustody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInClientCustody;
    /**
     * The KeepItemsBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepItemsBarcode;
    /**
     * The KeepOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOnCard;
    /**
     * The NewOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwner;
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $NewPrice;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * The PrintItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintItems;
    /**
     * The RepriceTicketsScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RepriceTicketsScenario;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatus;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Ticket
     */
    public $Tickets;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UsePrintedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsePrintedTickets;
    /**
     * Constructor method for BizAction.Ticketing.TicketAction.Request
     * @uses BizAction_Ticketing_TicketAction_Request::setAction()
     * @uses BizAction_Ticketing_TicketAction_Request::setClientId()
     * @uses BizAction_Ticketing_TicketAction_Request::setClientIds()
     * @uses BizAction_Ticketing_TicketAction_Request::setEventId()
     * @uses BizAction_Ticketing_TicketAction_Request::setIsInClientCustody()
     * @uses BizAction_Ticketing_TicketAction_Request::setKeepItemsBarcode()
     * @uses BizAction_Ticketing_TicketAction_Request::setKeepOnCard()
     * @uses BizAction_Ticketing_TicketAction_Request::setNewOwner()
     * @uses BizAction_Ticketing_TicketAction_Request::setNewPrice()
     * @uses BizAction_Ticketing_TicketAction_Request::setNewPriceType()
     * @uses BizAction_Ticketing_TicketAction_Request::setPrintItems()
     * @uses BizAction_Ticketing_TicketAction_Request::setRepriceTicketsScenario()
     * @uses BizAction_Ticketing_TicketAction_Request::setReservationExpiryDate()
     * @uses BizAction_Ticketing_TicketAction_Request::setSaleStatus()
     * @uses BizAction_Ticketing_TicketAction_Request::setTickets()
     * @uses BizAction_Ticketing_TicketAction_Request::setTicketType()
     * @uses BizAction_Ticketing_TicketAction_Request::setTransactionGuid()
     * @uses BizAction_Ticketing_TicketAction_Request::setUsePrintedTickets()
     * @param string $action
     * @param string $clientId
     * @param string $clientIds
     * @param string $eventId
     * @param bool $isInClientCustody
     * @param bool $keepItemsBarcode
     * @param bool $keepOnCard
     * @param string $newOwner
     * @param \patest\StructType\Money $newPrice
     * @param string $newPriceType
     * @param bool $printItems
     * @param string $repriceTicketsScenario
     * @param string $reservationExpiryDate
     * @param string $saleStatus
     * @param \patest\StructType\RecordSetOfTicketing_Ticket $tickets
     * @param string $ticketType
     * @param string $transactionGuid
     * @param string $usePrintedTickets
     */
    public function __construct($action = null, $clientId = null, $clientIds = null, $eventId = null, $isInClientCustody = null, $keepItemsBarcode = null, $keepOnCard = null, $newOwner = null, \patest\StructType\Money $newPrice = null, $newPriceType = null, $printItems = null, $repriceTicketsScenario = null, $reservationExpiryDate = null, $saleStatus = null, \patest\StructType\RecordSetOfTicketing_Ticket $tickets = null, $ticketType = null, $transactionGuid = null, $usePrintedTickets = null)
    {
        $this
            ->setAction($action)
            ->setClientId($clientId)
            ->setClientIds($clientIds)
            ->setEventId($eventId)
            ->setIsInClientCustody($isInClientCustody)
            ->setKeepItemsBarcode($keepItemsBarcode)
            ->setKeepOnCard($keepOnCard)
            ->setNewOwner($newOwner)
            ->setNewPrice($newPrice)
            ->setNewPriceType($newPriceType)
            ->setPrintItems($printItems)
            ->setRepriceTicketsScenario($repriceTicketsScenario)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setSaleStatus($saleStatus)
            ->setTickets($tickets)
            ->setTicketType($ticketType)
            ->setTransactionGuid($transactionGuid)
            ->setUsePrintedTickets($usePrintedTickets);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketAction::valueIsValid()
     * @uses \patest\EnumType\TicketAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\TicketAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIds
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setClientIds($clientIds = null)
    {
        // validation for constraint: string
        if (!is_null($clientIds) && !is_string($clientIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIds, true), gettype($clientIds)), __LINE__);
        }
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IsInClientCustody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInClientCustody()
    {
        return isset($this->IsInClientCustody) ? $this->IsInClientCustody : null;
    }
    /**
     * Set IsInClientCustody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInClientCustody
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setIsInClientCustody($isInClientCustody = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInClientCustody) && !is_bool($isInClientCustody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInClientCustody, true), gettype($isInClientCustody)), __LINE__);
        }
        if (is_null($isInClientCustody) || (is_array($isInClientCustody) && empty($isInClientCustody))) {
            unset($this->IsInClientCustody);
        } else {
            $this->IsInClientCustody = $isInClientCustody;
        }
        return $this;
    }
    /**
     * Get KeepItemsBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepItemsBarcode()
    {
        return isset($this->KeepItemsBarcode) ? $this->KeepItemsBarcode : null;
    }
    /**
     * Set KeepItemsBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepItemsBarcode
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setKeepItemsBarcode($keepItemsBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepItemsBarcode) && !is_bool($keepItemsBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepItemsBarcode, true), gettype($keepItemsBarcode)), __LINE__);
        }
        if (is_null($keepItemsBarcode) || (is_array($keepItemsBarcode) && empty($keepItemsBarcode))) {
            unset($this->KeepItemsBarcode);
        } else {
            $this->KeepItemsBarcode = $keepItemsBarcode;
        }
        return $this;
    }
    /**
     * Get KeepOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOnCard()
    {
        return isset($this->KeepOnCard) ? $this->KeepOnCard : null;
    }
    /**
     * Set KeepOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOnCard
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setKeepOnCard($keepOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOnCard) && !is_bool($keepOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOnCard, true), gettype($keepOnCard)), __LINE__);
        }
        if (is_null($keepOnCard) || (is_array($keepOnCard) && empty($keepOnCard))) {
            unset($this->KeepOnCard);
        } else {
            $this->KeepOnCard = $keepOnCard;
        }
        return $this;
    }
    /**
     * Get NewOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwner()
    {
        return isset($this->NewOwner) ? $this->NewOwner : null;
    }
    /**
     * Set NewOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwner
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setNewOwner($newOwner = null)
    {
        // validation for constraint: string
        if (!is_null($newOwner) && !is_string($newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwner, true), gettype($newOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwner, true)), __LINE__);
        }
        if (is_null($newOwner) || (is_array($newOwner) && empty($newOwner))) {
            unset($this->NewOwner);
        } else {
            $this->NewOwner = $newOwner;
        }
        return $this;
    }
    /**
     * Get NewPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getNewPrice()
    {
        return isset($this->NewPrice) ? $this->NewPrice : null;
    }
    /**
     * Set NewPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $newPrice
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setNewPrice(\patest\StructType\Money $newPrice = null)
    {
        if (is_null($newPrice) || (is_array($newPrice) && empty($newPrice))) {
            unset($this->NewPrice);
        } else {
            $this->NewPrice = $newPrice;
        }
        return $this;
    }
    /**
     * Get NewPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceType()
    {
        return isset($this->NewPriceType) ? $this->NewPriceType : null;
    }
    /**
     * Set NewPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceType
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        if (is_null($newPriceType) || (is_array($newPriceType) && empty($newPriceType))) {
            unset($this->NewPriceType);
        } else {
            $this->NewPriceType = $newPriceType;
        }
        return $this;
    }
    /**
     * Get PrintItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintItems()
    {
        return isset($this->PrintItems) ? $this->PrintItems : null;
    }
    /**
     * Set PrintItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printItems
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setPrintItems($printItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItems) && !is_bool($printItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItems, true), gettype($printItems)), __LINE__);
        }
        if (is_null($printItems) || (is_array($printItems) && empty($printItems))) {
            unset($this->PrintItems);
        } else {
            $this->PrintItems = $printItems;
        }
        return $this;
    }
    /**
     * Get RepriceTicketsScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepriceTicketsScenario()
    {
        return isset($this->RepriceTicketsScenario) ? $this->RepriceTicketsScenario : null;
    }
    /**
     * Set RepriceTicketsScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RepriceTicketsScenario::valueIsValid()
     * @uses \patest\EnumType\RepriceTicketsScenario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repriceTicketsScenario
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setRepriceTicketsScenario($repriceTicketsScenario = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RepriceTicketsScenario::valueIsValid($repriceTicketsScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RepriceTicketsScenario', is_array($repriceTicketsScenario) ? implode(', ', $repriceTicketsScenario) : var_export($repriceTicketsScenario, true), implode(', ', \patest\EnumType\RepriceTicketsScenario::getValidValues())), __LINE__);
        }
        if (is_null($repriceTicketsScenario) || (is_array($repriceTicketsScenario) && empty($repriceTicketsScenario))) {
            unset($this->RepriceTicketsScenario);
        } else {
            $this->RepriceTicketsScenario = $repriceTicketsScenario;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSaleStatus::valueIsValid()
     * @uses \patest\EnumType\TicketSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatus
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSaleStatus::valueIsValid($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSaleStatus', is_array($saleStatus) ? implode(', ', $saleStatus) : var_export($saleStatus, true), implode(', ', \patest\EnumType\TicketSaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = $saleStatus;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Ticket|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Ticket $tickets
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setTickets(\patest\StructType\RecordSetOfTicketing_Ticket $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSummaryType::valueIsValid()
     * @uses \patest\EnumType\TicketSummaryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSummaryType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSummaryType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \patest\EnumType\TicketSummaryType::getValidValues())), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UsePrintedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsePrintedTickets()
    {
        return isset($this->UsePrintedTickets) ? $this->UsePrintedTickets : null;
    }
    /**
     * Set UsePrintedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UsePrintedTickets::valueIsValid()
     * @uses \patest\EnumType\UsePrintedTickets::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usePrintedTickets
     * @return \patest\StructType\BizAction_Ticketing_TicketAction_Request
     */
    public function setUsePrintedTickets($usePrintedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UsePrintedTickets::valueIsValid($usePrintedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UsePrintedTickets', is_array($usePrintedTickets) ? implode(', ', $usePrintedTickets) : var_export($usePrintedTickets, true), implode(', ', \patest\EnumType\UsePrintedTickets::getValidValues())), __LINE__);
        }
        if (is_null($usePrintedTickets) || (is_array($usePrintedTickets) && empty($usePrintedTickets))) {
            unset($this->UsePrintedTickets);
        } else {
            $this->UsePrintedTickets = $usePrintedTickets;
        }
        return $this;
    }
}
