<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SwitchHalls.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SwitchHalls_Request extends AnyEntity
{
    /**
     * The EventDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateTime;
    /**
     * The EventEndDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventEndDateTime;
    /**
     * The EventHallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventHallId;
    /**
     * The EventHallNameAndCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventHallNameAndCapacity;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventLocalId;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The EventOccupiedAndRestrictedSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventOccupiedAndRestrictedSeatCount;
    /**
     * The EventOccupiedSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventOccupiedSeatCount;
    /**
     * The EventSeatCountInExlusiveRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventSeatCountInExlusiveRestrictions;
    /**
     * The RelevantHallIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelevantHallIds;
    /**
     * The SwitchHallsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo
     */
    public $SwitchHallsInfo;
    /**
     * Constructor method for BizAction.Ticketing.SwitchHalls.Request
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventDateTime()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventEndDateTime()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventHallId()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventHallNameAndCapacity()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventId()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventLocalId()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventName()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventOccupiedAndRestrictedSeatCount()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventOccupiedSeatCount()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setEventSeatCountInExlusiveRestrictions()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setRelevantHallIds()
     * @uses BizAction_Ticketing_SwitchHalls_Request::setSwitchHallsInfo()
     * @param string $eventDateTime
     * @param string $eventEndDateTime
     * @param string $eventHallId
     * @param string $eventHallNameAndCapacity
     * @param string $eventId
     * @param int $eventLocalId
     * @param string $eventName
     * @param int $eventOccupiedAndRestrictedSeatCount
     * @param int $eventOccupiedSeatCount
     * @param int $eventSeatCountInExlusiveRestrictions
     * @param string $relevantHallIds
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo $switchHallsInfo
     */
    public function __construct($eventDateTime = null, $eventEndDateTime = null, $eventHallId = null, $eventHallNameAndCapacity = null, $eventId = null, $eventLocalId = null, $eventName = null, $eventOccupiedAndRestrictedSeatCount = null, $eventOccupiedSeatCount = null, $eventSeatCountInExlusiveRestrictions = null, $relevantHallIds = null, \patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo $switchHallsInfo = null)
    {
        $this
            ->setEventDateTime($eventDateTime)
            ->setEventEndDateTime($eventEndDateTime)
            ->setEventHallId($eventHallId)
            ->setEventHallNameAndCapacity($eventHallNameAndCapacity)
            ->setEventId($eventId)
            ->setEventLocalId($eventLocalId)
            ->setEventName($eventName)
            ->setEventOccupiedAndRestrictedSeatCount($eventOccupiedAndRestrictedSeatCount)
            ->setEventOccupiedSeatCount($eventOccupiedSeatCount)
            ->setEventSeatCountInExlusiveRestrictions($eventSeatCountInExlusiveRestrictions)
            ->setRelevantHallIds($relevantHallIds)
            ->setSwitchHallsInfo($switchHallsInfo);
    }
    /**
     * Get EventDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateTime()
    {
        return isset($this->EventDateTime) ? $this->EventDateTime : null;
    }
    /**
     * Set EventDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateTime
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventDateTime($eventDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTime) && !is_string($eventDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTime, true), gettype($eventDateTime)), __LINE__);
        }
        if (is_null($eventDateTime) || (is_array($eventDateTime) && empty($eventDateTime))) {
            unset($this->EventDateTime);
        } else {
            $this->EventDateTime = $eventDateTime;
        }
        return $this;
    }
    /**
     * Get EventEndDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventEndDateTime()
    {
        return isset($this->EventEndDateTime) ? $this->EventEndDateTime : null;
    }
    /**
     * Set EventEndDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventEndDateTime
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventEndDateTime($eventEndDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDateTime) && !is_string($eventEndDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDateTime, true), gettype($eventEndDateTime)), __LINE__);
        }
        if (is_null($eventEndDateTime) || (is_array($eventEndDateTime) && empty($eventEndDateTime))) {
            unset($this->EventEndDateTime);
        } else {
            $this->EventEndDateTime = $eventEndDateTime;
        }
        return $this;
    }
    /**
     * Get EventHallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHallId()
    {
        return isset($this->EventHallId) ? $this->EventHallId : null;
    }
    /**
     * Set EventHallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHallId
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventHallId($eventHallId = null)
    {
        // validation for constraint: string
        if (!is_null($eventHallId) && !is_string($eventHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHallId, true), gettype($eventHallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventHallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventHallId, true)), __LINE__);
        }
        if (is_null($eventHallId) || (is_array($eventHallId) && empty($eventHallId))) {
            unset($this->EventHallId);
        } else {
            $this->EventHallId = $eventHallId;
        }
        return $this;
    }
    /**
     * Get EventHallNameAndCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHallNameAndCapacity()
    {
        return isset($this->EventHallNameAndCapacity) ? $this->EventHallNameAndCapacity : null;
    }
    /**
     * Set EventHallNameAndCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHallNameAndCapacity
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventHallNameAndCapacity($eventHallNameAndCapacity = null)
    {
        // validation for constraint: string
        if (!is_null($eventHallNameAndCapacity) && !is_string($eventHallNameAndCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHallNameAndCapacity, true), gettype($eventHallNameAndCapacity)), __LINE__);
        }
        if (is_null($eventHallNameAndCapacity) || (is_array($eventHallNameAndCapacity) && empty($eventHallNameAndCapacity))) {
            unset($this->EventHallNameAndCapacity);
        } else {
            $this->EventHallNameAndCapacity = $eventHallNameAndCapacity;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventLocalId()
    {
        return isset($this->EventLocalId) ? $this->EventLocalId : null;
    }
    /**
     * Set EventLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventLocalId
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventLocalId($eventLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($eventLocalId) && !(is_int($eventLocalId) || ctype_digit($eventLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventLocalId, true), gettype($eventLocalId)), __LINE__);
        }
        if (is_null($eventLocalId) || (is_array($eventLocalId) && empty($eventLocalId))) {
            unset($this->EventLocalId);
        } else {
            $this->EventLocalId = $eventLocalId;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get EventOccupiedAndRestrictedSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventOccupiedAndRestrictedSeatCount()
    {
        return isset($this->EventOccupiedAndRestrictedSeatCount) ? $this->EventOccupiedAndRestrictedSeatCount : null;
    }
    /**
     * Set EventOccupiedAndRestrictedSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventOccupiedAndRestrictedSeatCount
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventOccupiedAndRestrictedSeatCount($eventOccupiedAndRestrictedSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventOccupiedAndRestrictedSeatCount) && !(is_int($eventOccupiedAndRestrictedSeatCount) || ctype_digit($eventOccupiedAndRestrictedSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventOccupiedAndRestrictedSeatCount, true), gettype($eventOccupiedAndRestrictedSeatCount)), __LINE__);
        }
        if (is_null($eventOccupiedAndRestrictedSeatCount) || (is_array($eventOccupiedAndRestrictedSeatCount) && empty($eventOccupiedAndRestrictedSeatCount))) {
            unset($this->EventOccupiedAndRestrictedSeatCount);
        } else {
            $this->EventOccupiedAndRestrictedSeatCount = $eventOccupiedAndRestrictedSeatCount;
        }
        return $this;
    }
    /**
     * Get EventOccupiedSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventOccupiedSeatCount()
    {
        return isset($this->EventOccupiedSeatCount) ? $this->EventOccupiedSeatCount : null;
    }
    /**
     * Set EventOccupiedSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventOccupiedSeatCount
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventOccupiedSeatCount($eventOccupiedSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventOccupiedSeatCount) && !(is_int($eventOccupiedSeatCount) || ctype_digit($eventOccupiedSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventOccupiedSeatCount, true), gettype($eventOccupiedSeatCount)), __LINE__);
        }
        if (is_null($eventOccupiedSeatCount) || (is_array($eventOccupiedSeatCount) && empty($eventOccupiedSeatCount))) {
            unset($this->EventOccupiedSeatCount);
        } else {
            $this->EventOccupiedSeatCount = $eventOccupiedSeatCount;
        }
        return $this;
    }
    /**
     * Get EventSeatCountInExlusiveRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventSeatCountInExlusiveRestrictions()
    {
        return isset($this->EventSeatCountInExlusiveRestrictions) ? $this->EventSeatCountInExlusiveRestrictions : null;
    }
    /**
     * Set EventSeatCountInExlusiveRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventSeatCountInExlusiveRestrictions
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setEventSeatCountInExlusiveRestrictions($eventSeatCountInExlusiveRestrictions = null)
    {
        // validation for constraint: int
        if (!is_null($eventSeatCountInExlusiveRestrictions) && !(is_int($eventSeatCountInExlusiveRestrictions) || ctype_digit($eventSeatCountInExlusiveRestrictions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventSeatCountInExlusiveRestrictions, true), gettype($eventSeatCountInExlusiveRestrictions)), __LINE__);
        }
        if (is_null($eventSeatCountInExlusiveRestrictions) || (is_array($eventSeatCountInExlusiveRestrictions) && empty($eventSeatCountInExlusiveRestrictions))) {
            unset($this->EventSeatCountInExlusiveRestrictions);
        } else {
            $this->EventSeatCountInExlusiveRestrictions = $eventSeatCountInExlusiveRestrictions;
        }
        return $this;
    }
    /**
     * Get RelevantHallIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelevantHallIds()
    {
        return isset($this->RelevantHallIds) ? $this->RelevantHallIds : null;
    }
    /**
     * Set RelevantHallIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relevantHallIds
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setRelevantHallIds($relevantHallIds = null)
    {
        // validation for constraint: string
        if (!is_null($relevantHallIds) && !is_string($relevantHallIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantHallIds, true), gettype($relevantHallIds)), __LINE__);
        }
        if (is_null($relevantHallIds) || (is_array($relevantHallIds) && empty($relevantHallIds))) {
            unset($this->RelevantHallIds);
        } else {
            $this->RelevantHallIds = $relevantHallIds;
        }
        return $this;
    }
    /**
     * Get SwitchHallsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo|null
     */
    public function getSwitchHallsInfo()
    {
        return isset($this->SwitchHallsInfo) ? $this->SwitchHallsInfo : null;
    }
    /**
     * Set SwitchHallsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo $switchHallsInfo
     * @return \patest\StructType\BizAction_Ticketing_SwitchHalls_Request
     */
    public function setSwitchHallsInfo(\patest\StructType\RecordSetOfBizAction_Ticketing_SwitchHalls_Request_SwitchHallInfo $switchHallsInfo = null)
    {
        if (is_null($switchHallsInfo) || (is_array($switchHallsInfo) && empty($switchHallsInfo))) {
            unset($this->SwitchHallsInfo);
        } else {
            $this->SwitchHallsInfo = $switchHallsInfo;
        }
        return $this;
    }
}
