<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.SetMultipleSeriesExchangePolicies.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The AllowExchangesForUnpaidTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowExchangesForUnpaidTickets;
    /**
     * The DefaultSeatgeekAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSeatgeekAllocationTypeId;
    /**
     * The ExchangeEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExchangeEnabled;
    /**
     * The ExchangeTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeTarget;
    /**
     * The LimitNumOfFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LimitNumOfFullStackExchanges;
    /**
     * The MaxAllowedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedFullStackExchanges;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIds
     */
    public $SeriesIds;
    /**
     * The UpdateSubscriptionInstances
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpdateSubscriptionInstances;
    /**
     * Constructor method for
     * BizAction.Ticketing.SetMultipleSeriesExchangePolicies.Request
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setAccessPermissions()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setAllowExchangesForUnpaidTickets()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setDefaultSeatgeekAllocationTypeId()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setExchangeEnabled()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setExchangeTarget()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setLimitNumOfFullStackExchanges()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setMaxAllowedFullStackExchanges()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setMode()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setSeriesIds()
     * @uses BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request::setUpdateSubscriptionInstances()
     * @param string[] $accessPermissions
     * @param bool $allowExchangesForUnpaidTickets
     * @param string $defaultSeatgeekAllocationTypeId
     * @param bool $exchangeEnabled
     * @param string $exchangeTarget
     * @param bool $limitNumOfFullStackExchanges
     * @param int $maxAllowedFullStackExchanges
     * @param string $mode
     * @param \patest\StructType\SeriesIds $seriesIds
     * @param bool $updateSubscriptionInstances
     */
    public function __construct(array $accessPermissions = array(), $allowExchangesForUnpaidTickets = null, $defaultSeatgeekAllocationTypeId = null, $exchangeEnabled = null, $exchangeTarget = null, $limitNumOfFullStackExchanges = null, $maxAllowedFullStackExchanges = null, $mode = null, \patest\StructType\SeriesIds $seriesIds = null, $updateSubscriptionInstances = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setAllowExchangesForUnpaidTickets($allowExchangesForUnpaidTickets)
            ->setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId)
            ->setExchangeEnabled($exchangeEnabled)
            ->setExchangeTarget($exchangeTarget)
            ->setLimitNumOfFullStackExchanges($limitNumOfFullStackExchanges)
            ->setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges)
            ->setMode($mode)
            ->setSeriesIds($seriesIds)
            ->setUpdateSubscriptionInstances($updateSubscriptionInstances);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem) ? get_class($bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem), var_export($bizAction_Ticketing_SetMultipleSeriesExchangePolicies_RequestAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get AllowExchangesForUnpaidTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowExchangesForUnpaidTickets()
    {
        return isset($this->AllowExchangesForUnpaidTickets) ? $this->AllowExchangesForUnpaidTickets : null;
    }
    /**
     * Set AllowExchangesForUnpaidTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowExchangesForUnpaidTickets
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setAllowExchangesForUnpaidTickets($allowExchangesForUnpaidTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowExchangesForUnpaidTickets) && !is_bool($allowExchangesForUnpaidTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowExchangesForUnpaidTickets, true), gettype($allowExchangesForUnpaidTickets)), __LINE__);
        }
        if (is_null($allowExchangesForUnpaidTickets) || (is_array($allowExchangesForUnpaidTickets) && empty($allowExchangesForUnpaidTickets))) {
            unset($this->AllowExchangesForUnpaidTickets);
        } else {
            $this->AllowExchangesForUnpaidTickets = $allowExchangesForUnpaidTickets;
        }
        return $this;
    }
    /**
     * Get DefaultSeatgeekAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeatgeekAllocationTypeId()
    {
        return isset($this->DefaultSeatgeekAllocationTypeId) ? $this->DefaultSeatgeekAllocationTypeId : null;
    }
    /**
     * Set DefaultSeatgeekAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSeatgeekAllocationTypeId
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSeatgeekAllocationTypeId) && !is_string($defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSeatgeekAllocationTypeId, true), gettype($defaultSeatgeekAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSeatgeekAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSeatgeekAllocationTypeId, true)), __LINE__);
        }
        if (is_null($defaultSeatgeekAllocationTypeId) || (is_array($defaultSeatgeekAllocationTypeId) && empty($defaultSeatgeekAllocationTypeId))) {
            unset($this->DefaultSeatgeekAllocationTypeId);
        } else {
            $this->DefaultSeatgeekAllocationTypeId = $defaultSeatgeekAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get ExchangeEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExchangeEnabled()
    {
        return isset($this->ExchangeEnabled) ? $this->ExchangeEnabled : null;
    }
    /**
     * Set ExchangeEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exchangeEnabled
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setExchangeEnabled($exchangeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeEnabled) && !is_bool($exchangeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeEnabled, true), gettype($exchangeEnabled)), __LINE__);
        }
        if (is_null($exchangeEnabled) || (is_array($exchangeEnabled) && empty($exchangeEnabled))) {
            unset($this->ExchangeEnabled);
        } else {
            $this->ExchangeEnabled = $exchangeEnabled;
        }
        return $this;
    }
    /**
     * Get ExchangeTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeTarget()
    {
        return isset($this->ExchangeTarget) ? $this->ExchangeTarget : null;
    }
    /**
     * Set ExchangeTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketExchangeTarget::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketExchangeTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exchangeTarget
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setExchangeTarget($exchangeTarget = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketExchangeTarget::valueIsValid($exchangeTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketExchangeTarget', is_array($exchangeTarget) ? implode(', ', $exchangeTarget) : var_export($exchangeTarget, true), implode(', ', \patest\EnumType\SubscriberTicketExchangeTarget::getValidValues())), __LINE__);
        }
        if (is_null($exchangeTarget) || (is_array($exchangeTarget) && empty($exchangeTarget))) {
            unset($this->ExchangeTarget);
        } else {
            $this->ExchangeTarget = $exchangeTarget;
        }
        return $this;
    }
    /**
     * Get LimitNumOfFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLimitNumOfFullStackExchanges()
    {
        return isset($this->LimitNumOfFullStackExchanges) ? $this->LimitNumOfFullStackExchanges : null;
    }
    /**
     * Set LimitNumOfFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $limitNumOfFullStackExchanges
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setLimitNumOfFullStackExchanges($limitNumOfFullStackExchanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitNumOfFullStackExchanges) && !is_bool($limitNumOfFullStackExchanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitNumOfFullStackExchanges, true), gettype($limitNumOfFullStackExchanges)), __LINE__);
        }
        if (is_null($limitNumOfFullStackExchanges) || (is_array($limitNumOfFullStackExchanges) && empty($limitNumOfFullStackExchanges))) {
            unset($this->LimitNumOfFullStackExchanges);
        } else {
            $this->LimitNumOfFullStackExchanges = $limitNumOfFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get MaxAllowedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedFullStackExchanges()
    {
        return isset($this->MaxAllowedFullStackExchanges) ? $this->MaxAllowedFullStackExchanges : null;
    }
    /**
     * Set MaxAllowedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedFullStackExchanges
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedFullStackExchanges) && !(is_int($maxAllowedFullStackExchanges) || ctype_digit($maxAllowedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedFullStackExchanges, true), gettype($maxAllowedFullStackExchanges)), __LINE__);
        }
        if (is_null($maxAllowedFullStackExchanges) || (is_array($maxAllowedFullStackExchanges) && empty($maxAllowedFullStackExchanges))) {
            unset($this->MaxAllowedFullStackExchanges);
        } else {
            $this->MaxAllowedFullStackExchanges = $maxAllowedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangePolicyEditMode::valueIsValid()
     * @uses \patest\EnumType\ExchangePolicyEditMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExchangePolicyEditMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangePolicyEditMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \patest\EnumType\ExchangePolicyEditMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIds|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIds $seriesIds
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setSeriesIds(\patest\StructType\SeriesIds $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get UpdateSubscriptionInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpdateSubscriptionInstances()
    {
        return isset($this->UpdateSubscriptionInstances) ? $this->UpdateSubscriptionInstances : null;
    }
    /**
     * Set UpdateSubscriptionInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $updateSubscriptionInstances
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleSeriesExchangePolicies_Request
     */
    public function setUpdateSubscriptionInstances($updateSubscriptionInstances = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateSubscriptionInstances) && !is_bool($updateSubscriptionInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateSubscriptionInstances, true), gettype($updateSubscriptionInstances)), __LINE__);
        }
        if (is_null($updateSubscriptionInstances) || (is_array($updateSubscriptionInstances) && empty($updateSubscriptionInstances))) {
            unset($this->UpdateSubscriptionInstances);
        } else {
            $this->UpdateSubscriptionInstances = $updateSubscriptionInstances;
        }
        return $this;
    }
}
