<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Ticketing.SetMultipleEventExchangePolicies.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SetMultipleEventExchangePolicies_Request extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The AccountCreditCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountCreditCategory;
    /**
     * The BlockExchangeOutBeforeEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BlockExchangeOutBeforeEvent;
    /**
     * The DowngradeBlockedPriceTypeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DowngradeBlockedPriceTypeGroups
     */
    public $DowngradeBlockedPriceTypeGroups;
    /**
     * The DowngradeExcludedClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DowngradeExcludedClientTypes
     */
    public $DowngradeExcludedClientTypes;
    /**
     * The DowngradeExcludedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DowngradeExcludedPriceTypes
     */
    public $DowngradeExcludedPriceTypes;
    /**
     * The DowngradePolicyEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DowngradePolicyEnabled;
    /**
     * The DowngradeRestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $DowngradeRestrictionType;
    /**
     * The DowngradeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DowngradeType;
    /**
     * The DowngradeUnblockedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DowngradeUnblockedPriceTypes
     */
    public $DowngradeUnblockedPriceTypes;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The ExchangeInBlockedPriceTypeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeInBlockedPriceTypeGroups
     */
    public $ExchangeInBlockedPriceTypeGroups;
    /**
     * The ExchangeInEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExchangeInEnabled;
    /**
     * The ExchangeInExcludedClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeInExcludedClientTypes
     */
    public $ExchangeInExcludedClientTypes;
    /**
     * The ExchangeInExcludedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeInExcludedPriceTypes
     */
    public $ExchangeInExcludedPriceTypes;
    /**
     * The ExchangeInRestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ExchangeInRestrictionType;
    /**
     * The ExchangeInUnblockedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeInUnblockedPriceTypes
     */
    public $ExchangeInUnblockedPriceTypes;
    /**
     * The ExchangeOutBlockedPriceTypeGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeOutBlockedPriceTypeGroups
     */
    public $ExchangeOutBlockedPriceTypeGroups;
    /**
     * The ExchangeOutExcludedClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeOutExcludedClientTypes
     */
    public $ExchangeOutExcludedClientTypes;
    /**
     * The ExchangeOutExcludedPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeOutExcludedPriceLevels
     */
    public $ExchangeOutExcludedPriceLevels;
    /**
     * The ExchangeOutExcludedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeOutExcludedPriceTypes
     */
    public $ExchangeOutExcludedPriceTypes;
    /**
     * The ExchangeOutPolicyEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExchangeOutPolicyEnabled;
    /**
     * The ExchangeOutRestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ExchangeOutRestrictionType;
    /**
     * The ExchangeOutUnblockedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExchangeOutUnblockedPriceTypes
     */
    public $ExchangeOutUnblockedPriceTypes;
    /**
     * The ExchangeTimeLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExchangeTimeLimit;
    /**
     * The FanMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FanMessage;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * The PolicyVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PolicyVersion;
    /**
     * The SeriesIdsExchangeIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIdsExchangeIn
     */
    public $SeriesIdsExchangeIn;
    /**
     * Constructor method for
     * BizAction.Ticketing.SetMultipleEventExchangePolicies.Request
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setAccessPermissions()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setAccountCreditCategory()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setBlockExchangeOutBeforeEvent()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeBlockedPriceTypeGroups()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeExcludedClientTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeExcludedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradePolicyEnabled()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeRestrictionType()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeType()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setDowngradeUnblockedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setEventIds()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInBlockedPriceTypeGroups()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInEnabled()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInExcludedClientTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInExcludedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInRestrictionType()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeInUnblockedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutBlockedPriceTypeGroups()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutExcludedClientTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutExcludedPriceLevels()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutExcludedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutPolicyEnabled()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutRestrictionType()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeOutUnblockedPriceTypes()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setExchangeTimeLimit()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setFanMessage()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setMode()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setPolicyVersion()
     * @uses BizAction_Ticketing_SetMultipleEventExchangePolicies_Request::setSeriesIdsExchangeIn()
     * @param string[] $accessPermissions
     * @param string $accountCreditCategory
     * @param bool $blockExchangeOutBeforeEvent
     * @param \patest\StructType\DowngradeBlockedPriceTypeGroups $downgradeBlockedPriceTypeGroups
     * @param \patest\StructType\DowngradeExcludedClientTypes $downgradeExcludedClientTypes
     * @param \patest\StructType\DowngradeExcludedPriceTypes $downgradeExcludedPriceTypes
     * @param bool $downgradePolicyEnabled
     * @param string[] $downgradeRestrictionType
     * @param string $downgradeType
     * @param \patest\StructType\DowngradeUnblockedPriceTypes $downgradeUnblockedPriceTypes
     * @param \patest\StructType\EventIds $eventIds
     * @param \patest\StructType\ExchangeInBlockedPriceTypeGroups $exchangeInBlockedPriceTypeGroups
     * @param bool $exchangeInEnabled
     * @param \patest\StructType\ExchangeInExcludedClientTypes $exchangeInExcludedClientTypes
     * @param \patest\StructType\ExchangeInExcludedPriceTypes $exchangeInExcludedPriceTypes
     * @param string[] $exchangeInRestrictionType
     * @param \patest\StructType\ExchangeInUnblockedPriceTypes $exchangeInUnblockedPriceTypes
     * @param \patest\StructType\ExchangeOutBlockedPriceTypeGroups $exchangeOutBlockedPriceTypeGroups
     * @param \patest\StructType\ExchangeOutExcludedClientTypes $exchangeOutExcludedClientTypes
     * @param \patest\StructType\ExchangeOutExcludedPriceLevels $exchangeOutExcludedPriceLevels
     * @param \patest\StructType\ExchangeOutExcludedPriceTypes $exchangeOutExcludedPriceTypes
     * @param bool $exchangeOutPolicyEnabled
     * @param string[] $exchangeOutRestrictionType
     * @param \patest\StructType\ExchangeOutUnblockedPriceTypes $exchangeOutUnblockedPriceTypes
     * @param int $exchangeTimeLimit
     * @param \patest\StructType\GlobalString $fanMessage
     * @param string $mode
     * @param string $policyVersion
     * @param \patest\StructType\SeriesIdsExchangeIn $seriesIdsExchangeIn
     */
    public function __construct(array $accessPermissions = array(), $accountCreditCategory = null, $blockExchangeOutBeforeEvent = null, \patest\StructType\DowngradeBlockedPriceTypeGroups $downgradeBlockedPriceTypeGroups = null, \patest\StructType\DowngradeExcludedClientTypes $downgradeExcludedClientTypes = null, \patest\StructType\DowngradeExcludedPriceTypes $downgradeExcludedPriceTypes = null, $downgradePolicyEnabled = null, array $downgradeRestrictionType = array(), $downgradeType = null, \patest\StructType\DowngradeUnblockedPriceTypes $downgradeUnblockedPriceTypes = null, \patest\StructType\EventIds $eventIds = null, \patest\StructType\ExchangeInBlockedPriceTypeGroups $exchangeInBlockedPriceTypeGroups = null, $exchangeInEnabled = null, \patest\StructType\ExchangeInExcludedClientTypes $exchangeInExcludedClientTypes = null, \patest\StructType\ExchangeInExcludedPriceTypes $exchangeInExcludedPriceTypes = null, array $exchangeInRestrictionType = array(), \patest\StructType\ExchangeInUnblockedPriceTypes $exchangeInUnblockedPriceTypes = null, \patest\StructType\ExchangeOutBlockedPriceTypeGroups $exchangeOutBlockedPriceTypeGroups = null, \patest\StructType\ExchangeOutExcludedClientTypes $exchangeOutExcludedClientTypes = null, \patest\StructType\ExchangeOutExcludedPriceLevels $exchangeOutExcludedPriceLevels = null, \patest\StructType\ExchangeOutExcludedPriceTypes $exchangeOutExcludedPriceTypes = null, $exchangeOutPolicyEnabled = null, array $exchangeOutRestrictionType = array(), \patest\StructType\ExchangeOutUnblockedPriceTypes $exchangeOutUnblockedPriceTypes = null, $exchangeTimeLimit = null, \patest\StructType\GlobalString $fanMessage = null, $mode = null, $policyVersion = null, \patest\StructType\SeriesIdsExchangeIn $seriesIdsExchangeIn = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setAccountCreditCategory($accountCreditCategory)
            ->setBlockExchangeOutBeforeEvent($blockExchangeOutBeforeEvent)
            ->setDowngradeBlockedPriceTypeGroups($downgradeBlockedPriceTypeGroups)
            ->setDowngradeExcludedClientTypes($downgradeExcludedClientTypes)
            ->setDowngradeExcludedPriceTypes($downgradeExcludedPriceTypes)
            ->setDowngradePolicyEnabled($downgradePolicyEnabled)
            ->setDowngradeRestrictionType($downgradeRestrictionType)
            ->setDowngradeType($downgradeType)
            ->setDowngradeUnblockedPriceTypes($downgradeUnblockedPriceTypes)
            ->setEventIds($eventIds)
            ->setExchangeInBlockedPriceTypeGroups($exchangeInBlockedPriceTypeGroups)
            ->setExchangeInEnabled($exchangeInEnabled)
            ->setExchangeInExcludedClientTypes($exchangeInExcludedClientTypes)
            ->setExchangeInExcludedPriceTypes($exchangeInExcludedPriceTypes)
            ->setExchangeInRestrictionType($exchangeInRestrictionType)
            ->setExchangeInUnblockedPriceTypes($exchangeInUnblockedPriceTypes)
            ->setExchangeOutBlockedPriceTypeGroups($exchangeOutBlockedPriceTypeGroups)
            ->setExchangeOutExcludedClientTypes($exchangeOutExcludedClientTypes)
            ->setExchangeOutExcludedPriceLevels($exchangeOutExcludedPriceLevels)
            ->setExchangeOutExcludedPriceTypes($exchangeOutExcludedPriceTypes)
            ->setExchangeOutPolicyEnabled($exchangeOutPolicyEnabled)
            ->setExchangeOutRestrictionType($exchangeOutRestrictionType)
            ->setExchangeOutUnblockedPriceTypes($exchangeOutUnblockedPriceTypes)
            ->setExchangeTimeLimit($exchangeTimeLimit)
            ->setFanMessage($fanMessage)
            ->setMode($mode)
            ->setPolicyVersion($policyVersion)
            ->setSeriesIdsExchangeIn($seriesIdsExchangeIn);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem) ? get_class($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem), var_export($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get AccountCreditCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountCreditCategory()
    {
        return isset($this->AccountCreditCategory) ? $this->AccountCreditCategory : null;
    }
    /**
     * Set AccountCreditCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountCreditCategory
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setAccountCreditCategory($accountCreditCategory = null)
    {
        // validation for constraint: string
        if (!is_null($accountCreditCategory) && !is_string($accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCreditCategory, true), gettype($accountCreditCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountCreditCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountCreditCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountCreditCategory, true)), __LINE__);
        }
        if (is_null($accountCreditCategory) || (is_array($accountCreditCategory) && empty($accountCreditCategory))) {
            unset($this->AccountCreditCategory);
        } else {
            $this->AccountCreditCategory = $accountCreditCategory;
        }
        return $this;
    }
    /**
     * Get BlockExchangeOutBeforeEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlockExchangeOutBeforeEvent()
    {
        return isset($this->BlockExchangeOutBeforeEvent) ? $this->BlockExchangeOutBeforeEvent : null;
    }
    /**
     * Set BlockExchangeOutBeforeEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blockExchangeOutBeforeEvent
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setBlockExchangeOutBeforeEvent($blockExchangeOutBeforeEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($blockExchangeOutBeforeEvent) && !is_bool($blockExchangeOutBeforeEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blockExchangeOutBeforeEvent, true), gettype($blockExchangeOutBeforeEvent)), __LINE__);
        }
        if (is_null($blockExchangeOutBeforeEvent) || (is_array($blockExchangeOutBeforeEvent) && empty($blockExchangeOutBeforeEvent))) {
            unset($this->BlockExchangeOutBeforeEvent);
        } else {
            $this->BlockExchangeOutBeforeEvent = $blockExchangeOutBeforeEvent;
        }
        return $this;
    }
    /**
     * Get DowngradeBlockedPriceTypeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DowngradeBlockedPriceTypeGroups|null
     */
    public function getDowngradeBlockedPriceTypeGroups()
    {
        return isset($this->DowngradeBlockedPriceTypeGroups) ? $this->DowngradeBlockedPriceTypeGroups : null;
    }
    /**
     * Set DowngradeBlockedPriceTypeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DowngradeBlockedPriceTypeGroups $downgradeBlockedPriceTypeGroups
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeBlockedPriceTypeGroups(\patest\StructType\DowngradeBlockedPriceTypeGroups $downgradeBlockedPriceTypeGroups = null)
    {
        if (is_null($downgradeBlockedPriceTypeGroups) || (is_array($downgradeBlockedPriceTypeGroups) && empty($downgradeBlockedPriceTypeGroups))) {
            unset($this->DowngradeBlockedPriceTypeGroups);
        } else {
            $this->DowngradeBlockedPriceTypeGroups = $downgradeBlockedPriceTypeGroups;
        }
        return $this;
    }
    /**
     * Get DowngradeExcludedClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DowngradeExcludedClientTypes|null
     */
    public function getDowngradeExcludedClientTypes()
    {
        return isset($this->DowngradeExcludedClientTypes) ? $this->DowngradeExcludedClientTypes : null;
    }
    /**
     * Set DowngradeExcludedClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DowngradeExcludedClientTypes $downgradeExcludedClientTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeExcludedClientTypes(\patest\StructType\DowngradeExcludedClientTypes $downgradeExcludedClientTypes = null)
    {
        if (is_null($downgradeExcludedClientTypes) || (is_array($downgradeExcludedClientTypes) && empty($downgradeExcludedClientTypes))) {
            unset($this->DowngradeExcludedClientTypes);
        } else {
            $this->DowngradeExcludedClientTypes = $downgradeExcludedClientTypes;
        }
        return $this;
    }
    /**
     * Get DowngradeExcludedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DowngradeExcludedPriceTypes|null
     */
    public function getDowngradeExcludedPriceTypes()
    {
        return isset($this->DowngradeExcludedPriceTypes) ? $this->DowngradeExcludedPriceTypes : null;
    }
    /**
     * Set DowngradeExcludedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DowngradeExcludedPriceTypes $downgradeExcludedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeExcludedPriceTypes(\patest\StructType\DowngradeExcludedPriceTypes $downgradeExcludedPriceTypes = null)
    {
        if (is_null($downgradeExcludedPriceTypes) || (is_array($downgradeExcludedPriceTypes) && empty($downgradeExcludedPriceTypes))) {
            unset($this->DowngradeExcludedPriceTypes);
        } else {
            $this->DowngradeExcludedPriceTypes = $downgradeExcludedPriceTypes;
        }
        return $this;
    }
    /**
     * Get DowngradePolicyEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDowngradePolicyEnabled()
    {
        return isset($this->DowngradePolicyEnabled) ? $this->DowngradePolicyEnabled : null;
    }
    /**
     * Set DowngradePolicyEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $downgradePolicyEnabled
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradePolicyEnabled($downgradePolicyEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($downgradePolicyEnabled) && !is_bool($downgradePolicyEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downgradePolicyEnabled, true), gettype($downgradePolicyEnabled)), __LINE__);
        }
        if (is_null($downgradePolicyEnabled) || (is_array($downgradePolicyEnabled) && empty($downgradePolicyEnabled))) {
            unset($this->DowngradePolicyEnabled);
        } else {
            $this->DowngradePolicyEnabled = $downgradePolicyEnabled;
        }
        return $this;
    }
    /**
     * Get DowngradeRestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDowngradeRestrictionType()
    {
        return isset($this->DowngradeRestrictionType) ? $this->DowngradeRestrictionType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDowngradeRestrictionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDowngradeRestrictionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDowngradeRestrictionTypeForArrayConstraintsFromSetDowngradeRestrictionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ExchangePolicyRestrictionType::valueIsValid($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem) ? get_class($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem), var_export($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestDowngradeRestrictionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangePolicyRestrictionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ExchangePolicyRestrictionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DowngradeRestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangePolicyRestrictionType::valueIsValid()
     * @uses \patest\EnumType\ExchangePolicyRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $downgradeRestrictionType
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeRestrictionType(array $downgradeRestrictionType = array())
    {
        // validation for constraint: list
        if ('' !== ($downgradeRestrictionTypeArrayErrorMessage = self::validateDowngradeRestrictionTypeForArrayConstraintsFromSetDowngradeRestrictionType($downgradeRestrictionType))) {
            throw new \InvalidArgumentException($downgradeRestrictionTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($downgradeRestrictionType) || (is_array($downgradeRestrictionType) && empty($downgradeRestrictionType))) {
            unset($this->DowngradeRestrictionType);
        } else {
            $this->DowngradeRestrictionType = is_array($downgradeRestrictionType) ? implode(' ', $downgradeRestrictionType) : null;
        }
        return $this;
    }
    /**
     * Get DowngradeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDowngradeType()
    {
        return isset($this->DowngradeType) ? $this->DowngradeType : null;
    }
    /**
     * Set DowngradeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangePolicyDowngradeType::valueIsValid()
     * @uses \patest\EnumType\ExchangePolicyDowngradeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $downgradeType
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeType($downgradeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExchangePolicyDowngradeType::valueIsValid($downgradeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangePolicyDowngradeType', is_array($downgradeType) ? implode(', ', $downgradeType) : var_export($downgradeType, true), implode(', ', \patest\EnumType\ExchangePolicyDowngradeType::getValidValues())), __LINE__);
        }
        if (is_null($downgradeType) || (is_array($downgradeType) && empty($downgradeType))) {
            unset($this->DowngradeType);
        } else {
            $this->DowngradeType = $downgradeType;
        }
        return $this;
    }
    /**
     * Get DowngradeUnblockedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DowngradeUnblockedPriceTypes|null
     */
    public function getDowngradeUnblockedPriceTypes()
    {
        return isset($this->DowngradeUnblockedPriceTypes) ? $this->DowngradeUnblockedPriceTypes : null;
    }
    /**
     * Set DowngradeUnblockedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DowngradeUnblockedPriceTypes $downgradeUnblockedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setDowngradeUnblockedPriceTypes(\patest\StructType\DowngradeUnblockedPriceTypes $downgradeUnblockedPriceTypes = null)
    {
        if (is_null($downgradeUnblockedPriceTypes) || (is_array($downgradeUnblockedPriceTypes) && empty($downgradeUnblockedPriceTypes))) {
            unset($this->DowngradeUnblockedPriceTypes);
        } else {
            $this->DowngradeUnblockedPriceTypes = $downgradeUnblockedPriceTypes;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get ExchangeInBlockedPriceTypeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeInBlockedPriceTypeGroups|null
     */
    public function getExchangeInBlockedPriceTypeGroups()
    {
        return isset($this->ExchangeInBlockedPriceTypeGroups) ? $this->ExchangeInBlockedPriceTypeGroups : null;
    }
    /**
     * Set ExchangeInBlockedPriceTypeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeInBlockedPriceTypeGroups $exchangeInBlockedPriceTypeGroups
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInBlockedPriceTypeGroups(\patest\StructType\ExchangeInBlockedPriceTypeGroups $exchangeInBlockedPriceTypeGroups = null)
    {
        if (is_null($exchangeInBlockedPriceTypeGroups) || (is_array($exchangeInBlockedPriceTypeGroups) && empty($exchangeInBlockedPriceTypeGroups))) {
            unset($this->ExchangeInBlockedPriceTypeGroups);
        } else {
            $this->ExchangeInBlockedPriceTypeGroups = $exchangeInBlockedPriceTypeGroups;
        }
        return $this;
    }
    /**
     * Get ExchangeInEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExchangeInEnabled()
    {
        return isset($this->ExchangeInEnabled) ? $this->ExchangeInEnabled : null;
    }
    /**
     * Set ExchangeInEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exchangeInEnabled
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInEnabled($exchangeInEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeInEnabled) && !is_bool($exchangeInEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeInEnabled, true), gettype($exchangeInEnabled)), __LINE__);
        }
        if (is_null($exchangeInEnabled) || (is_array($exchangeInEnabled) && empty($exchangeInEnabled))) {
            unset($this->ExchangeInEnabled);
        } else {
            $this->ExchangeInEnabled = $exchangeInEnabled;
        }
        return $this;
    }
    /**
     * Get ExchangeInExcludedClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeInExcludedClientTypes|null
     */
    public function getExchangeInExcludedClientTypes()
    {
        return isset($this->ExchangeInExcludedClientTypes) ? $this->ExchangeInExcludedClientTypes : null;
    }
    /**
     * Set ExchangeInExcludedClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeInExcludedClientTypes $exchangeInExcludedClientTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInExcludedClientTypes(\patest\StructType\ExchangeInExcludedClientTypes $exchangeInExcludedClientTypes = null)
    {
        if (is_null($exchangeInExcludedClientTypes) || (is_array($exchangeInExcludedClientTypes) && empty($exchangeInExcludedClientTypes))) {
            unset($this->ExchangeInExcludedClientTypes);
        } else {
            $this->ExchangeInExcludedClientTypes = $exchangeInExcludedClientTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeInExcludedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeInExcludedPriceTypes|null
     */
    public function getExchangeInExcludedPriceTypes()
    {
        return isset($this->ExchangeInExcludedPriceTypes) ? $this->ExchangeInExcludedPriceTypes : null;
    }
    /**
     * Set ExchangeInExcludedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeInExcludedPriceTypes $exchangeInExcludedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInExcludedPriceTypes(\patest\StructType\ExchangeInExcludedPriceTypes $exchangeInExcludedPriceTypes = null)
    {
        if (is_null($exchangeInExcludedPriceTypes) || (is_array($exchangeInExcludedPriceTypes) && empty($exchangeInExcludedPriceTypes))) {
            unset($this->ExchangeInExcludedPriceTypes);
        } else {
            $this->ExchangeInExcludedPriceTypes = $exchangeInExcludedPriceTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeInRestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getExchangeInRestrictionType()
    {
        return isset($this->ExchangeInRestrictionType) ? $this->ExchangeInRestrictionType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExchangeInRestrictionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExchangeInRestrictionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExchangeInRestrictionTypeForArrayConstraintsFromSetExchangeInRestrictionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ExchangeInRestrictionType::valueIsValid($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem) ? get_class($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem), var_export($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeInRestrictionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangeInRestrictionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ExchangeInRestrictionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExchangeInRestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangeInRestrictionType::valueIsValid()
     * @uses \patest\EnumType\ExchangeInRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $exchangeInRestrictionType
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInRestrictionType(array $exchangeInRestrictionType = array())
    {
        // validation for constraint: list
        if ('' !== ($exchangeInRestrictionTypeArrayErrorMessage = self::validateExchangeInRestrictionTypeForArrayConstraintsFromSetExchangeInRestrictionType($exchangeInRestrictionType))) {
            throw new \InvalidArgumentException($exchangeInRestrictionTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($exchangeInRestrictionType) || (is_array($exchangeInRestrictionType) && empty($exchangeInRestrictionType))) {
            unset($this->ExchangeInRestrictionType);
        } else {
            $this->ExchangeInRestrictionType = is_array($exchangeInRestrictionType) ? implode(' ', $exchangeInRestrictionType) : null;
        }
        return $this;
    }
    /**
     * Get ExchangeInUnblockedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeInUnblockedPriceTypes|null
     */
    public function getExchangeInUnblockedPriceTypes()
    {
        return isset($this->ExchangeInUnblockedPriceTypes) ? $this->ExchangeInUnblockedPriceTypes : null;
    }
    /**
     * Set ExchangeInUnblockedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeInUnblockedPriceTypes $exchangeInUnblockedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeInUnblockedPriceTypes(\patest\StructType\ExchangeInUnblockedPriceTypes $exchangeInUnblockedPriceTypes = null)
    {
        if (is_null($exchangeInUnblockedPriceTypes) || (is_array($exchangeInUnblockedPriceTypes) && empty($exchangeInUnblockedPriceTypes))) {
            unset($this->ExchangeInUnblockedPriceTypes);
        } else {
            $this->ExchangeInUnblockedPriceTypes = $exchangeInUnblockedPriceTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeOutBlockedPriceTypeGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeOutBlockedPriceTypeGroups|null
     */
    public function getExchangeOutBlockedPriceTypeGroups()
    {
        return isset($this->ExchangeOutBlockedPriceTypeGroups) ? $this->ExchangeOutBlockedPriceTypeGroups : null;
    }
    /**
     * Set ExchangeOutBlockedPriceTypeGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeOutBlockedPriceTypeGroups $exchangeOutBlockedPriceTypeGroups
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutBlockedPriceTypeGroups(\patest\StructType\ExchangeOutBlockedPriceTypeGroups $exchangeOutBlockedPriceTypeGroups = null)
    {
        if (is_null($exchangeOutBlockedPriceTypeGroups) || (is_array($exchangeOutBlockedPriceTypeGroups) && empty($exchangeOutBlockedPriceTypeGroups))) {
            unset($this->ExchangeOutBlockedPriceTypeGroups);
        } else {
            $this->ExchangeOutBlockedPriceTypeGroups = $exchangeOutBlockedPriceTypeGroups;
        }
        return $this;
    }
    /**
     * Get ExchangeOutExcludedClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeOutExcludedClientTypes|null
     */
    public function getExchangeOutExcludedClientTypes()
    {
        return isset($this->ExchangeOutExcludedClientTypes) ? $this->ExchangeOutExcludedClientTypes : null;
    }
    /**
     * Set ExchangeOutExcludedClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeOutExcludedClientTypes $exchangeOutExcludedClientTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutExcludedClientTypes(\patest\StructType\ExchangeOutExcludedClientTypes $exchangeOutExcludedClientTypes = null)
    {
        if (is_null($exchangeOutExcludedClientTypes) || (is_array($exchangeOutExcludedClientTypes) && empty($exchangeOutExcludedClientTypes))) {
            unset($this->ExchangeOutExcludedClientTypes);
        } else {
            $this->ExchangeOutExcludedClientTypes = $exchangeOutExcludedClientTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeOutExcludedPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeOutExcludedPriceLevels|null
     */
    public function getExchangeOutExcludedPriceLevels()
    {
        return isset($this->ExchangeOutExcludedPriceLevels) ? $this->ExchangeOutExcludedPriceLevels : null;
    }
    /**
     * Set ExchangeOutExcludedPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeOutExcludedPriceLevels $exchangeOutExcludedPriceLevels
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutExcludedPriceLevels(\patest\StructType\ExchangeOutExcludedPriceLevels $exchangeOutExcludedPriceLevels = null)
    {
        if (is_null($exchangeOutExcludedPriceLevels) || (is_array($exchangeOutExcludedPriceLevels) && empty($exchangeOutExcludedPriceLevels))) {
            unset($this->ExchangeOutExcludedPriceLevels);
        } else {
            $this->ExchangeOutExcludedPriceLevels = $exchangeOutExcludedPriceLevels;
        }
        return $this;
    }
    /**
     * Get ExchangeOutExcludedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeOutExcludedPriceTypes|null
     */
    public function getExchangeOutExcludedPriceTypes()
    {
        return isset($this->ExchangeOutExcludedPriceTypes) ? $this->ExchangeOutExcludedPriceTypes : null;
    }
    /**
     * Set ExchangeOutExcludedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeOutExcludedPriceTypes $exchangeOutExcludedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutExcludedPriceTypes(\patest\StructType\ExchangeOutExcludedPriceTypes $exchangeOutExcludedPriceTypes = null)
    {
        if (is_null($exchangeOutExcludedPriceTypes) || (is_array($exchangeOutExcludedPriceTypes) && empty($exchangeOutExcludedPriceTypes))) {
            unset($this->ExchangeOutExcludedPriceTypes);
        } else {
            $this->ExchangeOutExcludedPriceTypes = $exchangeOutExcludedPriceTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeOutPolicyEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExchangeOutPolicyEnabled()
    {
        return isset($this->ExchangeOutPolicyEnabled) ? $this->ExchangeOutPolicyEnabled : null;
    }
    /**
     * Set ExchangeOutPolicyEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exchangeOutPolicyEnabled
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutPolicyEnabled($exchangeOutPolicyEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($exchangeOutPolicyEnabled) && !is_bool($exchangeOutPolicyEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exchangeOutPolicyEnabled, true), gettype($exchangeOutPolicyEnabled)), __LINE__);
        }
        if (is_null($exchangeOutPolicyEnabled) || (is_array($exchangeOutPolicyEnabled) && empty($exchangeOutPolicyEnabled))) {
            unset($this->ExchangeOutPolicyEnabled);
        } else {
            $this->ExchangeOutPolicyEnabled = $exchangeOutPolicyEnabled;
        }
        return $this;
    }
    /**
     * Get ExchangeOutRestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getExchangeOutRestrictionType()
    {
        return isset($this->ExchangeOutRestrictionType) ? $this->ExchangeOutRestrictionType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExchangeOutRestrictionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExchangeOutRestrictionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExchangeOutRestrictionTypeForArrayConstraintsFromSetExchangeOutRestrictionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\ExchangePolicyRestrictionType::valueIsValid($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem) ? get_class($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem), var_export($bizAction_Ticketing_SetMultipleEventExchangePolicies_RequestExchangeOutRestrictionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangePolicyRestrictionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\ExchangePolicyRestrictionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExchangeOutRestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangePolicyRestrictionType::valueIsValid()
     * @uses \patest\EnumType\ExchangePolicyRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $exchangeOutRestrictionType
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutRestrictionType(array $exchangeOutRestrictionType = array())
    {
        // validation for constraint: list
        if ('' !== ($exchangeOutRestrictionTypeArrayErrorMessage = self::validateExchangeOutRestrictionTypeForArrayConstraintsFromSetExchangeOutRestrictionType($exchangeOutRestrictionType))) {
            throw new \InvalidArgumentException($exchangeOutRestrictionTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($exchangeOutRestrictionType) || (is_array($exchangeOutRestrictionType) && empty($exchangeOutRestrictionType))) {
            unset($this->ExchangeOutRestrictionType);
        } else {
            $this->ExchangeOutRestrictionType = is_array($exchangeOutRestrictionType) ? implode(' ', $exchangeOutRestrictionType) : null;
        }
        return $this;
    }
    /**
     * Get ExchangeOutUnblockedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExchangeOutUnblockedPriceTypes|null
     */
    public function getExchangeOutUnblockedPriceTypes()
    {
        return isset($this->ExchangeOutUnblockedPriceTypes) ? $this->ExchangeOutUnblockedPriceTypes : null;
    }
    /**
     * Set ExchangeOutUnblockedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExchangeOutUnblockedPriceTypes $exchangeOutUnblockedPriceTypes
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeOutUnblockedPriceTypes(\patest\StructType\ExchangeOutUnblockedPriceTypes $exchangeOutUnblockedPriceTypes = null)
    {
        if (is_null($exchangeOutUnblockedPriceTypes) || (is_array($exchangeOutUnblockedPriceTypes) && empty($exchangeOutUnblockedPriceTypes))) {
            unset($this->ExchangeOutUnblockedPriceTypes);
        } else {
            $this->ExchangeOutUnblockedPriceTypes = $exchangeOutUnblockedPriceTypes;
        }
        return $this;
    }
    /**
     * Get ExchangeTimeLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExchangeTimeLimit()
    {
        return isset($this->ExchangeTimeLimit) ? $this->ExchangeTimeLimit : null;
    }
    /**
     * Set ExchangeTimeLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $exchangeTimeLimit
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setExchangeTimeLimit($exchangeTimeLimit = null)
    {
        // validation for constraint: int
        if (!is_null($exchangeTimeLimit) && !(is_int($exchangeTimeLimit) || ctype_digit($exchangeTimeLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exchangeTimeLimit, true), gettype($exchangeTimeLimit)), __LINE__);
        }
        if (is_null($exchangeTimeLimit) || (is_array($exchangeTimeLimit) && empty($exchangeTimeLimit))) {
            unset($this->ExchangeTimeLimit);
        } else {
            $this->ExchangeTimeLimit = $exchangeTimeLimit;
        }
        return $this;
    }
    /**
     * Get FanMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFanMessage()
    {
        return isset($this->FanMessage) ? $this->FanMessage : null;
    }
    /**
     * Set FanMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fanMessage
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setFanMessage(\patest\StructType\GlobalString $fanMessage = null)
    {
        if (is_null($fanMessage) || (is_array($fanMessage) && empty($fanMessage))) {
            unset($this->FanMessage);
        } else {
            $this->FanMessage = $fanMessage;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExchangePolicyEditMode::valueIsValid()
     * @uses \patest\EnumType\ExchangePolicyEditMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExchangePolicyEditMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangePolicyEditMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \patest\EnumType\ExchangePolicyEditMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Get PolicyVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicyVersion()
    {
        return isset($this->PolicyVersion) ? $this->PolicyVersion : null;
    }
    /**
     * Set PolicyVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $policyVersion
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setPolicyVersion($policyVersion = null)
    {
        // validation for constraint: string
        if (!is_null($policyVersion) && !is_string($policyVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyVersion, true), gettype($policyVersion)), __LINE__);
        }
        if (is_null($policyVersion) || (is_array($policyVersion) && empty($policyVersion))) {
            unset($this->PolicyVersion);
        } else {
            $this->PolicyVersion = $policyVersion;
        }
        return $this;
    }
    /**
     * Get SeriesIdsExchangeIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIdsExchangeIn|null
     */
    public function getSeriesIdsExchangeIn()
    {
        return isset($this->SeriesIdsExchangeIn) ? $this->SeriesIdsExchangeIn : null;
    }
    /**
     * Set SeriesIdsExchangeIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIdsExchangeIn $seriesIdsExchangeIn
     * @return \patest\StructType\BizAction_Ticketing_SetMultipleEventExchangePolicies_Request
     */
    public function setSeriesIdsExchangeIn(\patest\StructType\SeriesIdsExchangeIn $seriesIdsExchangeIn = null)
    {
        if (is_null($seriesIdsExchangeIn) || (is_array($seriesIdsExchangeIn) && empty($seriesIdsExchangeIn))) {
            unset($this->SeriesIdsExchangeIn);
        } else {
            $this->SeriesIdsExchangeIn = $seriesIdsExchangeIn;
        }
        return $this;
    }
}
