<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.SeatAllocationAudit.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_SeatAllocationAudit_Request extends AnyEntity
{
    /**
     * The AgentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgentId;
    /**
     * The AllocationTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationTypes;
    /**
     * The ChangeFromDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ChangeFromDateType;
    /**
     * The EventsFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsFromDate;
    /**
     * The EventsToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsToDate;
    /**
     * The IncludeTakenSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTakenSeats;
    /**
     * The SeatActivity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatActivity;
    /**
     * The SeatAllocationAuditDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails
     */
    public $SeatAllocationAuditDetails;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The SinceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SinceDate;
    /**
     * The TodaySince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TodaySince;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for BizAction.Ticketing.SeatAllocationAudit.Request
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setAgentId()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setAllocationTypes()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setChangeFromDateType()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setEventsFromDate()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setEventsToDate()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setIncludeTakenSeats()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setSeatActivity()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setSeatAllocationAuditDetails()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setShowId()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setSinceDate()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setTodaySince()
     * @uses BizAction_Ticketing_SeatAllocationAudit_Request::setUserId()
     * @param string $agentId
     * @param string $allocationTypes
     * @param int $changeFromDateType
     * @param string $eventsFromDate
     * @param string $eventsToDate
     * @param bool $includeTakenSeats
     * @param string $seatActivity
     * @param \patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails $seatAllocationAuditDetails
     * @param string $showId
     * @param string $sinceDate
     * @param string $todaySince
     * @param string $userId
     */
    public function __construct($agentId = null, $allocationTypes = null, $changeFromDateType = null, $eventsFromDate = null, $eventsToDate = null, $includeTakenSeats = null, $seatActivity = null, \patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails $seatAllocationAuditDetails = null, $showId = null, $sinceDate = null, $todaySince = null, $userId = null)
    {
        $this
            ->setAgentId($agentId)
            ->setAllocationTypes($allocationTypes)
            ->setChangeFromDateType($changeFromDateType)
            ->setEventsFromDate($eventsFromDate)
            ->setEventsToDate($eventsToDate)
            ->setIncludeTakenSeats($includeTakenSeats)
            ->setSeatActivity($seatActivity)
            ->setSeatAllocationAuditDetails($seatAllocationAuditDetails)
            ->setShowId($showId)
            ->setSinceDate($sinceDate)
            ->setTodaySince($todaySince)
            ->setUserId($userId);
    }
    /**
     * Get AgentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentId()
    {
        return isset($this->AgentId) ? $this->AgentId : null;
    }
    /**
     * Set AgentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentId
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setAgentId($agentId = null)
    {
        // validation for constraint: string
        if (!is_null($agentId) && !is_string($agentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentId, true), gettype($agentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agentId, true)), __LINE__);
        }
        if (is_null($agentId) || (is_array($agentId) && empty($agentId))) {
            unset($this->AgentId);
        } else {
            $this->AgentId = $agentId;
        }
        return $this;
    }
    /**
     * Get AllocationTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypes()
    {
        return isset($this->AllocationTypes) ? $this->AllocationTypes : null;
    }
    /**
     * Set AllocationTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypes
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setAllocationTypes($allocationTypes = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypes) && !is_string($allocationTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypes, true), gettype($allocationTypes)), __LINE__);
        }
        if (is_null($allocationTypes) || (is_array($allocationTypes) && empty($allocationTypes))) {
            unset($this->AllocationTypes);
        } else {
            $this->AllocationTypes = $allocationTypes;
        }
        return $this;
    }
    /**
     * Get ChangeFromDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getChangeFromDateType()
    {
        return isset($this->ChangeFromDateType) ? $this->ChangeFromDateType : null;
    }
    /**
     * Set ChangeFromDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $changeFromDateType
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setChangeFromDateType($changeFromDateType = null)
    {
        // validation for constraint: int
        if (!is_null($changeFromDateType) && !(is_int($changeFromDateType) || ctype_digit($changeFromDateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($changeFromDateType, true), gettype($changeFromDateType)), __LINE__);
        }
        if (is_null($changeFromDateType) || (is_array($changeFromDateType) && empty($changeFromDateType))) {
            unset($this->ChangeFromDateType);
        } else {
            $this->ChangeFromDateType = $changeFromDateType;
        }
        return $this;
    }
    /**
     * Get EventsFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsFromDate()
    {
        return isset($this->EventsFromDate) ? $this->EventsFromDate : null;
    }
    /**
     * Set EventsFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsFromDate
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setEventsFromDate($eventsFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsFromDate) && !is_string($eventsFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsFromDate, true), gettype($eventsFromDate)), __LINE__);
        }
        if (is_null($eventsFromDate) || (is_array($eventsFromDate) && empty($eventsFromDate))) {
            unset($this->EventsFromDate);
        } else {
            $this->EventsFromDate = $eventsFromDate;
        }
        return $this;
    }
    /**
     * Get EventsToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsToDate()
    {
        return isset($this->EventsToDate) ? $this->EventsToDate : null;
    }
    /**
     * Set EventsToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsToDate
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setEventsToDate($eventsToDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsToDate) && !is_string($eventsToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsToDate, true), gettype($eventsToDate)), __LINE__);
        }
        if (is_null($eventsToDate) || (is_array($eventsToDate) && empty($eventsToDate))) {
            unset($this->EventsToDate);
        } else {
            $this->EventsToDate = $eventsToDate;
        }
        return $this;
    }
    /**
     * Get IncludeTakenSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTakenSeats()
    {
        return isset($this->IncludeTakenSeats) ? $this->IncludeTakenSeats : null;
    }
    /**
     * Set IncludeTakenSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTakenSeats
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setIncludeTakenSeats($includeTakenSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTakenSeats) && !is_bool($includeTakenSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTakenSeats, true), gettype($includeTakenSeats)), __LINE__);
        }
        if (is_null($includeTakenSeats) || (is_array($includeTakenSeats) && empty($includeTakenSeats))) {
            unset($this->IncludeTakenSeats);
        } else {
            $this->IncludeTakenSeats = $includeTakenSeats;
        }
        return $this;
    }
    /**
     * Get SeatActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatActivity()
    {
        return isset($this->SeatActivity) ? $this->SeatActivity : null;
    }
    /**
     * Set SeatActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatActivity::valueIsValid()
     * @uses \patest\EnumType\SeatActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatActivity
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setSeatActivity($seatActivity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatActivity::valueIsValid($seatActivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatActivity', is_array($seatActivity) ? implode(', ', $seatActivity) : var_export($seatActivity, true), implode(', ', \patest\EnumType\SeatActivity::getValidValues())), __LINE__);
        }
        if (is_null($seatActivity) || (is_array($seatActivity) && empty($seatActivity))) {
            unset($this->SeatActivity);
        } else {
            $this->SeatActivity = $seatActivity;
        }
        return $this;
    }
    /**
     * Get SeatAllocationAuditDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails|null
     */
    public function getSeatAllocationAuditDetails()
    {
        return isset($this->SeatAllocationAuditDetails) ? $this->SeatAllocationAuditDetails : null;
    }
    /**
     * Set SeatAllocationAuditDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails $seatAllocationAuditDetails
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setSeatAllocationAuditDetails(\patest\StructType\RecordSetOfTicketing_SeatAllocationAuditDetails $seatAllocationAuditDetails = null)
    {
        if (is_null($seatAllocationAuditDetails) || (is_array($seatAllocationAuditDetails) && empty($seatAllocationAuditDetails))) {
            unset($this->SeatAllocationAuditDetails);
        } else {
            $this->SeatAllocationAuditDetails = $seatAllocationAuditDetails;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get SinceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSinceDate()
    {
        return isset($this->SinceDate) ? $this->SinceDate : null;
    }
    /**
     * Set SinceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sinceDate
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setSinceDate($sinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($sinceDate) && !is_string($sinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sinceDate, true), gettype($sinceDate)), __LINE__);
        }
        if (is_null($sinceDate) || (is_array($sinceDate) && empty($sinceDate))) {
            unset($this->SinceDate);
        } else {
            $this->SinceDate = $sinceDate;
        }
        return $this;
    }
    /**
     * Get TodaySince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTodaySince()
    {
        return isset($this->TodaySince) ? $this->TodaySince : null;
    }
    /**
     * Set TodaySince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $todaySince
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setTodaySince($todaySince = null)
    {
        // validation for constraint: string
        if (!is_null($todaySince) && !is_string($todaySince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($todaySince, true), gettype($todaySince)), __LINE__);
        }
        if (is_null($todaySince) || (is_array($todaySince) && empty($todaySince))) {
            unset($this->TodaySince);
        } else {
            $this->TodaySince = $todaySince;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\BizAction_Ticketing_SeatAllocationAudit_Request
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
