<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.RepriceRegularTickets.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_RepriceRegularTickets_Request extends BizAction_Ticketing_RepriceProduct_Request
{
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsReserved;
    /**
     * The RegularTicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegularTicketIds;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionInstanceIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Ticketing.RepriceRegularTickets.Request
     * @uses BizAction_Ticketing_RepriceRegularTickets_Request::setEventIds()
     * @uses BizAction_Ticketing_RepriceRegularTickets_Request::setIsReserved()
     * @uses BizAction_Ticketing_RepriceRegularTickets_Request::setRegularTicketIds()
     * @uses BizAction_Ticketing_RepriceRegularTickets_Request::setSubscriptionInstanceIds()
     * @uses BizAction_Ticketing_RepriceRegularTickets_Request::setTransactionGuid()
     * @param string $eventIds
     * @param string $isReserved
     * @param string $regularTicketIds
     * @param string $subscriptionInstanceIds
     * @param string $transactionGuid
     */
    public function __construct($eventIds = null, $isReserved = null, $regularTicketIds = null, $subscriptionInstanceIds = null, $transactionGuid = null)
    {
        $this
            ->setEventIds($eventIds)
            ->setIsReserved($isReserved)
            ->setRegularTicketIds($regularTicketIds)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceRegularTickets_Request
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isReserved
     * @return \patest\StructType\BizAction_Ticketing_RepriceRegularTickets_Request
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: string
        if (!is_null($isReserved) && !is_string($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get RegularTicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegularTicketIds()
    {
        return isset($this->RegularTicketIds) ? $this->RegularTicketIds : null;
    }
    /**
     * Set RegularTicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regularTicketIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceRegularTickets_Request
     */
    public function setRegularTicketIds($regularTicketIds = null)
    {
        // validation for constraint: string
        if (!is_null($regularTicketIds) && !is_string($regularTicketIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regularTicketIds, true), gettype($regularTicketIds)), __LINE__);
        }
        if (is_null($regularTicketIds) || (is_array($regularTicketIds) && empty($regularTicketIds))) {
            unset($this->RegularTicketIds);
        } else {
            $this->RegularTicketIds = $regularTicketIds;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceIds
     * @return \patest\StructType\BizAction_Ticketing_RepriceRegularTickets_Request
     */
    public function setSubscriptionInstanceIds($subscriptionInstanceIds = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceIds) && !is_string($subscriptionInstanceIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceIds, true), gettype($subscriptionInstanceIds)), __LINE__);
        }
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Ticketing_RepriceRegularTickets_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
