<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.RepriceProduct.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_RepriceProduct_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsReturned;
    /**
     * The KeepItemBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepItemBarcode;
    /**
     * The KeepOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOnCard;
    /**
     * The NewOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwner;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * The PrintItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintItem;
    /**
     * The RepriceTicketsScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RepriceTicketsScenario;
    /**
     * The UsePrintedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsePrintedTickets;
    /**
     * Constructor method for BizAction.Ticketing.RepriceProduct.Request
     * @uses BizAction_Ticketing_RepriceProduct_Request::setClientId()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setIsReturned()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setKeepItemBarcode()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setKeepOnCard()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setNewOwner()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setNewPriceType()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setPrintItem()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setRepriceTicketsScenario()
     * @uses BizAction_Ticketing_RepriceProduct_Request::setUsePrintedTickets()
     * @param string $clientId
     * @param string $isReturned
     * @param bool $keepItemBarcode
     * @param bool $keepOnCard
     * @param string $newOwner
     * @param string $newPriceType
     * @param bool $printItem
     * @param string $repriceTicketsScenario
     * @param string $usePrintedTickets
     */
    public function __construct($clientId = null, $isReturned = null, $keepItemBarcode = null, $keepOnCard = null, $newOwner = null, $newPriceType = null, $printItem = null, $repriceTicketsScenario = null, $usePrintedTickets = null)
    {
        $this
            ->setClientId($clientId)
            ->setIsReturned($isReturned)
            ->setKeepItemBarcode($keepItemBarcode)
            ->setKeepOnCard($keepOnCard)
            ->setNewOwner($newOwner)
            ->setNewPriceType($newPriceType)
            ->setPrintItem($printItem)
            ->setRepriceTicketsScenario($repriceTicketsScenario)
            ->setUsePrintedTickets($usePrintedTickets);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isReturned
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: string
        if (!is_null($isReturned) && !is_string($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get KeepItemBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepItemBarcode()
    {
        return isset($this->KeepItemBarcode) ? $this->KeepItemBarcode : null;
    }
    /**
     * Set KeepItemBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepItemBarcode
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setKeepItemBarcode($keepItemBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepItemBarcode) && !is_bool($keepItemBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepItemBarcode, true), gettype($keepItemBarcode)), __LINE__);
        }
        if (is_null($keepItemBarcode) || (is_array($keepItemBarcode) && empty($keepItemBarcode))) {
            unset($this->KeepItemBarcode);
        } else {
            $this->KeepItemBarcode = $keepItemBarcode;
        }
        return $this;
    }
    /**
     * Get KeepOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOnCard()
    {
        return isset($this->KeepOnCard) ? $this->KeepOnCard : null;
    }
    /**
     * Set KeepOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOnCard
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setKeepOnCard($keepOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOnCard) && !is_bool($keepOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOnCard, true), gettype($keepOnCard)), __LINE__);
        }
        if (is_null($keepOnCard) || (is_array($keepOnCard) && empty($keepOnCard))) {
            unset($this->KeepOnCard);
        } else {
            $this->KeepOnCard = $keepOnCard;
        }
        return $this;
    }
    /**
     * Get NewOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwner()
    {
        return isset($this->NewOwner) ? $this->NewOwner : null;
    }
    /**
     * Set NewOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwner
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setNewOwner($newOwner = null)
    {
        // validation for constraint: string
        if (!is_null($newOwner) && !is_string($newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwner, true), gettype($newOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwner, true)), __LINE__);
        }
        if (is_null($newOwner) || (is_array($newOwner) && empty($newOwner))) {
            unset($this->NewOwner);
        } else {
            $this->NewOwner = $newOwner;
        }
        return $this;
    }
    /**
     * Get NewPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceType()
    {
        return isset($this->NewPriceType) ? $this->NewPriceType : null;
    }
    /**
     * Set NewPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceType
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        if (is_null($newPriceType) || (is_array($newPriceType) && empty($newPriceType))) {
            unset($this->NewPriceType);
        } else {
            $this->NewPriceType = $newPriceType;
        }
        return $this;
    }
    /**
     * Get PrintItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintItem()
    {
        return isset($this->PrintItem) ? $this->PrintItem : null;
    }
    /**
     * Set PrintItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printItem
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setPrintItem($printItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($printItem) && !is_bool($printItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printItem, true), gettype($printItem)), __LINE__);
        }
        if (is_null($printItem) || (is_array($printItem) && empty($printItem))) {
            unset($this->PrintItem);
        } else {
            $this->PrintItem = $printItem;
        }
        return $this;
    }
    /**
     * Get RepriceTicketsScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepriceTicketsScenario()
    {
        return isset($this->RepriceTicketsScenario) ? $this->RepriceTicketsScenario : null;
    }
    /**
     * Set RepriceTicketsScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RepriceTicketsScenario::valueIsValid()
     * @uses \patest\EnumType\RepriceTicketsScenario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repriceTicketsScenario
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setRepriceTicketsScenario($repriceTicketsScenario = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RepriceTicketsScenario::valueIsValid($repriceTicketsScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RepriceTicketsScenario', is_array($repriceTicketsScenario) ? implode(', ', $repriceTicketsScenario) : var_export($repriceTicketsScenario, true), implode(', ', \patest\EnumType\RepriceTicketsScenario::getValidValues())), __LINE__);
        }
        if (is_null($repriceTicketsScenario) || (is_array($repriceTicketsScenario) && empty($repriceTicketsScenario))) {
            unset($this->RepriceTicketsScenario);
        } else {
            $this->RepriceTicketsScenario = $repriceTicketsScenario;
        }
        return $this;
    }
    /**
     * Get UsePrintedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsePrintedTickets()
    {
        return isset($this->UsePrintedTickets) ? $this->UsePrintedTickets : null;
    }
    /**
     * Set UsePrintedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UsePrintedTickets::valueIsValid()
     * @uses \patest\EnumType\UsePrintedTickets::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usePrintedTickets
     * @return \patest\StructType\BizAction_Ticketing_RepriceProduct_Request
     */
    public function setUsePrintedTickets($usePrintedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UsePrintedTickets::valueIsValid($usePrintedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UsePrintedTickets', is_array($usePrintedTickets) ? implode(', ', $usePrintedTickets) : var_export($usePrintedTickets, true), implode(', ', \patest\EnumType\UsePrintedTickets::getValidValues())), __LINE__);
        }
        if (is_null($usePrintedTickets) || (is_array($usePrintedTickets) && empty($usePrintedTickets))) {
            unset($this->UsePrintedTickets);
        } else {
            $this->UsePrintedTickets = $usePrintedTickets;
        }
        return $this;
    }
}
