<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ProcessSection.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ProcessSection_Request extends AnyEntity
{
    /**
     * The Applicants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant
     */
    public $Applicants;
    /**
     * The ApplyClientTypeToWinner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ApplyClientTypeToWinner;
    /**
     * The AvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableSeats;
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotingResultId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotingResultId;
    /**
     * The BallotMinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotMinSeats;
    /**
     * The BallotRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotRunMode;
    /**
     * The BallotVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotVersion;
    /**
     * The ClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientTypeId;
    /**
     * The ClientTypesFilterMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypesFilterMode;
    /**
     * The CurrentApplicantsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentApplicantsCount;
    /**
     * The DoesAssignRelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoesAssignRelatedClients;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IncludeWinnersInOtherSections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeWinnersInOtherSections;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MaxSeatsToWin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeatsToWin;
    /**
     * The MaxWinsPerBallot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxWinsPerBallot;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * The NumOfAllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfAllocatedSeats;
    /**
     * The NumOfApplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfApplications;
    /**
     * The NumOfCurrentApplicants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfCurrentApplicants;
    /**
     * The NumOfCurrentWinners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfCurrentWinners;
    /**
     * The NumOfRequestedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfRequestedSeats;
    /**
     * The NumOfWonSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfWonSeats;
    /**
     * The ResultStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultStatus;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The SelectedClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedClientTypeIds;
    /**
     * The SelectedSectionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedSectionIds;
    /**
     * The TemporaryTransactionIdsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TemporaryTransactionIdsList;
    /**
     * The UseTicketReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseTicketReservation;
    /**
     * Constructor method for BizAction.Ticketing.ProcessSection.Request
     * @uses BizAction_Ticketing_ProcessSection_Request::setApplicants()
     * @uses BizAction_Ticketing_ProcessSection_Request::setApplyClientTypeToWinner()
     * @uses BizAction_Ticketing_ProcessSection_Request::setAvailableSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotEventId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotingResultId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotMinSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotRunMode()
     * @uses BizAction_Ticketing_ProcessSection_Request::setBallotVersion()
     * @uses BizAction_Ticketing_ProcessSection_Request::setClientTypeId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setClientTypesFilterMode()
     * @uses BizAction_Ticketing_ProcessSection_Request::setCurrentApplicantsCount()
     * @uses BizAction_Ticketing_ProcessSection_Request::setDoesAssignRelatedClients()
     * @uses BizAction_Ticketing_ProcessSection_Request::setEventId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setIncludeWinnersInOtherSections()
     * @uses BizAction_Ticketing_ProcessSection_Request::setMaxSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setMaxSeatsToWin()
     * @uses BizAction_Ticketing_ProcessSection_Request::setMaxWinsPerBallot()
     * @uses BizAction_Ticketing_ProcessSection_Request::setMinSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setMode()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfAllocatedSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfApplications()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfCurrentApplicants()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfCurrentWinners()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfRequestedSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setNumOfWonSeats()
     * @uses BizAction_Ticketing_ProcessSection_Request::setResultStatus()
     * @uses BizAction_Ticketing_ProcessSection_Request::setSectionId()
     * @uses BizAction_Ticketing_ProcessSection_Request::setSelectedClientTypeIds()
     * @uses BizAction_Ticketing_ProcessSection_Request::setSelectedSectionIds()
     * @uses BizAction_Ticketing_ProcessSection_Request::setTemporaryTransactionIdsList()
     * @uses BizAction_Ticketing_ProcessSection_Request::setUseTicketReservation()
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant $applicants
     * @param bool $applyClientTypeToWinner
     * @param int $availableSeats
     * @param string $ballotEventId
     * @param string $ballotId
     * @param string $ballotingResultId
     * @param int $ballotMinSeats
     * @param string $ballotRunMode
     * @param string $ballotVersion
     * @param string $clientTypeId
     * @param string $clientTypesFilterMode
     * @param int $currentApplicantsCount
     * @param bool $doesAssignRelatedClients
     * @param string $eventId
     * @param string $includeWinnersInOtherSections
     * @param int $maxSeats
     * @param int $maxSeatsToWin
     * @param int $maxWinsPerBallot
     * @param int $minSeats
     * @param string $mode
     * @param int $numOfAllocatedSeats
     * @param int $numOfApplications
     * @param int $numOfCurrentApplicants
     * @param int $numOfCurrentWinners
     * @param int $numOfRequestedSeats
     * @param int $numOfWonSeats
     * @param string $resultStatus
     * @param string $sectionId
     * @param string $selectedClientTypeIds
     * @param string $selectedSectionIds
     * @param string $temporaryTransactionIdsList
     * @param bool $useTicketReservation
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant $applicants = null, $applyClientTypeToWinner = null, $availableSeats = null, $ballotEventId = null, $ballotId = null, $ballotingResultId = null, $ballotMinSeats = null, $ballotRunMode = null, $ballotVersion = null, $clientTypeId = null, $clientTypesFilterMode = null, $currentApplicantsCount = null, $doesAssignRelatedClients = null, $eventId = null, $includeWinnersInOtherSections = null, $maxSeats = null, $maxSeatsToWin = null, $maxWinsPerBallot = null, $minSeats = null, $mode = null, $numOfAllocatedSeats = null, $numOfApplications = null, $numOfCurrentApplicants = null, $numOfCurrentWinners = null, $numOfRequestedSeats = null, $numOfWonSeats = null, $resultStatus = null, $sectionId = null, $selectedClientTypeIds = null, $selectedSectionIds = null, $temporaryTransactionIdsList = null, $useTicketReservation = null)
    {
        $this
            ->setApplicants($applicants)
            ->setApplyClientTypeToWinner($applyClientTypeToWinner)
            ->setAvailableSeats($availableSeats)
            ->setBallotEventId($ballotEventId)
            ->setBallotId($ballotId)
            ->setBallotingResultId($ballotingResultId)
            ->setBallotMinSeats($ballotMinSeats)
            ->setBallotRunMode($ballotRunMode)
            ->setBallotVersion($ballotVersion)
            ->setClientTypeId($clientTypeId)
            ->setClientTypesFilterMode($clientTypesFilterMode)
            ->setCurrentApplicantsCount($currentApplicantsCount)
            ->setDoesAssignRelatedClients($doesAssignRelatedClients)
            ->setEventId($eventId)
            ->setIncludeWinnersInOtherSections($includeWinnersInOtherSections)
            ->setMaxSeats($maxSeats)
            ->setMaxSeatsToWin($maxSeatsToWin)
            ->setMaxWinsPerBallot($maxWinsPerBallot)
            ->setMinSeats($minSeats)
            ->setMode($mode)
            ->setNumOfAllocatedSeats($numOfAllocatedSeats)
            ->setNumOfApplications($numOfApplications)
            ->setNumOfCurrentApplicants($numOfCurrentApplicants)
            ->setNumOfCurrentWinners($numOfCurrentWinners)
            ->setNumOfRequestedSeats($numOfRequestedSeats)
            ->setNumOfWonSeats($numOfWonSeats)
            ->setResultStatus($resultStatus)
            ->setSectionId($sectionId)
            ->setSelectedClientTypeIds($selectedClientTypeIds)
            ->setSelectedSectionIds($selectedSectionIds)
            ->setTemporaryTransactionIdsList($temporaryTransactionIdsList)
            ->setUseTicketReservation($useTicketReservation);
    }
    /**
     * Get Applicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant|null
     */
    public function getApplicants()
    {
        return isset($this->Applicants) ? $this->Applicants : null;
    }
    /**
     * Set Applicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant $applicants
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setApplicants(\patest\StructType\RecordSetOfBizAction_Ticketing_BallotApplicant $applicants = null)
    {
        if (is_null($applicants) || (is_array($applicants) && empty($applicants))) {
            unset($this->Applicants);
        } else {
            $this->Applicants = $applicants;
        }
        return $this;
    }
    /**
     * Get ApplyClientTypeToWinner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApplyClientTypeToWinner()
    {
        return isset($this->ApplyClientTypeToWinner) ? $this->ApplyClientTypeToWinner : null;
    }
    /**
     * Set ApplyClientTypeToWinner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $applyClientTypeToWinner
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setApplyClientTypeToWinner($applyClientTypeToWinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyClientTypeToWinner) && !is_bool($applyClientTypeToWinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyClientTypeToWinner, true), gettype($applyClientTypeToWinner)), __LINE__);
        }
        if (is_null($applyClientTypeToWinner) || (is_array($applyClientTypeToWinner) && empty($applyClientTypeToWinner))) {
            unset($this->ApplyClientTypeToWinner);
        } else {
            $this->ApplyClientTypeToWinner = $applyClientTypeToWinner;
        }
        return $this;
    }
    /**
     * Get AvailableSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return isset($this->AvailableSeats) ? $this->AvailableSeats : null;
    }
    /**
     * Set AvailableSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !(is_int($availableSeats) || ctype_digit($availableSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeats, true), gettype($availableSeats)), __LINE__);
        }
        if (is_null($availableSeats) || (is_array($availableSeats) && empty($availableSeats))) {
            unset($this->AvailableSeats);
        } else {
            $this->AvailableSeats = $availableSeats;
        }
        return $this;
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotingResultId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotingResultId()
    {
        return isset($this->BallotingResultId) ? $this->BallotingResultId : null;
    }
    /**
     * Set BallotingResultId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotingResultId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotingResultId($ballotingResultId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotingResultId) && !is_string($ballotingResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotingResultId, true), gettype($ballotingResultId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotingResultId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotingResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotingResultId, true)), __LINE__);
        }
        if (is_null($ballotingResultId) || (is_array($ballotingResultId) && empty($ballotingResultId))) {
            unset($this->BallotingResultId);
        } else {
            $this->BallotingResultId = $ballotingResultId;
        }
        return $this;
    }
    /**
     * Get BallotMinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotMinSeats()
    {
        return isset($this->BallotMinSeats) ? $this->BallotMinSeats : null;
    }
    /**
     * Set BallotMinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotMinSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotMinSeats($ballotMinSeats = null)
    {
        // validation for constraint: int
        if (!is_null($ballotMinSeats) && !(is_int($ballotMinSeats) || ctype_digit($ballotMinSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotMinSeats, true), gettype($ballotMinSeats)), __LINE__);
        }
        if (is_null($ballotMinSeats) || (is_array($ballotMinSeats) && empty($ballotMinSeats))) {
            unset($this->BallotMinSeats);
        } else {
            $this->BallotMinSeats = $ballotMinSeats;
        }
        return $this;
    }
    /**
     * Get BallotRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotRunMode()
    {
        return isset($this->BallotRunMode) ? $this->BallotRunMode : null;
    }
    /**
     * Set BallotRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotRunMode::valueIsValid()
     * @uses \patest\EnumType\BallotRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotRunMode
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotRunMode($ballotRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotRunMode::valueIsValid($ballotRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotRunMode', is_array($ballotRunMode) ? implode(', ', $ballotRunMode) : var_export($ballotRunMode, true), implode(', ', \patest\EnumType\BallotRunMode::getValidValues())), __LINE__);
        }
        if (is_null($ballotRunMode) || (is_array($ballotRunMode) && empty($ballotRunMode))) {
            unset($this->BallotRunMode);
        } else {
            $this->BallotRunMode = $ballotRunMode;
        }
        return $this;
    }
    /**
     * Get BallotVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotVersion()
    {
        return isset($this->BallotVersion) ? $this->BallotVersion : null;
    }
    /**
     * Set BallotVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotVersion::valueIsValid()
     * @uses \patest\EnumType\BallotVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotVersion
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setBallotVersion($ballotVersion = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotVersion::valueIsValid($ballotVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotVersion', is_array($ballotVersion) ? implode(', ', $ballotVersion) : var_export($ballotVersion, true), implode(', ', \patest\EnumType\BallotVersion::getValidValues())), __LINE__);
        }
        if (is_null($ballotVersion) || (is_array($ballotVersion) && empty($ballotVersion))) {
            unset($this->BallotVersion);
        } else {
            $this->BallotVersion = $ballotVersion;
        }
        return $this;
    }
    /**
     * Get ClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeId()
    {
        return isset($this->ClientTypeId) ? $this->ClientTypeId : null;
    }
    /**
     * Set ClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setClientTypeId($clientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeId) && !is_string($clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeId, true), gettype($clientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientTypeId, true)), __LINE__);
        }
        if (is_null($clientTypeId) || (is_array($clientTypeId) && empty($clientTypeId))) {
            unset($this->ClientTypeId);
        } else {
            $this->ClientTypeId = $clientTypeId;
        }
        return $this;
    }
    /**
     * Get ClientTypesFilterMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypesFilterMode()
    {
        return isset($this->ClientTypesFilterMode) ? $this->ClientTypesFilterMode : null;
    }
    /**
     * Set ClientTypesFilterMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientTypesFilterMode::valueIsValid()
     * @uses \patest\EnumType\ClientTypesFilterMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientTypesFilterMode
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setClientTypesFilterMode($clientTypesFilterMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientTypesFilterMode::valueIsValid($clientTypesFilterMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientTypesFilterMode', is_array($clientTypesFilterMode) ? implode(', ', $clientTypesFilterMode) : var_export($clientTypesFilterMode, true), implode(', ', \patest\EnumType\ClientTypesFilterMode::getValidValues())), __LINE__);
        }
        if (is_null($clientTypesFilterMode) || (is_array($clientTypesFilterMode) && empty($clientTypesFilterMode))) {
            unset($this->ClientTypesFilterMode);
        } else {
            $this->ClientTypesFilterMode = $clientTypesFilterMode;
        }
        return $this;
    }
    /**
     * Get CurrentApplicantsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentApplicantsCount()
    {
        return isset($this->CurrentApplicantsCount) ? $this->CurrentApplicantsCount : null;
    }
    /**
     * Set CurrentApplicantsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentApplicantsCount
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setCurrentApplicantsCount($currentApplicantsCount = null)
    {
        // validation for constraint: int
        if (!is_null($currentApplicantsCount) && !(is_int($currentApplicantsCount) || ctype_digit($currentApplicantsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentApplicantsCount, true), gettype($currentApplicantsCount)), __LINE__);
        }
        if (is_null($currentApplicantsCount) || (is_array($currentApplicantsCount) && empty($currentApplicantsCount))) {
            unset($this->CurrentApplicantsCount);
        } else {
            $this->CurrentApplicantsCount = $currentApplicantsCount;
        }
        return $this;
    }
    /**
     * Get DoesAssignRelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoesAssignRelatedClients()
    {
        return isset($this->DoesAssignRelatedClients) ? $this->DoesAssignRelatedClients : null;
    }
    /**
     * Set DoesAssignRelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doesAssignRelatedClients
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setDoesAssignRelatedClients($doesAssignRelatedClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($doesAssignRelatedClients) && !is_bool($doesAssignRelatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doesAssignRelatedClients, true), gettype($doesAssignRelatedClients)), __LINE__);
        }
        if (is_null($doesAssignRelatedClients) || (is_array($doesAssignRelatedClients) && empty($doesAssignRelatedClients))) {
            unset($this->DoesAssignRelatedClients);
        } else {
            $this->DoesAssignRelatedClients = $doesAssignRelatedClients;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IncludeWinnersInOtherSections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeWinnersInOtherSections()
    {
        return isset($this->IncludeWinnersInOtherSections) ? $this->IncludeWinnersInOtherSections : null;
    }
    /**
     * Set IncludeWinnersInOtherSections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\IncludeWinnersInOtherSectionsEnum::valueIsValid()
     * @uses \patest\EnumType\IncludeWinnersInOtherSectionsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeWinnersInOtherSections
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setIncludeWinnersInOtherSections($includeWinnersInOtherSections = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\IncludeWinnersInOtherSectionsEnum::valueIsValid($includeWinnersInOtherSections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\IncludeWinnersInOtherSectionsEnum', is_array($includeWinnersInOtherSections) ? implode(', ', $includeWinnersInOtherSections) : var_export($includeWinnersInOtherSections, true), implode(', ', \patest\EnumType\IncludeWinnersInOtherSectionsEnum::getValidValues())), __LINE__);
        }
        if (is_null($includeWinnersInOtherSections) || (is_array($includeWinnersInOtherSections) && empty($includeWinnersInOtherSections))) {
            unset($this->IncludeWinnersInOtherSections);
        } else {
            $this->IncludeWinnersInOtherSections = $includeWinnersInOtherSections;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MaxSeatsToWin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeatsToWin()
    {
        return isset($this->MaxSeatsToWin) ? $this->MaxSeatsToWin : null;
    }
    /**
     * Set MaxSeatsToWin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeatsToWin
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setMaxSeatsToWin($maxSeatsToWin = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeatsToWin) && !(is_int($maxSeatsToWin) || ctype_digit($maxSeatsToWin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeatsToWin, true), gettype($maxSeatsToWin)), __LINE__);
        }
        if (is_null($maxSeatsToWin) || (is_array($maxSeatsToWin) && empty($maxSeatsToWin))) {
            unset($this->MaxSeatsToWin);
        } else {
            $this->MaxSeatsToWin = $maxSeatsToWin;
        }
        return $this;
    }
    /**
     * Get MaxWinsPerBallot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxWinsPerBallot()
    {
        return isset($this->MaxWinsPerBallot) ? $this->MaxWinsPerBallot : null;
    }
    /**
     * Set MaxWinsPerBallot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxWinsPerBallot
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setMaxWinsPerBallot($maxWinsPerBallot = null)
    {
        // validation for constraint: int
        if (!is_null($maxWinsPerBallot) && !(is_int($maxWinsPerBallot) || ctype_digit($maxWinsPerBallot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxWinsPerBallot, true), gettype($maxWinsPerBallot)), __LINE__);
        }
        if (is_null($maxWinsPerBallot) || (is_array($maxWinsPerBallot) && empty($maxWinsPerBallot))) {
            unset($this->MaxWinsPerBallot);
        } else {
            $this->MaxWinsPerBallot = $maxWinsPerBallot;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mode
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mode, true), gettype($mode)), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Get NumOfAllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfAllocatedSeats()
    {
        return isset($this->NumOfAllocatedSeats) ? $this->NumOfAllocatedSeats : null;
    }
    /**
     * Set NumOfAllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfAllocatedSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfAllocatedSeats($numOfAllocatedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numOfAllocatedSeats) && !(is_int($numOfAllocatedSeats) || ctype_digit($numOfAllocatedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfAllocatedSeats, true), gettype($numOfAllocatedSeats)), __LINE__);
        }
        if (is_null($numOfAllocatedSeats) || (is_array($numOfAllocatedSeats) && empty($numOfAllocatedSeats))) {
            unset($this->NumOfAllocatedSeats);
        } else {
            $this->NumOfAllocatedSeats = $numOfAllocatedSeats;
        }
        return $this;
    }
    /**
     * Get NumOfApplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfApplications()
    {
        return isset($this->NumOfApplications) ? $this->NumOfApplications : null;
    }
    /**
     * Set NumOfApplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfApplications
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfApplications($numOfApplications = null)
    {
        // validation for constraint: int
        if (!is_null($numOfApplications) && !(is_int($numOfApplications) || ctype_digit($numOfApplications))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfApplications, true), gettype($numOfApplications)), __LINE__);
        }
        if (is_null($numOfApplications) || (is_array($numOfApplications) && empty($numOfApplications))) {
            unset($this->NumOfApplications);
        } else {
            $this->NumOfApplications = $numOfApplications;
        }
        return $this;
    }
    /**
     * Get NumOfCurrentApplicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfCurrentApplicants()
    {
        return isset($this->NumOfCurrentApplicants) ? $this->NumOfCurrentApplicants : null;
    }
    /**
     * Set NumOfCurrentApplicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfCurrentApplicants
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfCurrentApplicants($numOfCurrentApplicants = null)
    {
        // validation for constraint: int
        if (!is_null($numOfCurrentApplicants) && !(is_int($numOfCurrentApplicants) || ctype_digit($numOfCurrentApplicants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfCurrentApplicants, true), gettype($numOfCurrentApplicants)), __LINE__);
        }
        if (is_null($numOfCurrentApplicants) || (is_array($numOfCurrentApplicants) && empty($numOfCurrentApplicants))) {
            unset($this->NumOfCurrentApplicants);
        } else {
            $this->NumOfCurrentApplicants = $numOfCurrentApplicants;
        }
        return $this;
    }
    /**
     * Get NumOfCurrentWinners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfCurrentWinners()
    {
        return isset($this->NumOfCurrentWinners) ? $this->NumOfCurrentWinners : null;
    }
    /**
     * Set NumOfCurrentWinners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfCurrentWinners
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfCurrentWinners($numOfCurrentWinners = null)
    {
        // validation for constraint: int
        if (!is_null($numOfCurrentWinners) && !(is_int($numOfCurrentWinners) || ctype_digit($numOfCurrentWinners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfCurrentWinners, true), gettype($numOfCurrentWinners)), __LINE__);
        }
        if (is_null($numOfCurrentWinners) || (is_array($numOfCurrentWinners) && empty($numOfCurrentWinners))) {
            unset($this->NumOfCurrentWinners);
        } else {
            $this->NumOfCurrentWinners = $numOfCurrentWinners;
        }
        return $this;
    }
    /**
     * Get NumOfRequestedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfRequestedSeats()
    {
        return isset($this->NumOfRequestedSeats) ? $this->NumOfRequestedSeats : null;
    }
    /**
     * Set NumOfRequestedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfRequestedSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfRequestedSeats($numOfRequestedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numOfRequestedSeats) && !(is_int($numOfRequestedSeats) || ctype_digit($numOfRequestedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfRequestedSeats, true), gettype($numOfRequestedSeats)), __LINE__);
        }
        if (is_null($numOfRequestedSeats) || (is_array($numOfRequestedSeats) && empty($numOfRequestedSeats))) {
            unset($this->NumOfRequestedSeats);
        } else {
            $this->NumOfRequestedSeats = $numOfRequestedSeats;
        }
        return $this;
    }
    /**
     * Get NumOfWonSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfWonSeats()
    {
        return isset($this->NumOfWonSeats) ? $this->NumOfWonSeats : null;
    }
    /**
     * Set NumOfWonSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfWonSeats
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setNumOfWonSeats($numOfWonSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numOfWonSeats) && !(is_int($numOfWonSeats) || ctype_digit($numOfWonSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfWonSeats, true), gettype($numOfWonSeats)), __LINE__);
        }
        if (is_null($numOfWonSeats) || (is_array($numOfWonSeats) && empty($numOfWonSeats))) {
            unset($this->NumOfWonSeats);
        } else {
            $this->NumOfWonSeats = $numOfWonSeats;
        }
        return $this;
    }
    /**
     * Get ResultStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultStatus()
    {
        return isset($this->ResultStatus) ? $this->ResultStatus : null;
    }
    /**
     * Set ResultStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotingResultStatusEnum::valueIsValid()
     * @uses \patest\EnumType\BallotingResultStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultStatus
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setResultStatus($resultStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotingResultStatusEnum::valueIsValid($resultStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotingResultStatusEnum', is_array($resultStatus) ? implode(', ', $resultStatus) : var_export($resultStatus, true), implode(', ', \patest\EnumType\BallotingResultStatusEnum::getValidValues())), __LINE__);
        }
        if (is_null($resultStatus) || (is_array($resultStatus) && empty($resultStatus))) {
            unset($this->ResultStatus);
        } else {
            $this->ResultStatus = $resultStatus;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get SelectedClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedClientTypeIds()
    {
        return isset($this->SelectedClientTypeIds) ? $this->SelectedClientTypeIds : null;
    }
    /**
     * Set SelectedClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedClientTypeIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setSelectedClientTypeIds($selectedClientTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedClientTypeIds) && !is_string($selectedClientTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedClientTypeIds, true), gettype($selectedClientTypeIds)), __LINE__);
        }
        if (is_null($selectedClientTypeIds) || (is_array($selectedClientTypeIds) && empty($selectedClientTypeIds))) {
            unset($this->SelectedClientTypeIds);
        } else {
            $this->SelectedClientTypeIds = $selectedClientTypeIds;
        }
        return $this;
    }
    /**
     * Get SelectedSectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedSectionIds()
    {
        return isset($this->SelectedSectionIds) ? $this->SelectedSectionIds : null;
    }
    /**
     * Set SelectedSectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedSectionIds
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setSelectedSectionIds($selectedSectionIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedSectionIds) && !is_string($selectedSectionIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedSectionIds, true), gettype($selectedSectionIds)), __LINE__);
        }
        if (is_null($selectedSectionIds) || (is_array($selectedSectionIds) && empty($selectedSectionIds))) {
            unset($this->SelectedSectionIds);
        } else {
            $this->SelectedSectionIds = $selectedSectionIds;
        }
        return $this;
    }
    /**
     * Get TemporaryTransactionIdsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemporaryTransactionIdsList()
    {
        return isset($this->TemporaryTransactionIdsList) ? $this->TemporaryTransactionIdsList : null;
    }
    /**
     * Set TemporaryTransactionIdsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $temporaryTransactionIdsList
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setTemporaryTransactionIdsList($temporaryTransactionIdsList = null)
    {
        // validation for constraint: string
        if (!is_null($temporaryTransactionIdsList) && !is_string($temporaryTransactionIdsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temporaryTransactionIdsList, true), gettype($temporaryTransactionIdsList)), __LINE__);
        }
        if (is_null($temporaryTransactionIdsList) || (is_array($temporaryTransactionIdsList) && empty($temporaryTransactionIdsList))) {
            unset($this->TemporaryTransactionIdsList);
        } else {
            $this->TemporaryTransactionIdsList = $temporaryTransactionIdsList;
        }
        return $this;
    }
    /**
     * Get UseTicketReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseTicketReservation()
    {
        return isset($this->UseTicketReservation) ? $this->UseTicketReservation : null;
    }
    /**
     * Set UseTicketReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useTicketReservation
     * @return \patest\StructType\BizAction_Ticketing_ProcessSection_Request
     */
    public function setUseTicketReservation($useTicketReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTicketReservation) && !is_bool($useTicketReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useTicketReservation, true), gettype($useTicketReservation)), __LINE__);
        }
        if (is_null($useTicketReservation) || (is_array($useTicketReservation) && empty($useTicketReservation))) {
            unset($this->UseTicketReservation);
        } else {
            $this->UseTicketReservation = $useTicketReservation;
        }
        return $this;
    }
}
